/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.logging.Level;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoicePaySchedule;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class InvoicePayScheduleValidate
extends SvrProcess {
    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("C_InvoicePaySchedule_ID=" + this.getRecord_ID());
        MInvoicePaySchedule[] schedule = MInvoicePaySchedule.getInvoicePaySchedule(this.getCtx(), 0, this.getRecord_ID(), null);
        if (schedule.length == 0) {
            throw new IllegalArgumentException("InvoicePayScheduleValidate - No Schedule");
        }
        MInvoice invoice = new MInvoice(this.getCtx(), schedule[0].getC_Invoice_ID(), null);
        if (invoice.get_ID() == 0) {
            throw new IllegalArgumentException("InvoicePayScheduleValidate - No Invoice");
        }
        BigDecimal total = Env.ZERO;
        for (int i = 0; i < schedule.length; ++i) {
            BigDecimal due = schedule[i].getDueAmt();
            if (due == null) continue;
            total = total.add(due);
        }
        boolean valid = invoice.getGrandTotal().compareTo(total) == 0;
        invoice.setIsPayScheduleValid(valid);
        invoice.saveEx();
        for (int i = 0; i < schedule.length; ++i) {
            if (schedule[i].isValid() == valid) continue;
            schedule[i].setIsValid(valid);
            schedule[i].saveEx();
        }
        Object msg = "@OK@";
        if (!valid) {
            msg = "@GrandTotal@ = " + invoice.getGrandTotal() + " <> @Total@ = " + total + "  - @Difference@ = " + invoice.getGrandTotal().subtract(total);
        }
        return Msg.parseTranslation(this.getCtx(), (String)msg);
    }
}

