/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import org.compiere.model.MMigration;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

public class MigrationMerge
extends SvrProcess {
    private MMigration migrationFrom;
    private MMigration migrationTo;

    @Override
    protected String doIt() throws Exception {
        if (this.migrationFrom == null || this.migrationFrom.is_new() || this.migrationTo == null || this.migrationTo.is_new() || this.migrationFrom.getAD_Migration_ID() == this.migrationTo.getAD_Migration_ID()) {
            this.addLog("Two different existing migrations required for merge");
            return "@Error@";
        }
        this.migrationTo.mergeMigration(this.migrationFrom);
        return "@OK@";
    }

    @Override
    protected void prepare() {
        ProcessInfoParameter[] params;
        int fromId = 0;
        int toId = 0;
        for (ProcessInfoParameter p : params = this.getParameter()) {
            String para = p.getParameterName();
            if (para.equals("AD_Migration_ID")) {
                fromId = p.getParameterAsInt();
                continue;
            }
            if (!para.equals("AD_MigrationTo_ID")) continue;
            toId = p.getParameterAsInt();
        }
        if (toId == 0) {
            toId = this.getRecord_ID();
        }
        this.migrationTo = new MMigration(this.getCtx(), toId, this.get_TrxName());
        this.migrationFrom = new MMigration(this.getCtx(), fromId, this.get_TrxName());
    }
}

