/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MLocator;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MRefList;
import org.compiere.model.MStorage;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class StorageCleanup
extends SvrProcess {
    private int p_C_DocType_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("C_DocType_ID")) {
                this.p_C_DocType_ID = para[i].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doIt() throws Exception {
        this.log.info("");
        String sql = "DELETE FROM M_Storage WHERE QtyOnHand = 0 AND QtyReserved = 0 AND QtyOrdered = 0 AND Created < SysDate-3";
        int no = DB.executeUpdate(sql, this.get_TrxName());
        this.log.info("Delete Empty #" + no);
        sql = "SELECT * FROM M_Storage s WHERE AD_Client_ID = ? AND QtyOnHand < 0 AND EXISTS (SELECT * FROM M_Storage sl WHERE sl.QtyOnHand > 0 AND s.M_Product_ID=sl.M_Product_ID AND s.M_Locator_ID=sl.M_Locator_ID) AND EXISTS (SELECT * FROM M_Storage sw INNER JOIN M_Locator swl ON (sw.M_Locator_ID=swl.M_Locator_ID), M_Locator sl WHERE sw.QtyOnHand > 0 AND s.M_Product_ID=sw.M_Product_ID AND s.M_Locator_ID=sl.M_Locator_ID AND sl.M_Warehouse_ID=swl.M_Warehouse_ID)";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int lines = 0;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, Env.getAD_Client_ID(this.getCtx()));
            rs = pstmt.executeQuery();
            while (rs.next()) {
                lines += this.move(new MStorage(this.getCtx(), rs, this.get_TrxName()));
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return "#" + lines;
    }

    private int move(MStorage target) {
        this.log.info(target.toString());
        BigDecimal qty = target.getQtyOnHand().negate();
        MMovement mh = null;
        MStorage[] sources = this.getSources(target.getM_Product_ID(), target.getM_Locator_ID());
        if (sources.length > 0) {
            mh = new MMovement(this.getCtx(), 0, this.get_TrxName());
            mh.setAD_Org_ID(target.getAD_Org_ID());
            mh.setC_DocType_ID(this.p_C_DocType_ID);
            mh.setDescription(this.getName());
            if (!mh.save()) {
                return 0;
            }
        } else {
            return 0;
        }
        int lines = 0;
        for (int i = 0; i < sources.length; ++i) {
            MStorage source = sources[i];
            MMovementLine ml = new MMovementLine(mh);
            ml.setM_Product_ID(target.getM_Product_ID());
            ml.setM_LocatorTo_ID(target.getM_Locator_ID());
            ml.setM_AttributeSetInstanceTo_ID(target.getM_AttributeSetInstance_ID());
            ml.setM_Locator_ID(source.getM_Locator_ID());
            ml.setM_AttributeSetInstance_ID(source.getM_AttributeSetInstance_ID());
            BigDecimal qtyMove = qty;
            if (qtyMove.compareTo(source.getQtyOnHand()) > 0) {
                qtyMove = source.getQtyOnHand();
            }
            ml.setMovementQty(qtyMove);
            ml.setLine(++lines * 10);
            if (!ml.save()) {
                return 0;
            }
            if ((qty = qty.subtract(qtyMove)).signum() <= 0) break;
        }
        mh.processIt("CO");
        mh.saveEx();
        this.addLog(0, null, new BigDecimal(lines), "@M_Movement_ID@ " + mh.getDocumentNo() + " (" + MRefList.get(this.getCtx(), 131, mh.getDocStatus(), this.get_TrxName()) + ")");
        this.eliminateReservation(target);
        return lines;
    }

    private void eliminateReservation(MStorage target) {
        if (target.getQtyReserved().signum() != 0 || target.getQtyOrdered().signum() != 0) {
            MLocator defaultLoc;
            int M_Locator_ID = target.getM_Locator_ID();
            MStorage storage0 = MStorage.get(this.getCtx(), M_Locator_ID, target.getM_Product_ID(), 0, this.get_TrxName());
            if (storage0 == null && M_Locator_ID != (defaultLoc = MLocator.getDefault(this.getCtx(), M_Locator_ID)).getM_Locator_ID()) {
                M_Locator_ID = defaultLoc.getM_Locator_ID();
                storage0 = MStorage.get(this.getCtx(), M_Locator_ID, target.getM_Product_ID(), 0, this.get_TrxName());
            }
            if (storage0 != null) {
                BigDecimal reserved = Env.ZERO;
                BigDecimal ordered = Env.ZERO;
                if (target.getQtyReserved().add(storage0.getQtyReserved()).signum() >= 0) {
                    reserved = target.getQtyReserved();
                }
                if (target.getQtyOrdered().add(storage0.getQtyOrdered()).signum() >= 0) {
                    ordered = target.getQtyOrdered();
                }
                if (reserved.signum() != 0 || ordered.signum() != 0) {
                    if (MStorage.add(this.getCtx(), target.getM_Warehouse_ID(), target.getM_Locator_ID(), target.getM_Product_ID(), target.getM_AttributeSetInstance_ID(), target.getM_AttributeSetInstance_ID(), Env.ZERO, reserved.negate(), ordered.negate(), this.get_TrxName())) {
                        if (MStorage.add(this.getCtx(), storage0.getM_Warehouse_ID(), storage0.getM_Locator_ID(), storage0.getM_Product_ID(), storage0.getM_AttributeSetInstance_ID(), storage0.getM_AttributeSetInstance_ID(), Env.ZERO, reserved, ordered, this.get_TrxName())) {
                            this.log.info("Reserved=" + reserved + ",Ordered=" + ordered);
                        } else {
                            this.log.warning("Failed Storage0 Update");
                        }
                    } else {
                        this.log.warning("Failed Target Update");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MStorage[] getSources(int M_Product_ID, int M_Locator_ID) {
        ArrayList<MStorage> list = new ArrayList<MStorage>();
        String sql = "SELECT * FROM M_Storage s WHERE QtyOnHand > 0 AND M_Product_ID=? AND (M_AttributeSetInstance_ID=0  OR EXISTS (SELECT * FROM M_AttributeSetInstance asi \tRIGHT OUTER JOIN M_AttributeSet mas ON (asi.M_AttributeSet_ID = mas.M_AttributeSet_ID) \tWHERE s.M_AttributeSetInstance_ID=asi.M_AttributeSetInstance_ID \tAND (mas.M_AttributeSet_ID IS NULL OR mas.isinstanceattribute = 'N'))) AND EXISTS (SELECT * FROM M_Locator sl, M_Locator x WHERE s.M_Locator_ID=sl.M_Locator_ID AND x.M_Locator_ID=? AND sl.M_Warehouse_ID=x.M_Warehouse_ID) ORDER BY M_AttributeSetInstance_ID";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, M_Product_ID);
            pstmt.setInt(2, M_Locator_ID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MStorage(this.getCtx(), rs, this.get_TrxName()));
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MStorage[] retValue = new MStorage[list.size()];
        list.toArray(retValue);
        return retValue;
    }
}

