/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceTax;
import org.compiere.model.MTaxDeclaration;
import org.compiere.model.MTaxDeclarationAcct;
import org.compiere.model.MTaxDeclarationLine;
import org.compiere.process.TaxDeclarationCreateAbstract;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class TaxDeclarationCreate
extends TaxDeclarationCreateAbstract {
    private MTaxDeclaration taxDeclaration = null;
    private int m_noLines = 0;
    private int m_noAccts = 0;

    @Override
    protected void prepare() {
        super.prepare();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doIt() throws Exception {
        this.log.info("C_TaxDeclaration_ID=" + this.getRecord_ID());
        this.taxDeclaration = new MTaxDeclaration(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        if (this.taxDeclaration.get_ID() == 0) {
            throw new AdempiereSystemError("@NotFound@ @C_TaxDeclaration_ID@ = " + this.getRecord_ID());
        }
        if (this.isDeleteOld()) {
            String sql = "DELETE C_TaxDeclarationLine WHERE C_TaxDeclaration_ID=?";
            int no = DB.executeUpdate(sql, this.taxDeclaration.getC_TaxDeclaration_ID(), false, this.get_TrxName());
            if (no != 0) {
                this.log.config("Delete Line #" + no);
            }
            if ((no = DB.executeUpdate(sql = "DELETE C_TaxDeclarationAcct WHERE C_TaxDeclaration_ID=?", this.taxDeclaration.getC_TaxDeclaration_ID(), false, this.get_TrxName())) != 0) {
                this.log.config("Delete Acct #" + no);
            }
        }
        StringBuffer sqlCreate = new StringBuffer("SELECT * FROM C_Invoice i WHERE AD_Client_ID=? ");
        if (this.isUseDateAcct()) {
            sqlCreate.append(" AND TRUNC(i.DateAcct, 'DD') >= ? AND TRUNC(i.DateAcct, 'DD') <= ? ");
        } else {
            sqlCreate.append(" AND TRUNC(i.DateInvoiced, 'DD') >= ? AND TRUNC(i.DateInvoiced, 'DD') <= ? ");
        }
        sqlCreate.append(" AND Processed = 'Y' ");
        if (this.isOnlyPosted()) {
            sqlCreate.append(" AND i.Posted = 'Y' ");
        }
        sqlCreate.append(" AND NOT EXISTS (SELECT * FROM C_TaxDeclarationLine tdl WHERE i.C_Invoice_ID=tdl.C_Invoice_ID) ORDER BY i.issotrx, i.dateacct ");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int noInvoices = 0;
        try {
            pstmt = DB.prepareStatement(sqlCreate.toString(), this.get_TrxName());
            pstmt.setInt(1, Env.getAD_Client_ID(this.getCtx()));
            pstmt.setTimestamp(2, this.taxDeclaration.getDateFrom());
            pstmt.setTimestamp(3, this.taxDeclaration.getDateTo());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                this.create(new MInvoice(this.getCtx(), rs, null));
                ++noInvoices;
            }
        }
        catch (Exception e) {
            try {
                this.log.log(Level.SEVERE, sqlCreate.toString(), e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return "@C_Invoice_ID@ #" + noInvoices + " (" + this.m_noLines + ", " + this.m_noAccts + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void create(MInvoice invoice) {
        MInvoiceTax[] taxes = invoice.getTaxes(false);
        for (int i = 0; i < taxes.length; ++i) {
            MInvoiceTax tLine = taxes[i];
            MTaxDeclarationLine tdl = new MTaxDeclarationLine(this.taxDeclaration, invoice, tLine);
            tdl.setLine((this.m_noLines + 1) * 10);
            if (!tdl.save()) continue;
            ++this.m_noLines;
        }
        String sql = "SELECT * FROM Fact_Acct WHERE AD_Table_ID=? AND Record_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, MInvoice.Table_ID);
            pstmt.setInt(2, invoice.getC_Invoice_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MFactAcct fact = new MFactAcct(this.getCtx(), rs, null);
                MTaxDeclarationAcct tda = new MTaxDeclarationAcct(this.taxDeclaration, fact);
                tda.setLine((this.m_noAccts + 1) * 10);
                if (!tda.save()) continue;
                ++this.m_noAccts;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
    }
}

