/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class UniversalSubstitution
extends SvrProcess {
    int productId = 0;
    int replacementId = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (name.equals("M_Product_ID")) {
                this.productId = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("Substitute_ID")) {
                this.replacementId = para[i].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (this.productId == 0 || this.replacementId == 0) {
            throw new AdempiereException("Product and replacement product required");
        }
        String update = "UPDATE PP_Product_BOMLine bb SET M_PRODUCT_ID = ? WHERE bb.M_PRODUCT_ID = ?";
        CPreparedStatement pstmt = DB.prepareStatement(update, this.get_TrxName());
        pstmt.setInt(1, this.replacementId);
        pstmt.setInt(2, this.productId);
        int count = pstmt.executeUpdate();
        return count + " BOM products updated";
    }
}

