/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.report;

import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.Tuple;
import io.vavr.control.Try;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import org.compiere.model.MAccount;
import org.compiere.model.MAttachment;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MClientInfo;
import org.compiere.model.MImage;
import org.compiere.model.MLocation;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPeriod;
import org.compiere.model.MReportCube;
import org.compiere.model.MYear;
import org.compiere.print.MPrintFormat;
import org.compiere.print.MPrintFormatItem;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.report.FinReportAbstract;
import org.compiere.report.FinReportPeriod;
import org.compiere.report.MReport;
import org.compiere.report.MReportColumn;
import org.compiere.report.MReportLine;
import org.compiere.report.MReportSource;
import org.compiere.report.MReportTree;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CLogMgt;
import org.compiere.util.CacheMgt;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.ResultSetIterable;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.util.Util;

public class FinReport
extends FinReportAbstract {
    private long start = System.currentTimeMillis();
    private MReport finReport = null;
    private io.vavr.collection.List<FinReportPeriod> finReportPeriods;
    private int reportPeriod = -1;
    private StringBuffer parameterWhere = new StringBuffer();
    private MReportColumn[] reportColumns;
    private MReportLine[] reportLines;
    private static String INSERT = "INSERT";
    private static String UPDATE = "UPDATE";

    @Override
    protected void prepare() {
        super.prepare();
        StringBuilder financialReportInfo = new StringBuilder("Record_ID=").append(this.getRecord_ID());
        this.buildParametersWhere();
        this.finReport = this.getFinancialReport(this.getCtx(), this.get_TrxName());
        financialReportInfo.append(" - ").append(this.finReport);
        this.setPeriods();
        financialReportInfo.append(" - C_Period_ID=").append(this.getPeriodId()).append(" - ").append(this.parameterWhere);
        ProcessInfoParameter[] pi = this.getProcessInfo().getParameter();
        pi[0].setParameter(this.getPeriodId());
        this.getProcessInfo().setParameter(pi);
        this.log.info(financialReportInfo.toString());
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("AD_PInstance_ID=" + this.getAD_PInstance_ID());
        this.loadAndUpdateCube();
        int no = this.createTemporaryAndEmptyReportLines();
        this.log.fine("Report Lines = " + no);
        this.reportColumns = this.finReport.getColumnSet().getColumns();
        if (this.reportColumns.length == 0) {
            throw new AdempiereUserError("@No@ @PA_ReportColumn_ID@");
        }
        this.reportLines = this.finReport.getLineSet().getLines();
        if (this.reportLines.length == 0) {
            throw new AdempiereUserError("@No@ @PA_ReportLine_ID@");
        }
        for (MReportLine reportLine : this.reportLines) {
            Trx.run(trxName -> {
                reportLine.set_TrxName(trxName);
                if (reportLine.isLineTypeSegmentValue()) {
                    this.insertLine(reportLine);
                }
            });
        }
        this.insertLineDetail();
        this.doCalculations();
        this.deleteUnprintedLines();
        this.scaleResults();
        if (Ini.isClient()) {
            this.getProcessInfo().setTransientObject(this.getPrintFormat());
        } else if (this.getProcessInfo().getSerializableObject() != null) {
            MPrintFormat format = null;
            Serializable so = this.getProcessInfo().getSerializableObject();
            if (so instanceof MPrintFormat) {
                format = (MPrintFormat)so;
            }
            if (format != null) {
                this.finReport.setAD_PrintFormat_ID(format.getAD_PrintFormat_ID());
            }
        } else {
            this.getProcessInfo().setSerializableObject(this.getPrintFormat());
        }
        this.log.fine(System.currentTimeMillis() - this.start + " ms");
        return "";
    }

    private int createTemporaryAndEmptyReportLines() {
        Try createTemporaryAndEmptyReportLines = Try.of((CheckedFunction0 & Serializable)() -> {
            AtomicInteger reportLines = new AtomicInteger();
            Trx.run(trxName -> {
                int reportLineSetId = this.finReport.getLineSet().getPA_ReportLineSet_ID();
                String createTemporaryAndEmptyReportLinesSQL = "INSERT INTO T_Report (AD_PInstance_ID, PA_ReportLine_ID, Record_ID,Fact_Acct_ID, SeqNo,LevelNo, Name,Description,TabLevel, ReportLineStyle, FixedPercentage) SELECT " + this.getAD_PInstance_ID() + ", PA_ReportLine_ID, 0,0, SeqNo,0, Name,Description,TabLevel,ReportLineStyle,FixedPercentage FROM PA_ReportLine WHERE IsActive = ? AND PA_ReportLineSet_ID = ? ";
                reportLines.set(DB.executeUpdateEx(createTemporaryAndEmptyReportLinesSQL, io.vavr.collection.List.of((Object[])new Serializable[]{"Y", Integer.valueOf(reportLineSetId)}).toJavaArray(), trxName));
            });
            return reportLines.get();
        });
        createTemporaryAndEmptyReportLines.onFailure(throwable -> {
            this.addLog(throwable.getMessage());
            this.log.severe(throwable.getMessage());
        });
        int reportLines = (Integer)createTemporaryAndEmptyReportLines.get();
        if (reportLines <= 0) {
            this.addLog("@PA_ReportLine_ID@ @NotFound@");
        }
        return reportLines;
    }

    private void loadAndUpdateCube() {
        if (this.getReportCubeId() > 0) {
            Trx.run(trxName -> {
                MReportCube cube = new MReportCube(this.getCtx(), this.getReportCubeId(), trxName);
                String result = cube.update(false, false);
                this.log.log(Level.FINE, result);
            });
        }
    }

    private MReport getFinancialReport(Properties ctx, String trxName) {
        return new MReport(ctx, this.getRecord_ID(), trxName);
    }

    private void buildParametersWhere() {
        if (this.getOrgId() != 0) {
            this.parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.getHierarchyId(), "OO", this.getOrgId()));
        }
        if (this.getBPartnerId() != 0) {
            this.parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.getHierarchyId(), "BP", this.getBPartnerId()));
        }
        if (this.getProductId() != 0) {
            this.parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.getHierarchyId(), "PR", this.getProductId()));
        }
        if (this.getProjectId() != 0) {
            this.parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.getHierarchyId(), "PJ", this.getProjectId()));
        }
        if (this.getActivityId() != 0) {
            this.parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.getHierarchyId(), "AY", this.getActivityId()));
        }
        if (this.getCampaignId() != 0) {
            this.parameterWhere.append(" AND C_Campaign_ID=").append(this.getCampaignId());
        }
        if (this.getSalesRegionId() != 0) {
            this.parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.getHierarchyId(), "SR", this.getSalesRegionId()));
        }
        if (this.getUser1Id() != 0) {
            this.parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.getHierarchyId(), "U1", this.getUser1Id()));
        }
        if (this.getUser2Id() != 0) {
            this.parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.getHierarchyId(), "U2", this.getUser2Id()));
        }
        if (this.getUser3Id() != 0) {
            this.parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.getHierarchyId(), "U3", this.getUser3Id()));
        }
        if (this.getUser4Id() != 0) {
            this.parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.getHierarchyId(), "U4", this.getUser4Id()));
        }
        if (this.getUserElement1Id() != 0) {
            this.parameterWhere.append(" AND UserElement1_ID=").append(this.getUserElement1Id());
        }
        if (this.getUserElement2Id() != 0) {
            this.parameterWhere.append(" AND UserElement2_ID=").append(this.getUserElement2Id());
        }
    }

    private String getWhereClause() {
        Object whereClause = this.parameterWhere.toString();
        if (this.getReportCubeId() > 0) {
            whereClause = (String)whereClause + " AND PA_ReportCube_ID=" + this.getReportCubeId();
        }
        return whereClause;
    }

    private String getWhereClauseForTrx() {
        return this.parameterWhere.toString();
    }

    private String getWherePostingType(boolean withAND) {
        String postingType = this.getPostingType();
        int budgetId = this.getBudgetId();
        StringBuilder whereClause = new StringBuilder();
        if (!Util.isEmpty(postingType)) {
            if (withAND) {
                whereClause.append(" AND ");
            }
            whereClause.append("PostingType='").append(postingType).append("' ");
            if (postingType.equals("B") && budgetId > 0) {
                whereClause.append(" AND GL_Budget_ID=").append(budgetId);
            }
        }
        return whereClause.toString();
    }

    private void setPeriods() {
        this.log.info("C_Calendar_ID=" + this.finReport.getC_Calendar_ID());
        ArrayList reportPeriods = new ArrayList();
        Timestamp today = TimeUtil.getDay(System.currentTimeMillis());
        String getPeriodSQL = "SELECT p.C_Period_ID, p.Name, p.StartDate, p.EndDate, MIN(p1.StartDate) AS YearStartDate , p.PeriodType FROM C_Period p  INNER JOIN C_Year y ON (p.C_Year_ID=y.C_Year_ID), C_Period p1 WHERE y.C_Calendar_ID=?  AND p1.C_Year_ID=y.C_Year_ID AND p1.PeriodType IN ( ? , ? ) GROUP BY p.C_Period_ID, p.Name, p.StartDate, p.EndDate , p.PeriodType ORDER BY p.StartDate";
        ((Try)DB.runResultSetFunction.apply(null, (Object)"SELECT p.C_Period_ID, p.Name, p.StartDate, p.EndDate, MIN(p1.StartDate) AS YearStartDate , p.PeriodType FROM C_Period p  INNER JOIN C_Year y ON (p.C_Year_ID=y.C_Year_ID), C_Period p1 WHERE y.C_Calendar_ID=?  AND p1.C_Year_ID=y.C_Year_ID AND p1.PeriodType IN ( ? , ? ) GROUP BY p.C_Period_ID, p.Name, p.StartDate, p.EndDate , p.PeriodType ORDER BY p.StartDate", (Object)io.vavr.collection.List.of((Object[])new Object[]{this.finReport.getC_Calendar_ID(), "S", "A"}), resultSet -> {
            io.vavr.collection.List periods = new ResultSetIterable((ResultSet)resultSet, (CheckedFunction1 & Serializable)row -> new FinReportPeriod(row.getInt("C_Period_ID"), row.getString("Name"), row.getTimestamp("StartDate"), row.getTimestamp("EndDate"), row.getTimestamp("YearStartDate"), row.getString("PeriodType"))).toList();
            periods.forEach(period -> {
                reportPeriods.add(period);
                if (this.getPeriodId() == 0 && period.inPeriod(today)) {
                    this.setPeriodId(period.getC_Period_ID());
                }
            });
        })).onFailure(throwable -> this.log.severe(throwable.getMessage()));
        this.finReportPeriods = io.vavr.collection.List.ofAll(reportPeriods);
        if (this.getPeriodId() == 0) {
            this.finReportPeriods.headOption().peek(period -> this.setPeriodId(period.getC_Period_ID()));
        }
    }

    private void insertLine(MReportLine reportLine) {
        String whereReport;
        this.log.info("" + reportLine);
        if (reportLine == null || reportLine.getSources().length == 0) {
            this.log.warning("No Source lines: " + reportLine);
            return;
        }
        StringBuilder whereClause = new StringBuilder();
        String whereReportLine = reportLine.getWhereClause(this.getHierarchyId(), this.getWherePostingType(false));
        if (whereReportLine != null && whereReportLine.length() > 0) {
            whereClause.append(whereReportLine);
        }
        if ((whereReport = this.finReport.getWhereClause()) != null && whereReport.length() > 0) {
            whereClause.append(" AND ").append(whereReport);
            whereClause.append(this.getWhereClause());
        }
        Trx.run(trxName -> {
            StringBuilder sqlStatementColumn = new StringBuilder(this.getColumnStatement(UPDATE, reportLine, whereClause.toString(), false));
            StringBuilder sqlStatementReport = new StringBuilder("UPDATE T_Report SET ");
            int levelNo = 2;
            if (sqlStatementColumn.length() > 0) {
                sqlStatementColumn.append(" WHERE AD_PInstance_ID = ? ").append(" AND PA_ReportLine_ID =  ? ").append(" AND ABS(LevelNo) < ?");
                sqlStatementReport.append((CharSequence)sqlStatementColumn);
                int no = DB.executeUpdateEx(sqlStatementReport.toString(), io.vavr.collection.List.of((Object[])new Integer[]{this.getAD_PInstance_ID(), reportLine.getPA_ReportLine_ID(), 2}).toJavaArray(), trxName);
                if (no != 1) {
                    this.log.log(Level.SEVERE, "#=" + no + " for " + sqlStatementReport);
                }
                this.log.finest(sqlStatementReport.toString());
            }
        });
    }

    private void doCalculations() {
        for (MReportLine reportLine : this.reportLines) {
            if (!reportLine.isLineTypeCalculation()) continue;
            int operation_1 = reportLine.getOper_1_ID();
            int operation_2 = reportLine.getOper_2_ID();
            this.log.fine("Line " + reportLine.getSeqNo() + " = #" + operation_1 + " " + reportLine.getCalculationType() + " #" + operation_2);
            if (reportLine.isCalculationTypeAdd() || reportLine.isCalculationTypeRange()) {
                if (operation_1 > operation_2) {
                    int temp = operation_1;
                    operation_1 = operation_2;
                    operation_2 = temp;
                }
                this.addCalculations(reportLine, operation_1, operation_2);
                continue;
            }
            int no = this.getFirstValueOrZeroInThere(reportLine, operation_1);
            if (no != 1) continue;
            this.getSecondValue(reportLine, operation_2);
        }
        for (int col = 0; col < this.reportColumns.length; ++col) {
            if (!this.reportColumns[col].isColumnTypeCalculation()) continue;
            this.getOnlyCalculations(col);
        }
        this.getToggleOppositeSign();
    }

    private void addCalculations(MReportLine reportLine, int operation_1, int operation_2) {
        Trx.run(trxName -> {
            int col;
            reportLine.set_TrxName(trxName);
            StringBuilder updateReportLine = new StringBuilder("UPDATE T_Report SET (");
            for (col = 0; col < this.reportColumns.length; ++col) {
                if (col > 0) {
                    updateReportLine.append(",");
                }
                updateReportLine.append("Col_").append(col);
            }
            updateReportLine.append(") = (SELECT ");
            for (col = 0; col < this.reportColumns.length; ++col) {
                if (col > 0) {
                    updateReportLine.append(",");
                }
                updateReportLine.append("COALESCE(SUM(r2.Col_").append(col).append("),0)");
            }
            updateReportLine.append(" FROM T_Report r2 WHERE r2.AD_PInstance_ID = ").append(this.getAD_PInstance_ID()).append(" AND r2.PA_ReportLine_ID IN (");
            if (reportLine.isCalculationTypeAdd()) {
                updateReportLine.append(operation_1).append(",").append(operation_2);
            } else {
                updateReportLine.append(this.getLineIds(operation_1, operation_2));
            }
            updateReportLine.append(") AND ABS(r2.LevelNo) < 1 ) WHERE AD_PInstance_ID = ? ").append(" AND PA_ReportLine_ID = ? ").append(" AND ABS(LevelNo) < ? ");
            boolean levelNo = true;
            int no = DB.executeUpdateEx(updateReportLine.toString(), io.vavr.collection.List.of((Object[])new Integer[]{this.getAD_PInstance_ID(), reportLine.getPA_ReportLine_ID(), 1}).toJavaArray(), trxName);
            if (no != 1) {
                this.log.log(Level.SEVERE, "(+) #=" + no + " for " + reportLine + " - " + updateReportLine.toString());
            } else {
                this.log.fine("(+) Line=" + reportLine.getSeqNo() + " - " + reportLine);
                this.log.finest("(+) " + updateReportLine.toString());
            }
        });
    }

    private int getFirstValueOrZeroInThere(MReportLine reportLine, int operation_1) {
        AtomicInteger rows = new AtomicInteger(0);
        Trx.run(trxName -> {
            int col;
            StringBuilder updateReportLine = new StringBuilder("UPDATE T_Report SET (");
            for (col = 0; col < this.reportColumns.length; ++col) {
                if (col > 0) {
                    updateReportLine.append(",");
                }
                updateReportLine.append("Col_").append(col);
            }
            updateReportLine.append(") = (SELECT ");
            for (col = 0; col < this.reportColumns.length; ++col) {
                if (col > 0) {
                    updateReportLine.append(",");
                }
                updateReportLine.append("COALESCE(r2.Col_").append(col).append(",0)");
            }
            updateReportLine.append(" FROM T_Report r2 WHERE r2.AD_PInstance_ID = ?").append(" AND r2.PA_ReportLine_ID = ? ").append(" AND r2.Record_ID = ? AND r2.Fact_Acct_ID = ?) WHERE AD_PInstance_ID = ? ").append(" AND PA_ReportLine_ID = ? ").append(" AND ABS(LevelNo) < ? ");
            boolean levelNo = true;
            int no = DB.executeUpdateEx(updateReportLine.toString(), io.vavr.collection.List.of((Object[])new Integer[]{this.getAD_PInstance_ID(), operation_1, 0, 0, this.getAD_PInstance_ID(), reportLine.getPA_ReportLine_ID(), 1}).toJavaArray(), trxName);
            if (no != 1) {
                this.log.info("(x) #=" + no + " for " + reportLine + " - " + updateReportLine.toString());
            }
            rows.set(no);
        });
        return rows.get();
    }

    private int getSecondValue(MReportLine reportLine, int operation_2) {
        AtomicInteger rows = new AtomicInteger(0);
        Trx.run(trxName -> {
            boolean levelNo;
            int col;
            int no = 0;
            StringBuilder updateReportLine = new StringBuilder("UPDATE T_Report r1 SET (");
            StringBuilder updateFixPercentage = new StringBuilder(" UPDATE T_Report SET ");
            Boolean fixPercentage = false;
            for (col = 0; col < this.reportColumns.length; ++col) {
                if (col > 0) {
                    updateReportLine.append(",");
                }
                updateReportLine.append("Col_").append(col);
            }
            updateReportLine.append(") = (SELECT ");
            for (col = 0; col < this.reportColumns.length; ++col) {
                if (col > 0) {
                    updateReportLine.append(",");
                }
                updateReportLine.append("COALESCE(r1.Col_").append(col).append(",0)");
                if (reportLine.isCalculationTypeSubtract()) {
                    updateReportLine.append("-");
                    updateReportLine.append("COALESCE(r2.Col_").append(col).append(",0)");
                } else {
                    updateReportLine.append("/");
                    updateReportLine.append("DECODE (r2.Col_").append(col).append(", 0, NULL, r2.Col_").append(col).append(")");
                }
                if (!reportLine.isCalculationTypePercent()) continue;
                updateReportLine.append(" *100");
                Float fixedPercentage = this.getFixedPercentage(trxName, this.getAD_PInstance_ID(), reportLine.getPA_ReportLine_ID(), "Col_" + col);
                if (fixedPercentage.floatValue() > 0.0f) {
                    fixPercentage = true;
                }
                if (col > 0) {
                    updateFixPercentage.append(",");
                }
                updateFixPercentage.append("Col_").append(col).append(" = ").append(fixedPercentage);
            }
            if (fixPercentage.booleanValue()) {
                try {
                    updateFixPercentage.append(" WHERE AD_PInstance_ID = ? ").append(" AND PA_ReportLine_ID = ? ").append(" AND ABS(LevelNo) < ? ");
                    levelNo = true;
                    no = DB.executeUpdateEx(updateFixPercentage.toString(), io.vavr.collection.List.of((Object[])new Integer[]{this.getAD_PInstance_ID(), reportLine.getPA_ReportLine_ID(), 1}).toJavaArray(), trxName);
                    rows.set(no);
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, updateFixPercentage.toString(), e);
                }
                if (no != 1) {
                    this.log.severe("(x) #=" + no + " for " + reportLine + " - " + updateReportLine.toString());
                } else {
                    this.log.fine("(x) Line=" + reportLine.getSeqNo() + " - " + reportLine);
                    this.log.finest(updateReportLine.toString());
                }
            } else {
                updateReportLine.append(" FROM T_Report r2 WHERE r2.AD_PInstance_ID = ? ").append(" AND r2.PA_ReportLine_ID = ? ").append(" AND r2.Record_ID = ? AND r2.Fact_Acct_ID = ? ) WHERE AD_PInstance_ID = ? ").append(" AND PA_ReportLine_ID = ? ").append(" AND ABS(LevelNo) < ? ");
                levelNo = true;
                no = DB.executeUpdateEx(updateReportLine.toString(), io.vavr.collection.List.of((Object[])new Integer[]{this.getAD_PInstance_ID(), operation_2, 0, 0, this.getAD_PInstance_ID(), reportLine.getPA_ReportLine_ID(), 1}).toJavaArray(), trxName);
                rows.set(no);
                if (no != 1) {
                    this.log.severe("(x) #=" + no + " for " + reportLine + " - " + updateReportLine.toString());
                } else {
                    this.log.fine("(x) Line=" + reportLine.getSeqNo() + " - " + reportLine);
                    this.log.finest(updateReportLine.toString());
                }
            }
        });
        return rows.get();
    }

    private int getOnlyCalculations(int col) {
        int firstOperator_1 = this.getColumnIndex(this.reportColumns[col].getOper_1_ID());
        if (firstOperator_1 < 0) {
            this.log.log(Level.SEVERE, "Column Index for Operator 1 not found - " + this.reportColumns[col]);
            return 0;
        }
        int secondOperator_2 = this.getColumnIndex(this.reportColumns[col].getOper_2_ID());
        if (secondOperator_2 < 0) {
            this.log.log(Level.SEVERE, "Column Index for Operator 2 not found - " + this.reportColumns[col]);
            return 0;
        }
        this.log.fine("Column " + col + " = #" + firstOperator_1 + " " + this.reportColumns[col].getCalculationType() + " #" + secondOperator_2);
        AtomicInteger rows = new AtomicInteger(0);
        Trx.run(trxName -> {
            StringBuilder updateCalculationColumn = new StringBuilder("UPDATE T_Report SET ");
            updateCalculationColumn.append("Col_").append(col).append("=");
            if (this.reportColumns[col].isCalculationTypeAdd()) {
                updateCalculationColumn.append("COALESCE(Col_").append(firstOperator_1).append(",0)").append("+").append("COALESCE(Col_").append(secondOperator_2).append(",0)");
            } else if (this.reportColumns[col].isCalculationTypeSubtract()) {
                updateCalculationColumn.append("COALESCE(Col_").append(firstOperator_1).append(",0)").append("-").append("COALESCE(Col_").append(secondOperator_2).append(",0)");
            }
            if (this.reportColumns[col].isCalculationTypePercent()) {
                updateCalculationColumn.append("CASE WHEN COALESCE(Col_").append(secondOperator_2).append(",0)=0 THEN NULL ELSE ").append("COALESCE(Col_").append(firstOperator_1).append(",0)").append("/").append("Col_").append(secondOperator_2).append("*100 END");
            } else if (this.reportColumns[col].isCalculationTypeRange()) {
                updateCalculationColumn.append("COALESCE(Col_").append(firstOperator_1).append(",0)");
                for (int ii = firstOperator_1 + 1; ii <= secondOperator_2; ++ii) {
                    updateCalculationColumn.append("+COALESCE(Col_").append(ii).append(",0)");
                }
            }
            updateCalculationColumn.append(" WHERE AD_PInstance_ID = ? ").append(" AND ABS(LevelNo) < ? ");
            int levelNo = 2;
            int no = DB.executeUpdateEx(updateCalculationColumn.toString(), io.vavr.collection.List.of((Object[])new Integer[]{this.getAD_PInstance_ID(), 2}).toJavaArray(), trxName);
            rows.set(no);
            if (no < 1) {
                this.log.severe("#=" + no + " for " + this.reportColumns[col] + " - " + updateCalculationColumn.toString());
            } else {
                this.log.fine("Col=" + col + " - " + this.reportColumns[col]);
                this.log.finest(updateCalculationColumn.toString());
            }
        });
        return rows.get();
    }

    private int getToggleOppositeSign() {
        AtomicInteger rows = new AtomicInteger(0);
        Trx.run(trxName -> {
            boolean hasOpposites = false;
            StringBuilder updateReportLineForOppositesSing = new StringBuilder("UPDATE T_Report SET ");
            for (int col = 0; col < this.reportColumns.length; ++col) {
                if (!this.reportColumns[col].isAllowOppositeSign()) continue;
                if (hasOpposites) {
                    updateReportLineForOppositesSing.append(", ");
                } else {
                    hasOpposites = true;
                }
                updateReportLineForOppositesSing.append("Col_").append(col).append("=");
                updateReportLineForOppositesSing.append("(CASE WHEN (SELECT IsShowOppositeSign FROM PA_ReportLine l WHERE l.PA_ReportLine_ID=T_Report.PA_ReportLine_ID) = 'Y' THEN -1 ELSE 1 END) * Col_").append(col);
            }
            if (hasOpposites) {
                updateReportLineForOppositesSing.append(" WHERE AD_PInstance_ID = ? ").append(" AND ABS(LevelNo) < ? ");
                int levelNo = 2;
                int no = DB.executeUpdateEx(updateReportLineForOppositesSing.toString(), io.vavr.collection.List.of((Object[])new Integer[]{this.getAD_PInstance_ID(), 2}).toJavaArray(), trxName);
                rows.set(no);
                if (no < 1) {
                    this.log.severe("#=" + no + " for setting opposite sign - " + updateReportLineForOppositesSing.toString());
                } else {
                    this.log.fine("Set opposite sign: " + no);
                    this.log.finest(updateReportLineForOppositesSing.toString());
                }
            }
        });
        return rows.get();
    }

    private Float getFixedPercentage(String trxName, Integer processInstanceId, Integer reportLineId, String columnName) {
        AtomicReference<Float> fixedPercentageReference = new AtomicReference<Float>(Float.valueOf(0.0f));
        String sql = "SELECT FixedPercentage, " + columnName + " FROM T_Report WHERE AD_PInstance_ID = ? AND PA_ReportLine_ID = ? ";
        DB.runResultSetFunction.apply((Object)trxName, (Object)sql, (Object)io.vavr.collection.List.of((Object[])new Object[]{processInstanceId, reportLineId}), resultSet -> {
            io.vavr.collection.List fixedPercentageResult = new ResultSetIterable((ResultSet)resultSet, (CheckedFunction1 & Serializable)row -> Tuple.of((Object)Float.valueOf(row.getFloat("FixedPercentage")), (Object)Float.valueOf(row.getFloat(columnName)), (Object)Float.valueOf(row.getFloat("FixedPercentage") / 100.0f))).toList();
            fixedPercentageResult.peek(percentageTuple -> {
                Float percent = (Float)percentageTuple._1;
                Float col = (Float)percentageTuple._2;
                Float percentage = (Float)percentageTuple._3;
                if (col.floatValue() > 0.0f) {
                    BigDecimal result = new BigDecimal(Float.toString(col.floatValue() * percentage.floatValue()));
                    fixedPercentageReference.set(Float.valueOf(result.setScale(2, RoundingMode.HALF_UP).floatValue()));
                } else {
                    fixedPercentageReference.set(Float.valueOf(0.0f));
                }
            });
        });
        return fixedPercentageReference.get();
    }

    private String getLineIds(int fromId, int toId) {
        this.log.finest("From=" + fromId + " To=" + toId);
        int firstReportLineId = 0;
        int lastReportLineId = 0;
        for (MReportLine reportLine : this.reportLines) {
            int reportLineId = reportLine.getPA_ReportLine_ID();
            if (reportLineId != fromId && reportLineId != toId) continue;
            if (firstReportLineId == 0) {
                firstReportLineId = reportLineId;
                continue;
            }
            lastReportLineId = reportLineId;
            break;
        }
        StringBuilder reportLineIdsList = new StringBuilder();
        reportLineIdsList.append(firstReportLineId);
        boolean addToList = false;
        for (int line = 0; line < this.reportLines.length; ++line) {
            int reportLineId = this.reportLines[line].getPA_ReportLine_ID();
            this.log.finest("Add=" + addToList + " ID=" + reportLineId + " - " + this.reportLines[line]);
            if (addToList) {
                reportLineIdsList.append(",").append(reportLineId);
                if (reportLineId != lastReportLineId) continue;
                break;
            }
            if (reportLineId != firstReportLineId) continue;
            addToList = true;
        }
        return reportLineIdsList.toString();
    }

    private int getColumnIndex(int reportColumnId) {
        for (int i2 = 0; i2 < this.reportColumns.length; ++i2) {
            if (this.reportColumns[i2].getPA_ReportColumn_ID() != reportColumnId) continue;
            return i2;
        }
        return -1;
    }

    private FinReportPeriod getPeriod(BigDecimal relativeOffset) {
        if (relativeOffset == null) {
            return this.getPeriod(0);
        }
        return this.getPeriod(relativeOffset.intValue());
    }

    private FinReportPeriod getPeriod(int relativeOffset) {
        if (this.reportPeriod < 0) {
            int row = 0;
            for (FinReportPeriod finReportPeriod : this.finReportPeriods) {
                if (this.getPeriodId() == finReportPeriod.getC_Period_ID()) {
                    this.reportPeriod = row;
                    break;
                }
                ++row;
            }
        }
        if (this.reportPeriod < 0 || this.reportPeriod >= this.finReportPeriods.size()) {
            throw new UnsupportedOperationException("Period index not found - ReportPeriod=" + this.reportPeriod + ", C_Period_ID=" + this.getPeriodId());
        }
        int index = this.reportPeriod + relativeOffset;
        if (index < 0) {
            this.log.log(Level.SEVERE, "Relative Offset(" + relativeOffset + ") not valid for selected Period(" + this.reportPeriod + ")");
            index = 0;
        } else if (index >= this.finReportPeriods.size()) {
            this.log.log(Level.SEVERE, "Relative Offset(" + relativeOffset + ") not valid for selected Period(" + this.reportPeriod + ")");
            index = this.finReportPeriods.size() - 1;
        }
        return (FinReportPeriod)this.finReportPeriods.get(index);
    }

    private void insertLineDetail() {
        this.log.info("");
        int no = this.cleanAnyRowsThatNotAreReportLines();
        this.log.fine("Deleted empty #=" + no);
        for (MReportLine reportLine : this.reportLines) {
            Trx.run(trxName -> {
                reportLine.set_TrxName(trxName);
                if (reportLine.isLineTypeSegmentValue()) {
                    this.insertLineSource(reportLine);
                    String seqNoSql = "SELECT SeqNo  FROM  T_Report WHERE  AD_PInstance_ID=" + this.getAD_PInstance_ID() + " AND PA_ReportLine_ID=" + reportLine.getPA_ReportLine_ID() + " AND Record_ID=0 AND Fact_Acct_ID=0";
                    int seqNo = DB.getSQLValue(trxName, seqNoSql);
                    if (seqNo >= 0) {
                        String updateReportLineSeqNo = "UPDATE T_Report  SET SeqNo=" + seqNo + " WHERE  SeqNo IS NULL  AND AD_PInstance_ID = ?  AND PA_ReportLine_ID = ? ";
                        int updateSegmentValue = DB.executeUpdateEx(updateReportLineSeqNo, io.vavr.collection.List.of((Object[])new Integer[]{this.getAD_PInstance_ID(), reportLine.getPA_ReportLine_ID()}).toJavaArray(), trxName);
                        this.log.fine("SeqNo #=" + updateSegmentValue);
                    }
                }
            });
        }
        this.setNameAndDescription();
    }

    private void setNameAndDescription() {
        Trx.run(trxName -> {
            String selectForNameAndDesc = "SELECT e.Name, fa.Description FROM Fact_Acct fa INNER JOIN AD_Table t ON (fa.AD_Table_ID=t.AD_Table_ID) INNER JOIN AD_Element e ON (t.TableName||'_ID'=e.ColumnName) WHERE r.Fact_Acct_ID=fa.Fact_Acct_ID";
            String updateReportLineSeqNo = "UPDATE T_Report r SET (Name,Description)=(SELECT e.Name, fa.Description FROM Fact_Acct fa INNER JOIN AD_Table t ON (fa.AD_Table_ID=t.AD_Table_ID) INNER JOIN AD_Element e ON (t.TableName||'_ID'=e.ColumnName) WHERE r.Fact_Acct_ID=fa.Fact_Acct_ID) WHERE Fact_Acct_ID <> ? AND AD_PInstance_ID = ? ";
            int setNameAndDescription = DB.executeUpdateEx("UPDATE T_Report r SET (Name,Description)=(SELECT e.Name, fa.Description FROM Fact_Acct fa INNER JOIN AD_Table t ON (fa.AD_Table_ID=t.AD_Table_ID) INNER JOIN AD_Element e ON (t.TableName||'_ID'=e.ColumnName) WHERE r.Fact_Acct_ID=fa.Fact_Acct_ID) WHERE Fact_Acct_ID <> ? AND AD_PInstance_ID = ? ", io.vavr.collection.List.of((Object[])new Integer[]{0, this.getAD_PInstance_ID()}).toJavaArray(), trxName);
            if (CLogMgt.isLevelFinest()) {
                this.log.fine("Trx Name #=" + setNameAndDescription + " - UPDATE T_Report r SET (Name,Description)=(SELECT e.Name, fa.Description FROM Fact_Acct fa INNER JOIN AD_Table t ON (fa.AD_Table_ID=t.AD_Table_ID) INNER JOIN AD_Element e ON (t.TableName||'_ID'=e.ColumnName) WHERE r.Fact_Acct_ID=fa.Fact_Acct_ID) WHERE Fact_Acct_ID <> ? AND AD_PInstance_ID = ? ");
            }
        });
    }

    private int cleanAnyRowsThatNotAreReportLines() {
        Try tryCleanAnyRowsThatNotAreReportLines = Try.of((CheckedFunction0 & Serializable)() -> {
            AtomicInteger lines = new AtomicInteger(0);
            Trx.run(trxName -> {
                String cleanAnyRowsThatNotAreReportLinesSQL = "DELETE FROM T_Report WHERE ABS(LevelNo) <> ?  AND Col_0 IS NULL AND Col_1 IS NULL AND Col_2 IS NULL AND Col_3 IS NULL AND Col_4 IS NULL AND Col_5 IS NULL AND Col_6 IS NULL AND Col_7 IS NULL AND Col_8 IS NULL AND Col_9 IS NULL AND Col_10 IS NULL AND Col_11 IS NULL AND Col_12 IS NULL AND Col_13 IS NULL AND Col_14 IS NULL AND Col_15 IS NULL AND Col_16 IS NULL AND Col_17 IS NULL AND Col_18 IS NULL AND Col_19 IS NULL AND Col_20 IS NULL";
                int no = DB.executeUpdateEx("DELETE FROM T_Report WHERE ABS(LevelNo) <> ?  AND Col_0 IS NULL AND Col_1 IS NULL AND Col_2 IS NULL AND Col_3 IS NULL AND Col_4 IS NULL AND Col_5 IS NULL AND Col_6 IS NULL AND Col_7 IS NULL AND Col_8 IS NULL AND Col_9 IS NULL AND Col_10 IS NULL AND Col_11 IS NULL AND Col_12 IS NULL AND Col_13 IS NULL AND Col_14 IS NULL AND Col_15 IS NULL AND Col_16 IS NULL AND Col_17 IS NULL AND Col_18 IS NULL AND Col_19 IS NULL AND Col_20 IS NULL", io.vavr.collection.List.of((Object)0).toJavaArray(), trxName);
                lines.set(no);
            });
            return lines.get();
        }).onFailure(throwable -> this.log.severe(throwable.getMessage()));
        return (Integer)tryCleanAnyRowsThatNotAreReportLines.get();
    }

    private void insertLineSource(MReportLine reportLine) {
        if (reportLine == null || reportLine.getSources().length == 0) {
            return;
        }
        this.log.info("Line=" + reportLine.getSeqNo() + " - " + reportLine);
        String variable = reportLine.getSourceColumnName();
        if (variable == null) {
            return;
        }
        this.log.fine("Variable=" + variable);
        for (MReportSource source : reportLine.getSources()) {
            if (!Util.isEmpty(this.getListSources()) && this.getListSources().equals("N") || Util.isEmpty(this.getListSources()) && (!Util.isEmpty(this.finReport.getListSources()) && this.finReport.getListSources().equals("N") || Util.isEmpty(this.finReport.getListSources()) && !source.isListSources())) continue;
            boolean isCombination = source.getElementType().equals("CO");
            int combinationId = 0;
            if (isCombination) {
                combinationId = MAccount.get(this.getCtx(), this.getAD_Client_ID(), source.getAD_Org_ID(), Env.getContextAsInt(this.getCtx(), "$C_AcctSchema_ID"), source.getC_ElementValue_ID(), 0, source.getM_Product_ID(), source.getC_BPartner_ID(), source.getAD_OrgTrx_ID(), source.getC_Location_ID(), 0, source.getC_SalesRegion_ID(), source.getC_Project_ID(), source.getC_Campaign_ID(), source.getC_Activity_ID(), source.getUser1_ID(), source.getUser2_ID(), source.getUser3_ID(), source.getUser4_ID(), source.getUserElement1_ID(), source.getUserElement2_ID(), reportLine.get_TrxName()).getC_ValidCombination_ID();
            }
            String whereReport = this.finReport.getWhereClause();
            StringBuilder whereReportLine = new StringBuilder(this.getWhereReportLine(reportLine, source, whereReport, isCombination, variable));
            this.insertLineSource(reportLine, source, isCombination, combinationId, variable, whereReportLine);
            this.setNameAndDescription(reportLine, isCombination, combinationId);
            if (!Util.isEmpty(this.getListTrx()) && this.getListTrx().equals("Y")) {
                this.insertLineTrx(reportLine, variable, combinationId, whereReportLine + this.getWhereClauseForTrx());
            } else if (Util.isEmpty(this.getListTrx()) && !Util.isEmpty(this.finReport.getListTrx()) && this.finReport.getListTrx().equals("Y")) {
                this.insertLineTrx(reportLine, variable, combinationId, whereReportLine + this.getWhereClauseForTrx());
            } else if (Util.isEmpty(this.getListTrx()) && Util.isEmpty(this.finReport.getListTrx()) && source.isListTrx()) {
                this.insertLineTrx(reportLine, variable, combinationId, whereReportLine + this.getWhereClauseForTrx());
            }
            if (!isCombination) break;
        }
    }

    private String getWhereReportLine(MReportLine reportLine, MReportSource source, String whereReport, Boolean isCombination, String variable) {
        StringBuilder whereReportLine = new StringBuilder("");
        if (isCombination.booleanValue()) {
            whereReportLine.append(source.getWhereClause(this.getHierarchyId()));
            whereReportLine.append(this.getWherePostingType(true));
        } else {
            whereReportLine.append(reportLine.getWhereClause(this.getHierarchyId(), this.getWherePostingType(false)));
        }
        if (whereReport != null && whereReport.length() > 0) {
            if (whereReportLine.length() > 0) {
                whereReportLine.append(" AND ");
            }
            whereReportLine.append(whereReport);
        }
        if (whereReportLine.length() > 0 && !isCombination.booleanValue()) {
            whereReportLine.append(" AND ");
        }
        if (!isCombination.booleanValue()) {
            whereReportLine.append(variable).append(" IS NOT NULL");
        }
        return whereReportLine.toString();
    }

    private int insertLineSource(MReportLine reportLine, MReportSource source, Boolean isCombination, int combinationId, String variable, StringBuilder whereReportLine) {
        AtomicInteger rows = new AtomicInteger(0);
        Trx.run(trxName -> {
            String whereReport;
            StringBuilder insertLineSource = new StringBuilder("INSERT INTO T_Report (AD_PInstance_ID, PA_ReportLine_ID, Record_ID,Fact_Acct_ID,LevelNo ");
            if (isCombination.booleanValue()) {
                insertLineSource.append(", C_ValidCombination_ID ");
            }
            for (int col = 0; col < this.reportColumns.length; ++col) {
                insertLineSource.append(",Col_").append(col);
            }
            insertLineSource.append(") SELECT ").append(this.getAD_PInstance_ID()).append(",").append(reportLine.getPA_ReportLine_ID()).append(",");
            if (isCombination.booleanValue()) {
                insertLineSource.append("Account_ID");
            } else {
                insertLineSource.append(variable);
            }
            insertLineSource.append(",0,");
            if (this.isDetailsSourceFirst()) {
                insertLineSource.append("-1 ");
            } else {
                insertLineSource.append("1 ");
            }
            if (isCombination.booleanValue()) {
                insertLineSource.append(",").append(combinationId).append(" ");
            }
            if ((whereReport = this.finReport.getWhereClause()) != null && whereReport.length() > 0) {
                if (whereReportLine.length() > 0) {
                    whereReportLine.append(" AND ");
                }
                whereReportLine.append(whereReport);
            }
            StringBuilder whereLink = new StringBuilder();
            if (isCombination.booleanValue()) {
                whereLink.append(reportLine.getSelectClauseCombination());
            } else {
                whereLink.append(" AND fb.").append(variable).append("=x.").append(variable);
            }
            insertLineSource.append(this.getColumnStatement(INSERT, reportLine, whereReportLine.toString() + this.getWhereClause() + whereLink, false));
            if (this.getReportCubeId() > 0) {
                insertLineSource.append(" FROM Fact_Acct_Summary x WHERE ").append((CharSequence)whereReportLine).append(this.getWhereClause());
            } else {
                insertLineSource.append(" FROM Fact_Acct x WHERE ").append((CharSequence)whereReportLine).append(this.getWhereClause());
            }
            insertLineSource.append(" GROUP BY ");
            if (isCombination.booleanValue()) {
                List<String> colNames = reportLine.getCombinationGroupByColumns();
                StringBuilder groupBy = new StringBuilder("");
                for (int j = 0; j < colNames.size(); ++j) {
                    groupBy.append(", ").append(colNames.get(j));
                }
                insertLineSource.append(groupBy.toString().replaceFirst(", ", ""));
            } else {
                insertLineSource.append(variable);
            }
            int no = DB.executeUpdateEx(insertLineSource.toString(), trxName);
            rows.set(no);
            if (CLogMgt.isLevelFinest()) {
                this.log.fine("Source #=" + no + " - " + insertLineSource);
            }
        });
        return rows.get();
    }

    private int setNameAndDescription(MReportLine reportLine, Boolean isCombination, Integer combinationId) {
        AtomicInteger rows = new AtomicInteger(0);
        Trx.run(trxName -> {
            StringBuilder updateNameAndDesc = new StringBuilder("UPDATE T_Report SET (Name,Description)=(");
            String sourceValueQuery = reportLine.getSourceValueQuery();
            if (sourceValueQuery.length() == 0 && isCombination.booleanValue()) {
                updateNameAndDesc.append("SELECT Combination , Description FROM C_ValidCombination WHERE C_ValidCombination_ID=").append(combinationId);
            } else {
                updateNameAndDesc.append(sourceValueQuery);
                updateNameAndDesc.append("T_Report.Record_ID");
            }
            updateNameAndDesc.append(") WHERE Record_ID <> ? AND AD_PInstance_ID = ? ").append(" AND PA_ReportLine_ID = ? ").append(" AND Fact_Acct_ID = ?");
            if (isCombination.booleanValue()) {
                updateNameAndDesc.append(" AND C_ValidCombination_ID=").append(combinationId);
            }
            int no = DB.executeUpdateEx(updateNameAndDesc.toString(), io.vavr.collection.List.of((Object[])new Integer[]{0, this.getAD_PInstance_ID(), reportLine.getPA_ReportLine_ID(), 0}).toJavaArray(), trxName);
            rows.set(no);
            if (CLogMgt.isLevelFinest()) {
                this.log.fine("Name #=" + no + " - " + updateNameAndDesc.toString());
            }
        });
        return rows.get();
    }

    private void insertLineTrx(MReportLine reportLine, String variable, int combinationId, String whereReportLine) {
        this.log.info("Line=" + reportLine.getSeqNo() + " - Variable=" + variable);
        Trx.run(trxName -> {
            boolean isCombination;
            StringBuilder insertLineTrx = new StringBuilder("INSERT INTO T_Report (AD_PInstance_ID, PA_ReportLine_ID, Record_ID,Fact_Acct_ID,LevelNo ");
            boolean bl = isCombination = combinationId > 0 && whereReportLine != null;
            if (isCombination) {
                insertLineTrx.append(",C_ValidCombination_ID ");
            }
            for (int col = 0; col < this.reportColumns.length; ++col) {
                insertLineTrx.append(",Col_").append(col);
            }
            insertLineTrx.append(") SELECT ").append(this.getAD_PInstance_ID()).append(",").append(reportLine.getPA_ReportLine_ID()).append(",");
            if (isCombination) {
                insertLineTrx.append(combinationId);
            } else {
                insertLineTrx.append(variable);
            }
            insertLineTrx.append(",Fact_Acct_ID, ");
            if (this.isDetailsSourceFirst()) {
                insertLineTrx.append("-2 ");
            } else {
                insertLineTrx.append("2 ");
            }
            if (isCombination) {
                insertLineTrx.append(",").append(combinationId).append(" ");
            }
            StringBuilder whereLink = new StringBuilder();
            if (isCombination) {
                whereLink.append(reportLine.getSelectClauseCombination());
            } else {
                whereLink.append(" AND fb.").append(variable).append("=x.").append(variable);
            }
            insertLineTrx.append(this.getColumnStatement(INSERT, reportLine, whereReportLine + whereLink + " AND fb.Fact_Acct_ID=x.Fact_Acct_ID ", true));
            insertLineTrx.append(" FROM Fact_Acct x WHERE ");
            insertLineTrx.append(whereReportLine);
            int no = DB.executeUpdateEx(insertLineTrx.toString(), trxName);
            this.log.finest("Trx #=" + no + " - " + insertLineTrx);
        });
    }

    private String getColumnStatement(String action, MReportLine reportLine, String whereClause, boolean isTrx) {
        StringBuilder sqlStatement = new StringBuilder();
        for (int col = 0; col < this.reportColumns.length; ++col) {
            StringBuilder whereColumn = new StringBuilder("");
            StringBuilder info = new StringBuilder();
            if (this.reportColumns[col].isColumnTypeCalculation() || reportLine.getPAAmountType() == null && this.reportColumns[col].getPAAmountType() == null) {
                if (INSERT.equals(action)) {
                    sqlStatement.append(",NULL");
                }
                this.log.warning("No Amount Type in line: " + reportLine + " or column: " + this.reportColumns[col]);
                continue;
            }
            info.append("Line=").append(reportLine.getSeqNo()).append(",Col=").append(col);
            StringBuilder select = new StringBuilder("SELECT ");
            if (reportLine.getPAAmountType() != null) {
                select.append(reportLine.getSelectClause(true));
                info.append(": LineAmtType=").append(reportLine.getPAAmountType());
            } else if (this.reportColumns[col].getPAAmountType() != null) {
                select.append(this.reportColumns[col].getSelectClause(true));
                info.append(": ColumnAmtType=").append(this.reportColumns[col].getPAAmountType());
            }
            if (this.getReportCubeId() > 0 && !isTrx) {
                select.append(" FROM Fact_Acct_Summary fb ");
            } else {
                select.append(" FROM Fact_Acct fb ");
            }
            whereColumn.append(" WHERE TRUNC(DateAcct) ");
            BigDecimal relativeOffset = null;
            BigDecimal relativeOffsetTo = null;
            if (this.reportColumns[col].isColumnTypeRelativePeriod()) {
                relativeOffset = this.reportColumns[col].getRelativePeriod();
                relativeOffsetTo = (BigDecimal)this.reportColumns[col].get_Value("RelativePeriodTo");
            }
            FinReportPeriod finReportPeriod = this.getPeriod(relativeOffset);
            if (reportLine.getPAPeriodType() != null) {
                info.append(" - LineDateAcct=");
                if (reportLine.isPeriod()) {
                    info.append("Period");
                    whereColumn.append(finReportPeriod.getPeriodWhere());
                    whereColumn.append(" AND ").append(finReportPeriod.getPeriodTypeWhere("fb", true));
                } else if (reportLine.isYear()) {
                    info.append("Year");
                    whereColumn.append(finReportPeriod.getYearWhere());
                    whereColumn.append(" AND ").append(finReportPeriod.getPeriodTypeWhere("fb", true));
                } else if (reportLine.isTotal()) {
                    info.append("Total");
                    whereColumn.append(finReportPeriod.getTotalWhere());
                    whereColumn.append(" AND ").append(finReportPeriod.getPeriodTypeWhere("fb", true));
                } else if (reportLine.isNatural()) {
                    info.append("Natural");
                    whereColumn.append(finReportPeriod.getNaturalWhere("fb"));
                    whereColumn.append(" AND ").append(finReportPeriod.getPeriodTypeWhere("fb", true));
                } else {
                    this.log.log(Level.SEVERE, "No valid Line PAPeriodType");
                    whereColumn.append("=0");
                }
            } else if (this.reportColumns[col].getPAPeriodType() != null) {
                info.append(" - ColumnDateAcct=");
                FinReportPeriod finReportPeriodTo = null;
                if (relativeOffsetTo != null) {
                    finReportPeriodTo = this.getPeriod(relativeOffsetTo);
                }
                if (this.reportColumns[col].isPeriod()) {
                    if (finReportPeriodTo != null) {
                        whereColumn.append("BETWEEN ").append(DB.TO_DATE(finReportPeriod.getStartDate())).append(" AND ").append(DB.TO_DATE(finReportPeriodTo.getEndDate()));
                        whereColumn.append(" AND ").append(finReportPeriodTo.getPeriodTypeWhere("fb", true));
                    } else {
                        whereColumn.append(finReportPeriod.getPeriodWhere());
                        whereColumn.append(" AND ").append(finReportPeriod.getPeriodTypeWhere("fb", true));
                    }
                    info.append("Period");
                } else if (this.reportColumns[col].isYear()) {
                    if (finReportPeriodTo != null) {
                        whereColumn.append("BETWEEN ").append(DB.TO_DATE(finReportPeriod.getYearStartDate())).append(" AND ").append(DB.TO_DATE(finReportPeriodTo.getEndDate()));
                        whereColumn.append(" AND ").append(finReportPeriodTo.getPeriodTypeWhere("fb", true));
                    } else {
                        whereColumn.append(finReportPeriod.getYearWhere());
                        whereColumn.append(" AND ").append(finReportPeriod.getPeriodTypeWhere("fb", true));
                    }
                    info.append("Year");
                } else if (this.reportColumns[col].isTotal()) {
                    if (finReportPeriodTo != null) {
                        whereColumn.append("<= ").append(DB.TO_DATE(finReportPeriodTo.getEndDate()));
                        whereColumn.append(" AND ").append(finReportPeriodTo.getPeriodTypeWhere("fb", true));
                    } else {
                        whereColumn.append(finReportPeriod.getTotalWhere());
                        whereColumn.append(" AND ").append(finReportPeriod.getPeriodTypeWhere("fb", true));
                    }
                    info.append("Total");
                } else if (this.reportColumns[col].isNatural()) {
                    if (finReportPeriodTo != null) {
                        String yearWhere = "BETWEEN " + DB.TO_DATE(finReportPeriod.getYearStartDate()) + " AND " + DB.TO_DATE(finReportPeriodTo.getEndDate());
                        String totalWhere = "<= " + DB.TO_DATE(finReportPeriodTo.getEndDate());
                        String bs = " EXISTS (SELECT C_ElementValue_ID FROM C_ElementValue WHERE C_ElementValue_ID = fb.Account_ID AND AccountType NOT IN ('R', 'E'))";
                        String full = totalWhere + " AND ( " + bs + " OR TRUNC(fb.DateAcct) " + yearWhere + " ) ";
                        whereColumn.append(full);
                        whereColumn.append(" AND ").append(finReportPeriodTo.getPeriodTypeWhere("fb", true));
                    } else {
                        whereColumn.append(finReportPeriod.getNaturalWhere("fb"));
                        whereColumn.append(" AND ").append(finReportPeriod.getPeriodTypeWhere("fb", true));
                    }
                } else {
                    this.log.log(Level.SEVERE, "No valid Column PAPeriodType");
                    whereColumn.append("=0");
                }
            }
            Object postingTypeWhereClause = this.getWherePostingType(true);
            if (Util.isEmpty((String)postingTypeWhereClause)) {
                String postingType = reportLine.getPostingType();
                int budgetId = reportLine.getGL_Budget_ID();
                if (Util.isEmpty(postingType)) {
                    postingType = this.reportColumns[col].getPostingType();
                    budgetId = this.reportColumns[col].getGL_Budget_ID();
                }
                if (!Util.isEmpty(postingType)) {
                    postingTypeWhereClause = " AND PostingType='" + postingType + "' ";
                    if (postingType.equals("B") && budgetId > 0) {
                        postingTypeWhereClause = (String)postingTypeWhereClause + " AND GL_Budget_ID = " + budgetId;
                    }
                }
                if (!Util.isEmpty((String)postingTypeWhereClause)) {
                    whereColumn.append((String)postingTypeWhereClause);
                }
            } else {
                whereColumn.append((String)postingTypeWhereClause);
            }
            if (this.reportColumns[col].isColumnTypeSegmentValue() || this.reportColumns[col].isWithSources()) {
                whereColumn.append(this.reportColumns[col].getWhereClause(this.getHierarchyId()));
            }
            if (whereClause != null && whereClause.length() > 0) {
                whereColumn.append(" AND ").append(whereClause);
            }
            if (sqlStatement.length() > 0) {
                sqlStatement.append(", ");
            } else if (sqlStatement.length() == 0 && INSERT.equals(action)) {
                sqlStatement.append(", ");
            }
            if (UPDATE.equals(action)) {
                sqlStatement.append("Col_").append(col).append(" =  ");
            }
            sqlStatement.append("(").append((CharSequence)select).append((CharSequence)whereColumn).append(")");
            this.log.finest(info.toString());
        }
        return sqlStatement.toString();
    }

    private void deleteUnprintedLines() {
        Trx.run(trxName -> {
            String deleteNotPrintLines = "DELETE FROM T_Report WHERE AD_PInstance_ID = " + this.getAD_PInstance_ID() + " AND EXISTS(SELECT 1 \t\t\t\t\tFROM PA_ReportLine rl\t\t\t\t\tWHERE rl.PA_ReportLine_ID = T_Report.PA_ReportLine_ID\t\t\t\t\tAND rl.PA_ReportLineSet_ID = ?\t\t\t\t\tAND rl.IsPrinted = ? )";
            int no = DB.executeUpdateEx(deleteNotPrintLines, io.vavr.collection.List.of((Object[])new Serializable[]{Integer.valueOf(this.finReport.getPA_ReportLineSet_ID()), Boolean.valueOf(false)}).toJavaArray(), trxName);
            if (no > 0) {
                this.log.fine("Lines deleted - #" + no);
            }
        });
    }

    private void scaleResults() {
        for (int column = 0; column < this.reportColumns.length; ++column) {
            String factor = this.reportColumns[column].getFactor();
            if (factor == null) continue;
            int divisor = 1;
            if (factor.equals("k")) {
                divisor = 1000;
            } else {
                if (!factor.equals("M")) break;
                divisor = 1000000;
            }
            int columnFinal = column;
            int divisorFinal = divisor;
            Trx.run(trxName -> {
                String updateScaleResult = "UPDATE T_Report SET Col_" + columnFinal + "=Col_" + columnFinal + "/" + divisorFinal + " WHERE AD_PInstance_ID = ? ";
                int no = DB.executeUpdateEx(updateScaleResult, io.vavr.collection.List.of((Object)this.getAD_PInstance_ID()).toJavaArray(), trxName);
                if (no > 0) {
                    this.log.fine(this.reportColumns[columnFinal].getName() + " - #" + no);
                }
            });
        }
    }

    private MPrintFormat getPrintFormat() {
        MPrintFormat printFormat = this.synchronizePrintFormat();
        if (this.finReport.getAD_PrintFormatHeader_ID() <= 0) {
            return printFormat;
        }
        return this.synchronizePrintFormatHeader();
    }

    private MPrintFormat synchronizePrintFormat() {
        AtomicReference<Object> printFormatReference = new AtomicReference<Object>(null);
        Trx.run(trxName -> {
            MPrintFormat printFormat = this.finReport.getAD_PrintFormat_ID() <= 0 ? MPrintFormat.createFromTable(Env.getCtx(), 544, 0, trxName) : new MPrintFormat(this.getCtx(), this.finReport.getAD_PrintFormat_ID(), trxName);
            if (!this.finReport.getName().equals(printFormat.getName())) {
                printFormat.setName(this.finReport.getName());
            }
            if (this.finReport.getDescription() == null) {
                if (printFormat.getDescription() != null) {
                    printFormat.setDescription(null);
                }
            } else if (!this.finReport.getDescription().equals(printFormat.getDescription())) {
                printFormat.setDescription(this.finReport.getDescription());
            }
            printFormat.saveEx();
            this.log.fine(printFormat + " - #" + printFormat.getItemCount());
            Arrays.asList(printFormat.getItems()).stream().forEach(printFormatItem -> {
                Optional<String> maybeColumnName = Optional.ofNullable(printFormatItem.getColumnName());
                if (maybeColumnName.isPresent()) {
                    String columnName = maybeColumnName.get();
                    if (columnName.startsWith("Col")) {
                        int index = Integer.parseInt(columnName.substring(4));
                        if (index < this.reportColumns.length) {
                            printFormatItem.setIsPrinted(this.reportColumns[index].isPrinted());
                            String columnTitle = this.reportColumns[index].getName();
                            if (this.reportColumns[index].isColumnTypeRelativePeriod()) {
                                BigDecimal relativeOffset = this.reportColumns[index].getRelativePeriod();
                                BigDecimal relativeOffsetTo = (BigDecimal)this.reportColumns[index].get_Value("RelativePeriodTo");
                                FinReportPeriod finReportPeriod = this.getPeriod(relativeOffset);
                                if (columnTitle.contains("@Period@")) {
                                    if (relativeOffsetTo != null) {
                                        FinReportPeriod finReportPeriodTo = this.getPeriod(relativeOffsetTo);
                                        columnTitle = columnTitle.replace("@Period@", finReportPeriod.getName() + " - " + finReportPeriodTo.getName());
                                    } else {
                                        columnTitle = columnTitle.replace("@Period@", finReportPeriod.getName());
                                    }
                                }
                            }
                            if (!printFormatItem.getName().equals(columnTitle)) {
                                printFormatItem.setName(columnTitle);
                                printFormatItem.setPrintName(columnTitle);
                            }
                            int seq = 30 + index;
                            if (printFormatItem.getSeqNo() != seq) {
                                printFormatItem.setSeqNo(seq);
                            }
                            columnTitle = this.reportColumns[index].getFormatPattern();
                            printFormatItem.setFormatPattern(columnTitle);
                            printFormatItem.setFieldAlignmentType("T");
                        } else if (printFormatItem.isPrinted()) {
                            printFormatItem.setIsPrinted(false);
                        }
                        if (printFormatItem.isOrderBy()) {
                            printFormatItem.setIsOrderBy(false);
                        }
                        if (printFormatItem.getSortNo() != 0) {
                            printFormatItem.setSortNo(0);
                        }
                    } else if (columnName.equals("SeqNo")) {
                        if (printFormatItem.isPrinted()) {
                            printFormatItem.setIsPrinted(false);
                        }
                        if (!printFormatItem.isOrderBy()) {
                            printFormatItem.setIsOrderBy(true);
                        }
                        if (printFormatItem.getSortNo() != 10) {
                            printFormatItem.setSortNo(10);
                        }
                    } else if (columnName.equals("LevelNo")) {
                        if (printFormatItem.isPrinted()) {
                            printFormatItem.setIsPrinted(false);
                        }
                        if (!printFormatItem.isOrderBy()) {
                            printFormatItem.setIsOrderBy(true);
                        }
                        if (printFormatItem.getSortNo() != 20) {
                            printFormatItem.setSortNo(20);
                        }
                    } else if (columnName.equals("Name")) {
                        if (printFormatItem.getSeqNo() != 10) {
                            printFormatItem.setSeqNo(10);
                        }
                        if (!printFormatItem.isPrinted()) {
                            printFormatItem.setIsPrinted(true);
                        }
                        if (!printFormatItem.isOrderBy()) {
                            printFormatItem.setIsOrderBy(true);
                        }
                        if (printFormatItem.getSortNo() != 30) {
                            printFormatItem.setSortNo(30);
                        }
                    } else if (columnName.equals("Description")) {
                        if (printFormatItem.getSeqNo() != 20) {
                            printFormatItem.setSeqNo(20);
                        }
                        if (!printFormatItem.isPrinted()) {
                            printFormatItem.setIsPrinted(true);
                        }
                        if (printFormatItem.isOrderBy()) {
                            printFormatItem.setIsOrderBy(false);
                        }
                        if (printFormatItem.getSortNo() != 0) {
                            printFormatItem.setSortNo(0);
                        }
                    } else {
                        if (printFormatItem.isPrinted()) {
                            printFormatItem.setIsPrinted(false);
                        }
                        if (printFormatItem.isOrderBy()) {
                            printFormatItem.setIsOrderBy(false);
                        }
                        if (printFormatItem.getSortNo() != 0) {
                            printFormatItem.setSortNo(0);
                        }
                    }
                } else {
                    this.log.log(Level.SEVERE, "No ColumnName for - " + printFormatItem);
                    if (printFormatItem.isPrinted()) {
                        printFormatItem.setIsPrinted(false);
                    }
                    if (printFormatItem.isOrderBy()) {
                        printFormatItem.setIsOrderBy(false);
                    }
                    if (printFormatItem.getSortNo() != 0) {
                        printFormatItem.setSortNo(0);
                    }
                }
                printFormatItem.saveEx();
                this.log.fine(printFormatItem.toString());
            });
            printFormat.setTranslation();
            printFormatReference.set(printFormat);
        });
        MPrintFormat printFormat = MPrintFormat.get(this.getCtx(), ((MPrintFormat)printFormatReference.get()).getAD_PrintFormat_ID(), false);
        this.finReport.setAD_PrintFormat_ID(printFormat.getAD_PrintFormat_ID());
        this.finReport.saveEx();
        return printFormat;
    }

    private MPrintFormat synchronizePrintFormatHeader() {
        AtomicReference<Object> printFormatHeaderReference = new AtomicReference<Object>(null);
        Trx.run(trxName -> {
            MPrintFormat printFormatHeader = MPrintFormat.get(this.getCtx(), this.finReport.getAD_PrintFormatHeader_ID(), true);
            int organizationId = this.getOrgId() != 0 ? this.getOrgId() : Env.getAD_Org_ID(Env.getCtx());
            Optional<MOrgInfo> maybeOrgInfo = Optional.ofNullable(MOrgInfo.get(Env.getCtx(), organizationId, trxName));
            Optional<MLocation> maybeLocation = maybeOrgInfo.map(orgInfo -> Optional.ofNullable(new MLocation(this.getCtx(), orgInfo.getC_Location_ID(), trxName)).map(location -> location).get());
            AtomicReference<String> yearName = new AtomicReference<String>("");
            AtomicReference<String> yearFiscal = new AtomicReference<String>("");
            AtomicReference<String> currentPeriodName = new AtomicReference<String>("");
            AtomicReference<String> startPeriodName = new AtomicReference<String>("");
            AtomicReference<String> periodStartDay = new AtomicReference<String>("");
            AtomicReference<String> periodStartDate = new AtomicReference<String>("");
            AtomicReference<String> periodEndDay = new AtomicReference<String>("");
            AtomicReference<String> periodEndDate = new AtomicReference<String>("");
            AtomicReference<String> yearStartDay = new AtomicReference<String>("");
            AtomicReference<String> yearStartDate = new AtomicReference<String>("");
            this.finReportPeriods.filter(finReportPeriod -> finReportPeriod.getC_Period_ID() == this.getPeriodId()).forEach(finReportPeriod -> {
                MYear year = (MYear)MPeriod.get(this.getCtx(), finReportPeriod.getC_Period_ID()).getC_Year();
                yearName.set(year.getYY());
                yearFiscal.set(year.getFiscalYear());
                currentPeriodName.set(finReportPeriod.getName());
                startPeriodName.set(year.getPeriod(1).getName());
                SimpleDateFormat dayFormat = new SimpleDateFormat("dd");
                SimpleDateFormat dateFormat = Env.getLanguage(this.getCtx()).getDateFormat();
                periodStartDay.set(dayFormat.format(finReportPeriod.getStartDate()));
                periodStartDate.set(dateFormat.format(finReportPeriod.getStartDate()));
                periodEndDay.set(dayFormat.format(finReportPeriod.getEndDate()));
                periodEndDate.set(dateFormat.format(finReportPeriod.getEndDate()));
                yearStartDay.set(dayFormat.format(finReportPeriod.getYearStartDate()));
                yearStartDate.set(dateFormat.format(finReportPeriod.getYearStartDate()));
            });
            Arrays.stream(printFormatHeader.getItems()).forEach(printFormatItem -> Optional.ofNullable(printFormatItem.getName()).ifPresent(printFormatItemName -> {
                AtomicReference<String> printFormatItemToPrint = new AtomicReference<String>((String)printFormatItemName);
                if (printFormatItemName.equalsIgnoreCase("Report")) {
                    this.adjustPrintFormatItem((MPrintFormatItem)printFormatItem);
                    printFormatItem.setAD_PrintFormatChild_ID(this.finReport.getAD_PrintFormat_ID());
                    printFormatItemToPrint.updateAndGet(toPrint -> toPrint.replaceFirst("Report", ""));
                }
                if (printFormatItemName.contains("@Name@")) {
                    this.adjustPrintFormatItem((MPrintFormatItem)printFormatItem);
                    printFormatItemToPrint.updateAndGet(toPrint -> toPrint.replaceFirst("@Name@", Optional.ofNullable(this.finReport.getName()).orElse("")));
                }
                if (printFormatItemName.contains("@Client@")) {
                    MClient client = new MClient(this.getCtx(), Env.getAD_Client_ID(this.getCtx()), trxName);
                    this.adjustPrintFormatItem((MPrintFormatItem)printFormatItem);
                    printFormatItemToPrint.updateAndGet(toPrint -> toPrint.replaceFirst("@Client@", Optional.ofNullable(client.getName()).orElse("")));
                }
                if (printFormatItemName.contains("@Organization@") && organizationId > 0) {
                    MOrg org = new MOrg(this.getCtx(), organizationId, trxName);
                    this.adjustPrintFormatItem((MPrintFormatItem)printFormatItem);
                    printFormatItemToPrint.updateAndGet(toPrint -> toPrint.replaceFirst("@Organization@", Optional.ofNullable(org.getName()).orElse("")));
                }
                if (printFormatItemName.contains("@Currency@")) {
                    this.adjustPrintFormatItem((MPrintFormatItem)printFormatItem);
                    printFormatItemToPrint.updateAndGet(toPrint -> toPrint.replaceFirst("@Currency@", Optional.ofNullable(this.finReport.getC_AcctSchema().getC_Currency().getDescription()).orElse("")));
                }
                if (printFormatItemName.contains("@Year@")) {
                    if (this.getPeriodId() != 0) {
                        this.adjustPrintFormatItem((MPrintFormatItem)printFormatItem);
                        printFormatItemToPrint.updateAndGet(toPrint -> toPrint.replaceFirst("@Year@", Optional.ofNullable((String)yearName.get()).orElse("")));
                    } else {
                        printFormatItem.setIsPrinted(false);
                    }
                }
                if (printFormatItemName.contains("@YearFiscal@")) {
                    if (this.getPeriodId() != 0) {
                        this.adjustPrintFormatItem((MPrintFormatItem)printFormatItem);
                        printFormatItemToPrint.updateAndGet(toPrint -> toPrint.replaceFirst("@YearFiscal@", Optional.ofNullable((String)yearFiscal.get()).orElse("")));
                    } else {
                        printFormatItem.setIsPrinted(false);
                    }
                }
                if (printFormatItemName.contains("@StartPeriodName@")) {
                    if (this.getPeriodId() != 0) {
                        this.adjustPrintFormatItem((MPrintFormatItem)printFormatItem);
                        printFormatItemToPrint.updateAndGet(toPrint -> toPrint.replaceFirst("@StartPeriodName@", Optional.ofNullable((String)startPeriodName.get()).orElse("")));
                    } else {
                        printFormatItem.setIsPrinted(false);
                    }
                }
                if (printFormatItemName.contains("@Period@")) {
                    if (this.getPeriodId() != 0) {
                        this.adjustPrintFormatItem((MPrintFormatItem)printFormatItem);
                        printFormatItemToPrint.updateAndGet(toPrint -> toPrint.replaceFirst("@Period@", Optional.ofNullable((String)currentPeriodName.get()).orElse("")));
                    } else {
                        printFormatItem.setIsPrinted(false);
                    }
                }
                if (printFormatItemName.contains("@PeriodStartDay@")) {
                    if (this.getPeriodId() != 0) {
                        this.adjustPrintFormatItem((MPrintFormatItem)printFormatItem);
                        printFormatItemToPrint.updateAndGet(toPrint -> toPrint.replaceFirst("@PeriodStartDay@", Optional.ofNullable((String)periodStartDay.get()).orElse("")));
                    } else {
                        printFormatItem.setIsPrinted(false);
                    }
                }
                if (printFormatItemName.contains("@PeriodStartDate@")) {
                    if (this.getPeriodId() != 0) {
                        this.adjustPrintFormatItem((MPrintFormatItem)printFormatItem);
                        printFormatItemToPrint.updateAndGet(toPrint -> toPrint.replaceFirst("@PeriodStartDate@", Optional.ofNullable((String)periodStartDate.get()).orElse("")));
                    } else {
                        printFormatItem.setIsPrinted(false);
                    }
                }
                if (printFormatItemName.contains("@PeriodEndDay@")) {
                    if (this.getPeriodId() != 0) {
                        printFormatItemToPrint.updateAndGet(toPrint -> toPrint.replaceFirst("@PeriodEndDay@", Optional.ofNullable((String)periodEndDay.get()).orElse("")));
                    } else {
                        printFormatItem.setIsPrinted(false);
                    }
                }
                if (printFormatItemName.contains("@PeriodEndDate@")) {
                    if (this.getPeriodId() != 0) {
                        printFormatItemToPrint.updateAndGet(toPrint -> toPrint.replaceFirst("@PeriodEndDate@", Optional.ofNullable((String)periodEndDate.get()).orElse("")));
                    } else {
                        printFormatItem.setIsPrinted(false);
                    }
                }
                if (printFormatItemName.contains("@YearStartDay@")) {
                    if (this.getPeriodId() != 0) {
                        printFormatItemToPrint.updateAndGet(toPrint -> toPrint.replaceFirst("@YearStartDay@", Optional.ofNullable((String)yearStartDay.get()).orElse("")));
                    } else {
                        printFormatItem.setIsPrinted(false);
                    }
                }
                if (printFormatItemName.contains("@YearStartDate@")) {
                    if (this.getPeriodId() != 0) {
                        printFormatItemToPrint.updateAndGet(toPrint -> toPrint.replaceFirst("@YearStartDate@", Optional.ofNullable((String)yearStartDate.get()).orElse("")));
                    } else {
                        printFormatItem.setIsPrinted(false);
                    }
                }
                if (printFormatItemName.contains("@Business Partner@")) {
                    if (organizationId > 0 && this.getBPartnerId() > 0) {
                        MBPartner bpartner = MBPartner.get(this.getCtx(), this.getBPartnerId());
                        this.adjustPrintFormatItem((MPrintFormatItem)printFormatItem);
                        printFormatItemToPrint.updateAndGet(toPrint -> toPrint.replaceFirst("@Business Partner@", Optional.ofNullable(bpartner.getName()).orElse("")));
                    } else {
                        printFormatItem.setIsPrinted(false);
                        printFormatItemToPrint.updateAndGet(toPrint -> toPrint.replaceFirst("@Business Partner@", ""));
                    }
                }
                maybeOrgInfo.ifPresent(orgInfo -> {
                    if (printFormatItemName.contains("@TaxID@")) {
                        this.adjustPrintFormatItem((MPrintFormatItem)printFormatItem);
                        printFormatItemToPrint.updateAndGet(toPrint -> toPrint.replaceFirst("@TaxID@", Optional.ofNullable(orgInfo.getTaxID()).orElse("")));
                    }
                    if (printFormatItemName.contains("@DUNS@")) {
                        this.adjustPrintFormatItem((MPrintFormatItem)printFormatItem);
                        printFormatItemToPrint.updateAndGet(toPrint -> toPrint.replaceFirst("@DUNS@", Optional.ofNullable(orgInfo.getDUNS()).orElse("")));
                    }
                });
                if (printFormatItemName.equalsIgnoreCase("@Logo@")) {
                    Optional.ofNullable(Optional.ofNullable(MImage.get(Env.getCtx(), ((MOrgInfo)maybeOrgInfo.get()).getLogo_ID())).orElse(MImage.get(Env.getCtx(), MClientInfo.get(this.getCtx(), Env.getAD_Client_ID(this.getCtx()), this.get_TrxName()).getLogoReport_ID()))).ifPresent(image -> {
                        byte[] imageData = image.getData();
                        MAttachment attachment = printFormatItem.createAttachment();
                        attachment.setBinaryData(imageData);
                        if (attachment.getEntryCount() > 0) {
                            attachment.updateEntry(0, imageData);
                        } else {
                            attachment.addEntry(image.getName(), imageData);
                        }
                        attachment.saveEx();
                        CacheMgt.get().reset("ImageElement");
                    });
                    printFormatItemToPrint.updateAndGet(toPrint -> toPrint.replaceFirst("@Logo@", ""));
                }
                maybeLocation.ifPresent(location -> {
                    if (printFormatItemName.contains("@City@")) {
                        this.adjustPrintFormatItem((MPrintFormatItem)printFormatItem);
                        printFormatItemToPrint.updateAndGet(toPrint -> toPrint.replaceFirst("@City@", Optional.ofNullable(location.getCity()).orElse("")));
                    }
                    if (printFormatItemName.contains("@Address1@")) {
                        this.adjustPrintFormatItem((MPrintFormatItem)printFormatItem);
                        printFormatItemToPrint.updateAndGet(toPrint -> toPrint.replaceFirst("@Address1@", Optional.ofNullable(location.getAddress1()).orElse("")));
                    }
                    if (printFormatItemName.contains("@Address2@")) {
                        this.adjustPrintFormatItem((MPrintFormatItem)printFormatItem);
                        printFormatItemToPrint.updateAndGet(toPrint -> toPrint.replaceFirst("@Address2@", Optional.ofNullable(location.getAddress2()).orElse("")));
                    }
                    if (printFormatItemName.contains("@Address3@")) {
                        this.adjustPrintFormatItem((MPrintFormatItem)printFormatItem);
                        printFormatItemToPrint.updateAndGet(toPrint -> toPrint.replaceFirst("@Address3@", Optional.ofNullable(location.getAddress3()).orElse("")));
                    }
                    if (printFormatItemName.contains("@Address4@")) {
                        this.adjustPrintFormatItem((MPrintFormatItem)printFormatItem);
                        printFormatItemToPrint.updateAndGet(toPrint -> toPrint.replaceFirst("@Address1@", Optional.ofNullable(location.getAddress4()).orElse("")));
                    }
                });
                if (printFormatItemToPrint.get() != null) {
                    printFormatItem.setPrintName(printFormatItemToPrint.get());
                    printFormatItem.setIsPrinted(true);
                    printFormatItem.saveEx();
                } else {
                    printFormatItem.setPrintName(null);
                    printFormatItem.setIsPrinted(false);
                    printFormatItem.saveEx();
                }
            }));
            printFormatHeaderReference.set(printFormatHeader);
        });
        return printFormatHeaderReference.get();
    }

    private void adjustPrintFormatItem(MPrintFormatItem printFormatItem) {
        if (!printFormatItem.isPrinted()) {
            printFormatItem.setIsPrinted(true);
        }
        if (printFormatItem.isOrderBy()) {
            printFormatItem.setIsOrderBy(false);
        }
        if (printFormatItem.getSortNo() != 0) {
            printFormatItem.setSortNo(0);
        }
    }
}

