/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.compiere.process.ProcessInfo;
import org.compiere.util.ASyncProcess;
import org.compiere.util.CLogger;

public class ASyncWorker
extends Thread {
    private static CLogger log = CLogger.getCLogger(ASyncWorker.class);
    private ProcessInfo m_pi;
    private ASyncProcess m_parent;

    public static ProcessInfo executeSync(ASyncProcess parent, ProcessInfo pi) {
        ASyncWorker worker = new ASyncWorker(parent, pi);
        worker.start();
        try {
            worker.join();
        }
        catch (InterruptedException e) {
            log.log(Level.SEVERE, "executeSync", e);
        }
        return worker.getResult();
    }

    public ASyncWorker(ASyncProcess parent, ProcessInfo pi) {
        this.m_parent = parent;
        this.m_pi = pi;
    }

    @Override
    public void run() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ASyncWorker.this.m_parent.lockUI(ASyncWorker.this.m_pi);
            }
        });
        this.m_parent.executeASync(this.m_pi);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ASyncWorker.this.m_parent.unlockUI(ASyncWorker.this.m_pi);
            }
        });
    }

    public ProcessInfo getResult() {
        return this.m_pi;
    }
}

