/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.compiere.Adempiere;
import org.compiere.db.CConnection;
import org.compiere.model.MClient;
import org.compiere.util.CLogConsole;
import org.compiere.util.CLogErrorBuffer;
import org.compiere.util.CLogFile;
import org.compiere.util.CLogFilter;
import org.compiere.util.CLogFormatter;
import org.compiere.util.CLogMgtLog4J;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;
import org.compiere.util.ZipUtil;

public class CLogMgt {
    private static ArrayList<Handler> s_handlers = null;
    private static Level s_currentLevel = Level.INFO;
    private static Logger log = Logger.getAnonymousLogger();
    public static final Level[] LEVELS = new Level[]{Level.OFF, Level.SEVERE, Level.WARNING, Level.INFO, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST, Level.ALL};
    private static final String NL = System.getProperty("line.separator");

    public static void initialize(boolean isClient) {
        CLogFile fh;
        block11: {
            if (s_handlers != null) {
                return;
            }
            if (isClient) {
                LogManager mgr = LogManager.getLogManager();
                try {
                    String fileName = "logClient.properties";
                    InputStream in = CLogMgt.class.getResourceAsStream(fileName);
                    BufferedInputStream bin = new BufferedInputStream(in);
                    mgr.readConfiguration(bin);
                    in.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            s_handlers = new ArrayList();
            try {
                Logger rootLogger = Logger.getLogger("");
                Handler[] handlers = rootLogger.getHandlers();
                for (int i2 = 0; i2 < handlers.length; ++i2) {
                    if (s_handlers.contains(handlers[i2])) continue;
                    s_handlers.add(handlers[i2]);
                }
            }
            catch (Exception e) {
                if (e instanceof ClassNotFoundException) break block11;
                System.err.println(e.toString());
            }
        }
        if (CLogErrorBuffer.get(false) == null) {
            CLogMgt.addHandler(CLogErrorBuffer.get(true));
        }
        if (CLogConsole.get(false) == null) {
            CLogMgt.addHandler(CLogConsole.get(true));
        }
        if ((fh = CLogFile.get(false, null, isClient)) == null && !isClient) {
            fh = CLogFile.get(true, null, isClient);
            CLogMgt.addHandler(fh);
        }
        if (fh != null && !isClient) {
            System.out.println(fh);
        }
        CLogMgt.setFormatter(CLogFormatter.get());
        CLogMgt.setFilter(CLogFilter.get());
        CLogMgtLog4J.initialize(isClient);
    }

    protected static Handler[] getHandlers() {
        Handler[] handlers = new Handler[s_handlers.size()];
        for (int i2 = 0; i2 < s_handlers.size(); ++i2) {
            handlers[i2] = s_handlers.get(i2);
        }
        return handlers;
    }

    public static void addHandler(Handler handler) {
        if (handler == null) {
            return;
        }
        Logger rootLogger = Logger.getLogger("");
        rootLogger.addHandler(handler);
        s_handlers.add(handler);
        log.log(Level.CONFIG, "Handler=" + handler);
    }

    protected static void setFormatter(Formatter formatter) {
        for (int i2 = 0; i2 < s_handlers.size(); ++i2) {
            Handler handler = s_handlers.get(i2);
            handler.setFormatter(formatter);
        }
        log.log(Level.CONFIG, "Formatter=" + formatter);
    }

    protected static void setFilter(Filter filter) {
        for (int i2 = 0; i2 < s_handlers.size(); ++i2) {
            Handler handler = s_handlers.get(i2);
            handler.setFilter(filter);
        }
        log.log(Level.CONFIG, "Filter=" + filter);
    }

    public static void setLoggerLevel(Level level, String loggerNamePart) {
        if (level == null) {
            return;
        }
        LogManager mgr = LogManager.getLogManager();
        Enumeration<String> en = mgr.getLoggerNames();
        while (en.hasMoreElements()) {
            String name = en.nextElement().toString();
            if (loggerNamePart != null && name.indexOf(loggerNamePart) == -1) continue;
            Logger lll = Logger.getLogger(name);
            lll.setLevel(level);
        }
    }

    public static void setLevel(Level level) {
        if (level == null) {
            return;
        }
        if (s_handlers == null) {
            CLogMgt.initialize(true);
        }
        for (int i2 = 0; i2 < s_handlers.size(); ++i2) {
            Handler handler = s_handlers.get(i2);
            handler.setLevel(level);
        }
        CLogMgt.setJDBCDebug(s_currentLevel.intValue() == Level.ALL.intValue());
        if (level.intValue() != s_currentLevel.intValue()) {
            CLogMgt.setLoggerLevel(level, null);
            log.config(level.toString());
        }
        s_currentLevel = level;
    }

    public static void setLevel(int intLevel) {
        CLogMgt.setLevel(String.valueOf(intLevel));
    }

    public static void setLevel(String levelString) {
        if (levelString == null) {
            return;
        }
        for (int i2 = 0; i2 < LEVELS.length; ++i2) {
            if (!LEVELS[i2].getName().equals(levelString)) continue;
            CLogMgt.setLevel(LEVELS[i2]);
            return;
        }
        log.log(Level.CONFIG, "Ignored: " + levelString);
    }

    public static void setJDBCDebug(boolean enable) {
        if (enable) {
            DriverManager.setLogWriter(new PrintWriter(System.err));
        } else {
            DriverManager.setLogWriter(null);
        }
    }

    public static Level getLevel() {
        return s_currentLevel;
    }

    public static int getLevelAsInt() {
        return s_currentLevel.intValue();
    }

    public static boolean isLevel(Level level) {
        if (level == null) {
            return false;
        }
        return level.intValue() >= s_currentLevel.intValue();
    }

    public static boolean isLevelAll() {
        return Level.ALL.intValue() == s_currentLevel.intValue();
    }

    public static boolean isLevelFinest() {
        return Level.FINEST.intValue() >= s_currentLevel.intValue();
    }

    public static boolean isLevelFiner() {
        return Level.FINER.intValue() >= s_currentLevel.intValue();
    }

    public static boolean isLevelFine() {
        return Level.FINE.intValue() >= s_currentLevel.intValue();
    }

    public static boolean isLevelInfo() {
        return Level.INFO.intValue() >= s_currentLevel.intValue();
    }

    public static void enable(boolean enableLogging) {
        if (enableLogging) {
            CLogMgt.setLevel(s_currentLevel);
        } else {
            Level level = s_currentLevel;
            CLogMgt.setLevel(Level.OFF);
            s_currentLevel = level;
        }
    }

    public static void shutdown() {
        LogManager mgr = LogManager.getLogManager();
        mgr.reset();
    }

    public static void printProperties(Properties p2, String description, boolean logIt) {
        if (p2 == null) {
            return;
        }
        if (logIt) {
            log.info(description + " - Size=" + p2.size() + ", Hash=" + p2.hashCode() + "\n" + CLogMgt.getLocalHost());
        } else {
            System.out.println("Log.printProperties = " + description + ", Size=" + p2.size() + ", Hash=" + p2.hashCode() + "\n" + CLogMgt.getLocalHost());
        }
        Object[] pp = p2.keySet().toArray();
        Arrays.sort(pp);
        for (int i2 = 0; i2 < pp.length; ++i2) {
            String key = pp[i2].toString();
            String value = p2.getProperty(key);
            if (logIt) {
                log.config(key + "=" + value);
                continue;
            }
            System.out.println("  " + key + " = " + value);
        }
    }

    public static StringBuffer getInfo(StringBuffer sb) {
        Attributes atts;
        if (sb == null) {
            sb = new StringBuffer();
        }
        String eq = " = ";
        sb.append(CLogMgt.getMsg("Host")).append(" = ").append(CLogMgt.getServerInfo()).append(NL);
        sb.append(CLogMgt.getMsg("Database")).append(" = ").append(CLogMgt.getDatabaseInfo()).append(NL);
        sb.append(CLogMgt.getMsg("Schema")).append(" = ").append(CConnection.get().getDbUid()).append(NL);
        sb.append(CLogMgt.getMsg("AD_User_ID")).append(" = ").append(Env.getContext(Env.getCtx(), "#AD_User_Name")).append(NL);
        sb.append(CLogMgt.getMsg("AD_Role_ID")).append(" = ").append(Env.getContext(Env.getCtx(), "#AD_Role_Name")).append(NL);
        sb.append(CLogMgt.getMsg("AD_Client_ID")).append(" = ").append(Env.getContext(Env.getCtx(), "#AD_Client_Name")).append(NL);
        sb.append(CLogMgt.getMsg("AD_Org_ID")).append(" = ").append(Env.getContext(Env.getCtx(), "#AD_Org_Name")).append(NL);
        sb.append(CLogMgt.getMsg("Date")).append(" = ").append(Env.getContext(Env.getCtx(), "#Date")).append(NL);
        sb.append(CLogMgt.getMsg("Printer")).append(" = ").append(Env.getContext(Env.getCtx(), "#Printer")).append(NL);
        Manifest mf = ZipUtil.getManifest("CClient.jar");
        if (mf == null) {
            mf = ZipUtil.getManifest("CTools.jar");
        }
        if (mf != null && (atts = mf.getMainAttributes()) != null) {
            for (Object key : atts.keySet()) {
                if (!key.toString().startsWith("Impl") && !key.toString().startsWith("Spec")) continue;
                sb.append(key).append(" = ").append(atts.get(key)).append(NL);
            }
        }
        sb.append(CLogMgt.getMsg("ImplementationVendor")).append(" = ").append(Adempiere.getImplementationVendor()).append(NL);
        sb.append(CLogMgt.getMsg("ImplementationVersion")).append(" = ").append(Adempiere.getImplementationVersion()).append(NL);
        sb.append("AdempiereHome = ").append(Adempiere.getAdempiereHome()).append(NL);
        sb.append("AdempiereProperties = ").append(Ini.getPropertyFileName()).append(NL);
        sb.append(Env.getLanguage(Env.getCtx())).append(NL);
        MClient client = MClient.get(Env.getCtx());
        sb.append(client).append(NL);
        sb.append(CLogMgt.getMsg("IsMultiLingualDocument")).append(" = ").append(client.isMultiLingualDocument()).append(NL);
        sb.append("BaseLanguage = ").append(Env.isBaseLanguage(Env.getCtx(), "AD_Window")).append("/").append(Env.isBaseLanguage(Env.getCtx(), "C_UOM")).append(NL);
        sb.append(Adempiere.getJavaInfo()).append(NL);
        sb.append("java.io.tmpdir=" + System.getProperty("java.io.tmpdir")).append(NL);
        sb.append(Adempiere.getOSInfo()).append(NL);
        Runtime runtime = Runtime.getRuntime();
        sb.append("Max Heap = " + CLogMgt.formatMemoryInfo(runtime.maxMemory())).append(NL);
        sb.append("Allocated Heap = " + CLogMgt.formatMemoryInfo(runtime.totalMemory())).append(NL);
        sb.append("Free Heap = " + CLogMgt.formatMemoryInfo(runtime.freeMemory())).append(NL);
        sb.append("Active Threads = " + Thread.activeCount());
        return sb;
    }

    private static String formatMemoryInfo(long amount) {
        String unit = "";
        long size = amount / 1024L;
        if (size > 1024L) {
            size /= 1024L;
            unit = "M";
        } else {
            unit = "K";
        }
        return size + unit;
    }

    public static StringBuffer getInfoDetail(StringBuffer sb, Properties ctx) {
        if (sb == null) {
            sb = new StringBuffer();
        }
        if (ctx == null) {
            ctx = Env.getCtx();
        }
        CConnection cc = CConnection.get();
        sb.append(NL).append("=== Environment === ").append(Adempiere.getCheckSum()).append(NL).append(Adempiere.getSummaryAscii()).append(NL).append(CLogMgt.getLocalHost()).append(NL).append(cc.getName() + " " + cc.getDbUid() + "@" + cc.getConnectionURL()).append(NL).append(cc.getInfo()).append(NL);
        sb.append(NL).append("=== Context ===").append(NL);
        Object[] context = Env.getEntireContext(ctx);
        Arrays.sort(context);
        for (int i2 = 0; i2 < context.length; ++i2) {
            sb.append((String)context[i2]).append(NL);
        }
        sb.append(NL).append("=== System ===").append(NL);
        Object[] pp = System.getProperties().keySet().toArray();
        Arrays.sort(pp);
        for (int i3 = 0; i3 < pp.length; ++i3) {
            String key = pp[i3].toString();
            String value = System.getProperty(key);
            sb.append(key).append("=").append(value).append(NL);
        }
        return sb;
    }

    private static String getMsg(String msg) {
        if (DB.isConnected()) {
            return Msg.translate(Env.getCtx(), msg);
        }
        return msg;
    }

    private static String getServerInfo() {
        StringBuffer sb = new StringBuffer();
        CConnection cc = CConnection.get();
        sb.append(cc.getAppsHost()).append(" : ").append(cc.getAppsPort()).append(" (");
        if (cc.isAppsServerOK(false)) {
            sb.append(CConnection.get().getServerVersion());
        } else {
            sb.append(CLogMgt.getMsg("NotActive"));
        }
        sb.append(")\n  ");
        return sb.toString();
    }

    private static String getDatabaseInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append(CConnection.get().getDbHost()).append(" : ").append(CConnection.get().getDbPort()).append(" / ").append(CConnection.get().getDbName());
        if (CConnection.get().isViaFirewall()) {
            sb.append(CLogMgt.getMsg("via")).append(" ").append(CConnection.get().getFwHost()).append(" : ").append(CConnection.get().getFwPort());
        }
        return sb.toString();
    }

    private static String getLocalHost() {
        try {
            InetAddress id = InetAddress.getLocalHost();
            return id.toString();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "getLocalHost", e);
            return "-no local host info -";
        }
    }

    public CLogMgt() {
        this.testLog();
    }

    private void testLog() {
        final CLogger log1 = CLogger.getCLogger("test");
        log1.log(Level.SEVERE, "severe");
        log1.warning("warning");
        log1.info("Info");
        log1.config("config");
        log1.fine("fine");
        log1.finer("finer");
        log1.entering("myClass", "myMethod", "parameter");
        log1.exiting("myClass", "myMethod", "result");
        log1.finest("finest");
        new Thread(){

            @Override
            public void run() {
                log1.info("thread info");
            }
        }.start();
        try {
            Integer.parseInt("ABC");
        }
        catch (Exception e) {
            log1.log(Level.SEVERE, "error message", e);
        }
        log1.log(Level.INFO, "info message 1", "1Param");
        log1.log(Level.INFO, "info message n", new Object[]{"1Param", "2Param"});
    }

    public static void main(String[] args) {
        CLogMgt.initialize(true);
        new CLogMgt();
    }
}

