/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.services.dsl;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MInvoice;
import org.compiere.model.MPInstance;
import org.compiere.model.MProcess;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.util.ASyncProcess;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;
import org.compiere.util.Util;
import org.eevolution.process.BankTransfer;

public class ProcessBuilder {
    private ProcessBuilder thisBuilder;
    private Properties context;
    private ProcessInfo processInfo;
    private String title;
    private Integer processId;
    private Integer recordId;
    private Integer tableId;
    private Integer windowNo;
    private Integer seqNo;
    private Integer clientId;
    private Integer userId;
    private MPInstance instance;
    private MProcess process;
    private ASyncProcess parent;
    private List<Integer> selectedRecordsIds;
    private int tableSelectionId;
    private boolean isBatch = false;
    private boolean isPrintPreview = false;
    private String reportExportFormat = null;
    private Boolean isManagedTransaction = true;
    private Boolean isExecuteUsingSystemRole = false;
    private LinkedHashMap<Integer, LinkedHashMap<String, Object>> selection = null;
    private String aliasTableSelection;

    private ProcessBuilder(Properties context) {
        this.context = context;
        this.recordId = 0;
        this.windowNo = 0;
        this.seqNo = 0;
        this.tableId = 0;
        this.parent = null;
        this.selectedRecordsIds = new ArrayList<Integer>();
        this.tableSelectionId = 0;
        this.thisBuilder = this;
    }

    public static ProcessBuilder create(Properties context) {
        return new ProcessBuilder(context);
    }

    public ProcessBuilder process(Class<?> processClass) {
        this.process = MProcess.getUsingJavaClass(processClass);
        if (this.process == null) {
            throw new AdempiereException("@AD_Process_ID@ @NotFound@");
        }
        this.processId = this.process.getAD_Process_ID();
        return this;
    }

    public ProcessBuilder process(String value) {
        if (value == null || value.length() == 0) {
            throw new AdempiereException("@AD_Process_ID@ @NotFound@");
        }
        this.process = MProcess.get(this.context, MProcess.getProcess_ID(value, null));
        if (this.process == null) {
            throw new AdempiereException("@AD_Process_ID@ @NotFound@");
        }
        this.processId = this.process.getAD_Process_ID();
        return this;
    }

    public ProcessBuilder process(Integer processId) {
        if (processId == null || processId == 0) {
            throw new AdempiereException("@AD_Process_ID@ @NotFound@");
        }
        this.process = MProcess.get(this.context, processId);
        if (this.process == null) {
            throw new AdempiereException("@AD_Process_ID@ @NotFound@");
        }
        this.processId = this.process.getAD_Process_ID();
        return this;
    }

    private void generateProcessInstance() {
        if (this.processId == 0) {
            throw new AdempiereException("@AD_Process_ID@ @NotFound@");
        }
        this.instance = new MPInstance(this.context, (int)this.processId, this.recordId);
        this.instance.saveEx();
    }

    private void generateProcessInfo(String trxName) {
        if (this.instance == null) {
            this.generateProcessInstance();
        }
        boolean isSelection = this.selectedRecordsIds.size() > 0;
        this.processInfo = new ProcessInfo(this.title, this.processId, this.tableId, this.recordId, this.isManagedTransaction);
        this.processInfo.setAD_PInstance_ID(this.instance.getAD_PInstance_ID());
        this.processInfo.setClassName(MProcess.get(this.context, this.processId).getClassname());
        this.processInfo.setTransactionName(trxName);
        this.processInfo.setIsSelection(isSelection);
        this.processInfo.setPrintPreview(this.isPrintPreview());
        this.processInfo.setAliasForTableSelection(this.aliasTableSelection);
        if (this.clientId != null) {
            this.processInfo.setAD_Client_ID(this.clientId);
        }
        if (this.userId != null) {
            this.processInfo.setAD_User_ID(this.userId);
        }
        if (!Util.isEmpty(this.getReportExportFormat())) {
            this.processInfo.setReportType(this.getReportExportFormat());
        } else {
            this.processInfo.setReportType(this.instance.getReportType());
        }
        this.processInfo.setIsBatch(this.isBatch());
        if (this.isExecuteUsingSystemRole.booleanValue()) {
            this.processInfo.setAD_Client_ID(0);
            this.processInfo.setAD_User_ID(100);
        } else {
            this.processInfo.setAD_Client_ID(this.instance.getAD_Client_ID());
            this.processInfo.setAD_User_ID(this.instance.getAD_User_ID());
        }
        ProcessInfoUtil.setParameterFromDB(this.processInfo);
        if (isSelection) {
            this.processInfo.setSelectionKeys(this.selectedRecordsIds);
            this.processInfo.setTableSelectionId(this.tableSelectionId);
            this.processInfo.setSelectionValues(this.selection);
        }
    }

    private void run(String trxName) {
        Runnable processCtl = this.windowNo == 0 ? this.processCtl("org.compiere.process.ServerProcessCtl", this.parent, this.windowNo, this.processInfo, Trx.get(trxName, false)) : this.processCtl("org.compiere.apps.ProcessCtl", this.parent, this.windowNo, this.processInfo, Trx.get(trxName, false));
        processCtl.run();
    }

    private Runnable processCtl(String className, ASyncProcess parent, int windowNo, ProcessInfo processInfo, Trx trx) throws RuntimeException {
        Runnable result = null;
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> constructor = null;
            if (windowNo == 0) {
                constructor = clazz.getDeclaredConstructor(ASyncProcess.class, ProcessInfo.class, Trx.class);
                result = (Runnable)constructor.newInstance(parent, processInfo, trx);
            } else {
                constructor = clazz.getDeclaredConstructor(ASyncProcess.class, Integer.class, ProcessInfo.class, Trx.class);
                result = (Runnable)constructor.newInstance(parent, windowNo, processInfo, trx);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public ProcessInfo executeUsingSystemRole() {
        this.isExecuteUsingSystemRole = true;
        return this.execute();
    }

    public ProcessInfo execute() throws AdempiereException {
        try {
            Trx.run(trxName -> {
                this.generateProcessInfo(trxName);
                this.thisBuilder.run(trxName);
                if (this.processInfo.isError()) {
                    throw new AdempiereException("@ProcessRunError@ @Error@ " + this.processInfo.getSummary());
                }
            });
        }
        catch (AdempiereException e) {
            if (this.processInfo.isError()) {
                throw new AdempiereException(e.getMessage());
            }
            this.processInfo.setError(true);
            throw new AdempiereException("@ProcessRunError@ @Error@ " + e.getMessage());
        }
        return this.processInfo;
    }

    public ProcessInfo getProcessInfo() {
        return this.processInfo;
    }

    public ProcessInfo execute(String trxName) throws AdempiereException {
        try {
            Trx.run(trxName, new TrxRunnable(){

                @Override
                public void run(String trxName) {
                    ProcessBuilder.this.generateProcessInfo(trxName);
                    ProcessBuilder.this.thisBuilder.run(trxName);
                    if (ProcessBuilder.this.processInfo.isError()) {
                        throw new AdempiereException("@ProcessRunError@ @Error@ " + ProcessBuilder.this.processInfo.getSummary());
                    }
                }
            });
        }
        catch (AdempiereException e) {
            if (this.processInfo.isError()) {
                throw new AdempiereException(e.getMessage());
            }
            this.processInfo.setError(true);
            throw new AdempiereException("@ProcessRunError@ @Error@ " + e.getMessage());
        }
        return this.processInfo;
    }

    public ProcessBuilder withRecordId(Integer tableId, Integer recordId) {
        if (this.instance == null) {
            this.generateProcessInstance();
        }
        this.tableId = tableId;
        this.recordId = recordId;
        this.instance.setRecord_ID(recordId);
        this.instance.saveEx();
        return this;
    }

    public ProcessBuilder withWindowNo(Integer windowNo) {
        this.windowNo = windowNo;
        return this;
    }

    public ProcessBuilder withClientId(Integer clientId) {
        this.clientId = clientId;
        return this;
    }

    public ProcessBuilder withUserId(Integer userId) {
        this.userId = userId;
        return this;
    }

    public ProcessBuilder withSelectedRecordsIds(int tableSelectionId, List<Integer> selectedRecordsIds) {
        return this.withSelectedRecordsIds(tableSelectionId, null, selectedRecordsIds);
    }

    public ProcessBuilder withSelectedRecordsIds(int tableSelectionId, String aliasTableSelection, List<Integer> selectedRecordsIds) {
        this.selectedRecordsIds = selectedRecordsIds;
        this.tableSelectionId = tableSelectionId;
        this.aliasTableSelection = aliasTableSelection;
        return this;
    }

    public ProcessBuilder withSelectedRecordsIds(int tableSelectionId, List<Integer> selectedRecordsIds, LinkedHashMap<Integer, LinkedHashMap<String, Object>> selection) {
        this.selectedRecordsIds = selectedRecordsIds;
        this.selection = selection;
        this.tableSelectionId = tableSelectionId;
        return this;
    }

    public ProcessBuilder withoutTransactionClose() {
        this.isManagedTransaction = false;
        return this;
    }

    public ProcessBuilder withParameter(String name, Object value) {
        return this.withParameter(name, value, (Object)null);
    }

    public ProcessBuilder withParameter(String name, Object value, Object valueTo) {
        return this.withParameter(name, value, valueTo, this.seqNo + 10);
    }

    public ProcessBuilder withParameter(String parameterName, Object value, Integer sequence) {
        return this.withParameter(parameterName, value, null, sequence);
    }

    public ProcessBuilder withParameter(String parameterName, Object value, Object valueTo, Integer sequence) {
        if (Util.isEmpty(parameterName)) {
            return this;
        }
        if (this.instance == null) {
            this.generateProcessInstance();
        }
        this.seqNo = sequence;
        this.instance.createParameter(sequence, parameterName, value);
        if (valueTo != null) {
            this.instance.createParameter(sequence, parameterName + "_To", valueTo);
        }
        return this;
    }

    public ProcessBuilder withTitle(String title2) {
        this.title = title2;
        return this;
    }

    public ProcessBuilder withParentProcess(ASyncProcess parent) {
        this.parent = parent;
        return this;
    }

    public ProcessBuilder withoutPrintPreview() {
        this.isPrintPreview = false;
        return this;
    }

    public ProcessBuilder withPrintPreview() {
        this.isPrintPreview = true;
        return this;
    }

    public boolean isPrintPreview() {
        return this.isPrintPreview;
    }

    public ProcessBuilder withoutBatchMode() {
        this.isBatch = false;
        return this;
    }

    public ProcessBuilder withBatchMode() {
        this.isBatch = true;
        return this;
    }

    public boolean isBatch() {
        return this.isBatch;
    }

    public ProcessBuilder withReportExportFormat(String reportExportFormat) {
        this.reportExportFormat = reportExportFormat;
        return this;
    }

    public String getReportExportFormat() {
        return this.reportExportFormat;
    }

    public static void main(String[] args) {
        ProcessBuilder.create(Env.getCtx()).process(BankTransfer.class).withParentProcess(null).withParameter("", "").withParameter("", "").withRecordId(MInvoice.Table_ID, 10001).withoutTransactionClose().execute();
    }
}

