/*
 * Decompiled with CFR 0.152.
 */
package org.shw.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MBankAccount;
import org.compiere.model.MCharge;
import org.compiere.model.MPayment;
import org.compiere.model.MSysConfig;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class Doc_Payment
extends Doc {
    private String tenderType = null;
    private boolean prepayment = false;
    private boolean unidentified = false;
    private int bankAccountId = 0;

    public Doc_Payment(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, MPayment.class, rs, null, trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        MPayment pay = (MPayment)this.getPO();
        this.setDateDoc(pay.getDateTrx());
        this.tenderType = pay.getTenderType();
        this.prepayment = pay.isPrepayment();
        this.unidentified = pay.isUnidentifiedPayment();
        this.bankAccountId = pay.getC_BankAccount_ID();
        this.setAmount(0, pay.getPayAmt());
        return null;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        return retValue;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        Fact fact = new Fact(this, as, "A");
        int AD_Org_ID = this.getBank_Org_ID();
        if (this.getDocumentType().equals("ARR")) {
            FactLine fl;
            if ("X".equals(this.tenderType) && !MSysConfig.getBooleanValue("CASH_AS_PAYMENT", true, this.getAD_Client_ID())) {
                int defaultbankaccount = this.getdefaultBank_Account_ID();
                this.setC_BankAccount_ID(defaultbankaccount);
            }
            MAccount InTransit = this.getAccount(11, as);
            if ("X".equals(this.tenderType) && !MSysConfig.getBooleanValue("CASH_AS_PAYMENT", true, this.getAD_Client_ID())) {
                InTransit = this.getAccount(23, as);
            }
            if ((fl = fact.createLine(null, InTransit, this.getC_Currency_ID(), this.getAmount(), null)) != null && AD_Org_ID != 0) {
                fl.setAD_Org_ID(AD_Org_ID);
            }
            MAccount acct = null;
            acct = this.getC_Charge_ID() != 0 ? MCharge.getAccount(this.getC_Charge_ID(), as, this.getAmount()) : (this.prepayment ? this.getAccount(13, as) : (this.unidentified ? this.getAccount(15, as) : this.getAccount(10, as)));
            fl = fact.createLine(null, acct, this.getC_Currency_ID(), null, this.getAmount());
            if (fl != null && AD_Org_ID != 0 && this.getC_Charge_ID() == 0) {
                fl.setAD_Org_ID(AD_Org_ID);
            }
        } else if (this.getDocumentType().equals("APP")) {
            FactLine fl;
            MAccount acct = null;
            if ("X".equals(this.tenderType) && !MSysConfig.getBooleanValue("CASH_AS_PAYMENT", true, this.getAD_Client_ID())) {
                int defaultbankaccount = this.getdefaultBank_Account_ID();
                this.setC_BankAccount_ID(defaultbankaccount);
            }
            if ((fl = fact.createLine(null, acct = this.getC_Charge_ID() != 0 ? MCharge.getAccount(this.getC_Charge_ID(), as, this.getAmount()) : (this.prepayment ? this.getAccount(14, as) : (this.unidentified ? this.getAccount(15, as) : this.getAccount(12, as))), this.getC_Currency_ID(), this.getAmount(), null)) != null && AD_Org_ID != 0 && this.getC_Charge_ID() == 0) {
                fl.setAD_Org_ID(AD_Org_ID);
            }
            MAccount InTransit = this.getAccount(11, as);
            if ("X".equals(this.tenderType) && !MSysConfig.getBooleanValue("CASH_AS_PAYMENT", true, this.getAD_Client_ID())) {
                InTransit = this.getAccount(23, as);
            }
            if ((fl = fact.createLine(null, InTransit, this.getC_Currency_ID(), null, this.getAmount())) != null && AD_Org_ID != 0) {
                fl.setAD_Org_ID(AD_Org_ID);
            }
        } else {
            this.p_Error = "DocumentType unknown: " + this.getDocumentType();
            this.log.log(Level.SEVERE, this.p_Error);
            fact = null;
        }
        ArrayList<Fact> facts = new ArrayList<Fact>();
        facts.add(fact);
        return facts;
    }

    private int getBank_Org_ID() {
        if (this.bankAccountId == 0) {
            return 0;
        }
        MBankAccount ba = MBankAccount.get(this.getCtx(), this.bankAccountId);
        return ba.getAD_Org_ID();
    }

    private int getdefaultBank_Account_ID() {
        int defaultaccount = new Query(this.getCtx(), "C_BankAccount", "", null).setClient_ID().setOnlyActiveRecords(true).setOrderBy("C_Bankaccount_ID").firstId();
        return defaultaccount;
    }

    private MAccount getCashAcct(MAcctSchema as, int C_CashLine_ID) {
        String sql = "SELECT c.C_CashBook_ID FROM C_Cash c, C_CashLine cl WHERE c.C_Cash_ID=cl.C_Cash_ID AND cl.C_CashLine_ID=?";
        this.setC_CashBook_ID(DB.getSQLValue(null, sql, C_CashLine_ID));
        if (this.getC_CashBook_ID() <= 0) {
            this.log.log(Level.SEVERE, "NONE for C_CashLine_ID=" + C_CashLine_ID);
            return null;
        }
        return this.getAccount(21, as);
    }
}

