/*
 * Decompiled with CFR 0.152.
 */
package org.shw.einvoice.es.anulacionv2;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.regex.Pattern;

public class Documento {
    String tipoDte;
    String codigoGeneracion;
    String selloRecibido;
    String numeroControl;
    String fecEmi;
    BigDecimal montoIva;
    String codigoGeneracionR;
    String tipoDocumento;
    String numDocumento;
    String nombre;
    String telefono;
    String correo;

    public String getTipoDte() {
        return this.tipoDte;
    }

    public void setTipoDte(String tipoDte) {
        String[] validTipoDtes = new String[]{"01", "03", "04", "05", "06", "07", "08", "09", "10", "11", "14", "15"};
        boolean isTipoDteValid = Arrays.stream(validTipoDtes).anyMatch(tipoDte::equals);
        if (!isTipoDteValid) {
            throw new IllegalArgumentException("Wrong parameter 'tipoDte' in Anulacion.Documento.setTipoDte()");
        }
        this.tipoDte = tipoDte;
    }

    public String getCodigoGeneracion() {
        return this.codigoGeneracion;
    }

    public void setCodigoGeneracion(String codigoGeneracion) {
        boolean patternOK;
        int MINLENGTH = 36;
        int MAXLENGTH = 36;
        int length = codigoGeneracion == null ? 0 : codigoGeneracion.length();
        String PATTERN = "^[A-F0-9]{8}-[A-F0-9]{4}-[A-F0-9]{4}-[A-F0-9]{4}-[A-F0-9]{12}$";
        boolean bl = patternOK = codigoGeneracion != null && Pattern.matches("^[A-F0-9]{8}-[A-F0-9]{4}-[A-F0-9]{4}-[A-F0-9]{4}-[A-F0-9]{12}$", codigoGeneracion);
        if (length < 36 || length > 36 || !patternOK) {
            throw new IllegalArgumentException("Wrong parameter 'codigoGeneracion' in Anulacion.Documento.setCodigoGeneracion()");
        }
        this.codigoGeneracion = codigoGeneracion;
    }

    public String getSelloRecibido() {
        return this.selloRecibido;
    }

    public void setSelloRecibido(String selloRecibido) {
        boolean patternOK;
        int MINLENGTH = 40;
        int MAXLENGTH = 40;
        int length = selloRecibido == null ? 0 : selloRecibido.length();
        String PATTERN = "^[A-Z0-9]{40}$";
        boolean bl = patternOK = selloRecibido != null && Pattern.matches("^[A-Z0-9]{40}$", selloRecibido);
        if (length < 40 || length > 40 || !patternOK) {
            throw new IllegalArgumentException("Wrong parameter 'selloRecibido' in Anulacion.Documento.setSelloRecibido()");
        }
        this.selloRecibido = selloRecibido;
    }

    public String getNumeroControl() {
        return this.numeroControl;
    }

    public void setNumeroControl(String numeroControl) {
        boolean patternOK;
        int MINLENGTH = 31;
        int MAXLENGTH = 31;
        int length = numeroControl == null ? 0 : numeroControl.length();
        String PATTERN = "^DTE-0[0-9]|1[0-2]-[A-Z0-9]{8}-[0-9]{15}$";
        boolean bl = patternOK = numeroControl != null && Pattern.matches("^DTE-0[0-9]|1[0-2]-[A-Z0-9]{8}-[0-9]{15}$", numeroControl);
        if (length < 31 || length > 31 || !patternOK) {
            throw new IllegalArgumentException("Wrong parameter 'numeroControl' in Anulacion.Documento.setNumeroControl()");
        }
        this.numeroControl = numeroControl;
    }

    public String getFecEmi() {
        return this.fecEmi;
    }

    public void setFecEmi(String fecEmi) {
        if (fecEmi == null) {
            throw new IllegalArgumentException("Wrong parameter 'fecEmi' in Anulacion.Documento.setFecEmi()");
        }
        this.fecEmi = fecEmi;
    }

    public BigDecimal getMontoIva() {
        return this.montoIva;
    }

    public void setMontoIva(BigDecimal montoIva) {
        this.montoIva = montoIva;
    }

    public String getCodigoGeneracionR() {
        return this.codigoGeneracionR;
    }

    public void setCodigoGeneracionR(String codigoGeneracionR) {
        boolean patternOK;
        int MINLENGTH = 36;
        int MAXLENGTH = 36;
        int length = codigoGeneracionR == null ? 0 : codigoGeneracionR.length();
        String PATTERN = "^[A-F0-9]{8}-[A-F0-9]{4}-[A-F0-9]{4}-[A-F0-9]{4}-[A-F0-9]{12}$";
        boolean bl = patternOK = codigoGeneracionR != null && Pattern.matches("^[A-F0-9]{8}-[A-F0-9]{4}-[A-F0-9]{4}-[A-F0-9]{4}-[A-F0-9]{12}$", codigoGeneracionR);
        if (length < 36 || length > 36 || !patternOK) {
            throw new IllegalArgumentException("Wrong parameter 'codigoGeneracionR' in Anulacion.Documento.setCodigoGeneracionR()");
        }
        this.codigoGeneracionR = codigoGeneracionR;
    }

    public String getTipoDocumento() {
        return this.tipoDocumento;
    }

    public void setTipoDocumento(String tipoDocumento) {
        String[] validTipoDocumento = new String[]{"36", "13", "02", "03", "37"};
        boolean isTipoDocumentoValid = Arrays.stream(validTipoDocumento).anyMatch(tipoDocumento::equals);
        if (!isTipoDocumentoValid) {
            throw new IllegalArgumentException("Wrong parameter 'tipoDocumento' in Anulacion.Documento.setTipoDocumento()");
        }
        this.tipoDocumento = tipoDocumento;
    }

    public String getNumDocumento() {
        return this.numDocumento;
    }

    public void setNumDocumento(String numDocumento) {
        int length;
        int MINLENGTH = 3;
        int MAXLENGTH = 20;
        int n = length = numDocumento == null ? 0 : numDocumento.length();
        if (length < 3 || length > 20) {
            throw new IllegalArgumentException("Wrong parameter 'numDocumento' in Anulacion.Documento.setNumDocumento()");
        }
        this.numDocumento = numDocumento;
    }

    public String getNombre() {
        return this.nombre;
    }

    public void setNombre(String nombre) {
        int length;
        int MINLENGTH = 5;
        int MAXLENGTH = 200;
        int n = length = nombre == null ? 0 : nombre.length();
        if (length < 5 || length > 200) {
            throw new IllegalArgumentException("Wrong parameter 'nombre' in Anulacion.Documento.setNombre()");
        }
        this.nombre = nombre;
    }

    public String getTelefono() {
        return this.telefono;
    }

    public void setTelefono(String telefono) {
        boolean patternOK;
        int MINLENGTH = 8;
        int MAXLENGTH = 50;
        int length = telefono == null ? 0 : telefono.length();
        String PATTERN = "^[0-9+;]{8,50}$";
        boolean bl = patternOK = telefono != null && Pattern.matches("^[0-9+;]{8,50}$", telefono);
        if (length < 8 || length > 50 || !patternOK) {
            throw new IllegalArgumentException("Wrong parameter 'telefono' in Anulacion.Documento.setTelefono()");
        }
        this.telefono = telefono;
    }

    public String getCorreo() {
        return this.correo;
    }

    public void setCorreo(String correo) {
        int length;
        int MAXLENGTH = 100;
        int n = length = correo == null ? 0 : correo.length();
        if (length > 100) {
            throw new IllegalArgumentException("Wrong parameter 'correo' in Anulacion.Documento.setCorreo()");
        }
        this.correo = correo;
    }

    public static void main(String[] args) {
    }
}

