/*
 * Decompiled with CFR 0.152.
 */
package org.shw.einvoice.es.feccfcreditofiscalv3;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class CuerpoDocumentoItem {
    static final String VALIDATION_RESULT_OK = "OK";
    static final String VALIDATION_TRIBUTOS_NOT_NULL = "Documento: Credito Fiscal, clase: CuerpoDocumentoItem. Validacion fall\u00f3: valor de 'tributos' debe ser ='null'";
    static final String VALIDATION_TRIBUTOS_EMPTY = "Documento: Credito Fiscal, clase: CuerpoDocumentoItem. Validacion fall\u00f3: valor de 'tributos' no debe ser vac\u00edo";
    static final String VALIDATION_UDM_NOT_99 = "Documento: Credito Fiscal, clase: CuerpoDocumentoItem. Validacion fall\u00f3: valor de 'uniMedida' debe ser =99";
    static final String VALIDATION_TRIBUTOS_IS_NULL = "Documento: Credito Fiscal, clase: CuerpoDocumentoItem. Validacion fall\u00f3: valor de 'tributos' no debe ser ='null'";
    static final String VALIDATION_TRIBUTOS_NOT_20 = "Documento: Credito Fiscal, clase: CuerpoDocumentoItem. Validacion fall\u00f3: valor de 'tributos' debe ser ='20'";
    static final String VALIDATION_CODTRIBUTO_NOT_NULL = "Documento: Credito Fiscal, clase: CuerpoDocumentoItem. Validacion fall\u00f3: valor de 'codTributo' debe ser ='null'";
    static final String VALIDATION_TRIBUTOS_PATTERN_FAILED = "Documento: Credito Fiscal, clase: CuerpoDocumentoItem. Validacion fall\u00f3: valor de 'tributos' no corresponde a patr\u00f3n";
    int numItem;
    int tipoItem;
    String numeroDocumento = null;
    String codigo = null;
    String codTributo = null;
    int uniMedida;
    String descripcion;
    BigDecimal cantidad;
    BigDecimal precioUni;
    BigDecimal montoDescu;
    BigDecimal ventaNoSuj;
    BigDecimal ventaExenta;
    BigDecimal ventaGravada;
    ArrayList<String> tributos = null;
    BigDecimal psv;
    BigDecimal noGravado;

    public CuerpoDocumentoItem() {
    }

    public CuerpoDocumentoItem(int numItem, int tipoItem, String numeroDocumento, BigDecimal cantidad, String codigo, String codTributo, int uniMedida, String descripcion, BigDecimal precioUni, BigDecimal montoDescu, BigDecimal ventaNoSuj, BigDecimal ventaExenta, BigDecimal ventaGravada, ArrayList<String> tributos, BigDecimal psv, BigDecimal noGravado) {
        this.numItem = numItem;
        this.tipoItem = tipoItem;
        this.numeroDocumento = numeroDocumento;
        this.cantidad = cantidad;
        this.codigo = codigo;
        this.codTributo = codTributo;
        this.uniMedida = uniMedida;
        this.descripcion = descripcion;
        this.precioUni = precioUni;
        this.montoDescu = montoDescu;
        this.ventaNoSuj = ventaNoSuj;
        this.ventaExenta = ventaExenta;
        this.ventaGravada = ventaGravada;
        this.tributos = tributos;
        this.psv = psv;
        this.noGravado = noGravado;
    }

    public String validateValues() {
        if (this.getVentaGravada() == BigDecimal.ZERO) {
            if (this.getTributos() != null) {
                return VALIDATION_TRIBUTOS_NOT_NULL;
            }
        } else if (this.getTributos() == null || this.getTributos().isEmpty()) {
            return VALIDATION_TRIBUTOS_EMPTY;
        }
        if (this.getTipoItem() == 4) {
            if (this.getUniMedida() != 99) {
                return VALIDATION_UDM_NOT_99;
            }
            if (this.getCodTributo() == null) {
                return VALIDATION_TRIBUTOS_IS_NULL;
            }
            if (this.getTributos() == null || this.getTributos().isEmpty() || this.getTributos().get(0) != "20") {
                return VALIDATION_TRIBUTOS_NOT_20;
            }
        } else {
            if (this.getCodTributo() != null) {
                return VALIDATION_CODTRIBUTO_NOT_NULL;
            }
            ArrayList<String> expectedValues = new ArrayList<String>(List.of("20", "C3", "59", "71", "D1", "C5", "C6", "C7", "C8", "D5", "D4", "19", "28", "31", "32", "33", "34", "35", "36", "37", "38", "39", "42", "43", "44", "50", "51", "52", "53", "54", "55", "58", "77", "78", "79", "85", "86", "91", "92", "A1", "A5", "A7", "A9"));
            if (this.getTributos() != null && (this.getTributos().isEmpty() || expectedValues.indexOf(this.getTributos().get(0)) == -1)) {
                return VALIDATION_TRIBUTOS_PATTERN_FAILED;
            }
        }
        return VALIDATION_RESULT_OK;
    }

    public int getNumItem() {
        return this.numItem;
    }

    public void setNumItem(int numItem) {
        boolean MINIMUM = true;
        int MAXIMUM = 2000;
        if (numItem < 1 || numItem > 2000) {
            throw new IllegalArgumentException("Wrong parameter 'numItem' in CreditoFiscal.CuerpoDocumentoItem.setNumItem()");
        }
        this.numItem = numItem;
    }

    public int getTipoItem() {
        return this.tipoItem;
    }

    public void setTipoItem(int tipoItem) {
        if (tipoItem != 1 && tipoItem != 2 && tipoItem != 3 && tipoItem != 4) {
            throw new IllegalArgumentException("Wrong parameter 'tipoItem' in CreditoFiscal.CuerpoDocumentoItem.setTipoItem()");
        }
        this.tipoItem = tipoItem;
    }

    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    public void setNumeroDocumento(String numeroDocumento) {
        int length;
        boolean MINLENGTH = true;
        int MAXLENGTH = 36;
        int n = length = numeroDocumento == null ? 0 : numeroDocumento.length();
        if ((length < 1 || length > 36) && numeroDocumento != null) {
            throw new IllegalArgumentException("Wrong parameter 'numeroDocumento' in CreditoFiscal.CuerpoDocumentoItem.setNumeroDocumento()");
        }
        this.numeroDocumento = numeroDocumento;
    }

    public BigDecimal getCantidad() {
        return this.cantidad;
    }

    public void setCantidad(BigDecimal cantidad) {
        this.cantidad = cantidad;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public void setCodigo(String codigo) {
        int length;
        boolean MINLENGTH = true;
        int MAXLENGTH = 25;
        int n = length = codigo == null ? 0 : codigo.length();
        if ((length < 1 || length > 25) && codigo != null) {
            throw new IllegalArgumentException("Wrong parameter 'codigo' in CreditoFiscal.CuerpoDocumentoItem.setCodigo()");
        }
        this.codigo = codigo;
    }

    public String getCodTributo() {
        return this.codTributo;
    }

    public void setCodTributo(String codTributo) {
        if (codTributo != null && codTributo.compareTo("A8") != 0 && codTributo.compareTo("57") != 0 && codTributo.compareTo("90") != 0 && codTributo.compareTo("D4") != 0 && codTributo.compareTo("D5") != 0 && codTributo.compareTo("25") != 0 && codTributo.compareTo("A6") != 0) {
            throw new IllegalArgumentException("Wrong parameter 'codTributo' in CreditoFiscal.CuerpoDocumentoItem.setCodTributo()");
        }
        this.codTributo = codTributo;
    }

    public int getUniMedida() {
        return this.uniMedida;
    }

    public void setUniMedida(int uniMedida) {
        boolean MINIMUM = true;
        int MAXIMUM = 99;
        if (uniMedida < 1 || uniMedida > 99) {
            throw new IllegalArgumentException("Wrong parameter 'uniMedida' in CreditoFiscal.CuerpoDocumentoItem.setUniMedida()");
        }
        this.uniMedida = uniMedida;
    }

    public String getDescripcion() {
        return this.descripcion;
    }

    public void setDescripcion(String descripcion) {
        int length;
        int MAXLENGTH = 1000;
        int n = length = descripcion == null ? 0 : descripcion.length();
        if (length > 1000) {
            throw new IllegalArgumentException("Wrong parameter 'descripcion' in CreditoFiscal.CuerpoDocumentoItem.setDescripcion()");
        }
        this.descripcion = descripcion;
    }

    public BigDecimal getPrecioUni() {
        return this.precioUni;
    }

    public void setPrecioUni(BigDecimal precioUni) {
        this.precioUni = precioUni;
    }

    public BigDecimal getMontoDescu() {
        return this.montoDescu;
    }

    public void setMontoDescu(BigDecimal montoDescu) {
        this.montoDescu = montoDescu;
    }

    public BigDecimal getVentaNoSuj() {
        return this.ventaNoSuj;
    }

    public void setVentaNoSuj(BigDecimal ventaNoSuj) {
        this.ventaNoSuj = ventaNoSuj;
    }

    public BigDecimal getVentaExenta() {
        return this.ventaExenta;
    }

    public void setVentaExenta(BigDecimal ventaExenta) {
        this.ventaExenta = ventaExenta;
    }

    public BigDecimal getVentaGravada() {
        return this.ventaGravada;
    }

    public void setVentaGravada(BigDecimal ventaGravada) {
        this.ventaGravada = ventaGravada;
    }

    public BigDecimal getPsv() {
        return this.psv;
    }

    public void setPsv(BigDecimal psv) {
        this.psv = psv;
    }

    public BigDecimal getNoGravado() {
        return this.noGravado;
    }

    public void setNoGravado(BigDecimal noGravado) {
        this.noGravado = noGravado;
    }

    public ArrayList<String> getTributos() {
        return this.tributos;
    }

    public void setTributos(ArrayList<String> tributos) {
        boolean MINLENGTH = true;
        if (tributos != null && tributos.size() < 1) {
            throw new IllegalArgumentException("Wrong expression 'tributos' in CreditoFiscal.CuerpoDocumentoItem.setTributos()");
        }
        this.tributos = tributos;
    }

    public static void main(String[] args) {
    }
}

