/*
 * Decompiled with CFR 0.152.
 */
package org.shw.einvoice.es.feccfcreditofiscalv3;

import java.util.regex.Pattern;

public class DocumentoRelacionadoItem {
    static final String VALIDATION_RESULT_OK = "OK";
    static final String VALIDATION_NUMERODOCUMENTO_PATTERN_FAILED = "Documento: Credito Fiscal, clase: DocumentoRelacionadoItem. Validacion fall\u00f3: valor de 'numeroDocumento' no corresponde a patr\u00f3n";
    String tipoDocumento;
    int tipoGeneracion;
    String numeroDocumento;
    String fechaEmision;

    public DocumentoRelacionadoItem() {
    }

    public DocumentoRelacionadoItem(String tipoDocumento, int tipoGeneracion, String numeroDocumento, String fechaEmision) {
        this.tipoDocumento = tipoDocumento;
        this.tipoGeneracion = tipoGeneracion;
        this.numeroDocumento = numeroDocumento;
        this.fechaEmision = fechaEmision;
    }

    public String validateValues() {
        String PATTERN = "^[A-F0-9]{8}-[A-F0-9]{4}-[A-F0-9]{4}-[A-F0-9]{4}-[A-F0-9]{12}$";
        if (this.getTipoGeneracion() == 2) {
            boolean patternOK;
            boolean bl = patternOK = this.getNumeroDocumento() != null && Pattern.matches("^[A-F0-9]{8}-[A-F0-9]{4}-[A-F0-9]{4}-[A-F0-9]{4}-[A-F0-9]{12}$", this.getNumeroDocumento());
            if (!patternOK) {
                return VALIDATION_NUMERODOCUMENTO_PATTERN_FAILED;
            }
        }
        return VALIDATION_RESULT_OK;
    }

    public String getTipoDocumento() {
        return this.tipoDocumento;
    }

    public void setTipoDocumento(String tipoDocumento) {
        if (tipoDocumento.compareTo("04") != 0 && tipoDocumento.compareTo("08") != 0 && tipoDocumento.compareTo("09") != 0) {
            throw new IllegalArgumentException("Wrong parameter 'tipoDocumento' in CreditoFiscal.DocumentoRelacionadoItem.setTipoDocumento()");
        }
        this.tipoDocumento = tipoDocumento;
    }

    public int getTipoGeneracion() {
        return this.tipoGeneracion;
    }

    public void setTipoGeneracion(int tipoGeneracion) {
        if (tipoGeneracion != 1 && tipoGeneracion != 2) {
            throw new IllegalArgumentException("Wrong parameter 'tipoGeneracion' in CreditoFiscal.DocumentoRelacionadoItem.setTipoGeneracion()");
        }
        this.tipoGeneracion = tipoGeneracion;
    }

    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    public void setNumeroDocumento(String numeroDocumento) {
        int length;
        boolean MINLENGTH = true;
        int MAXLENGTH = 36;
        int n = length = numeroDocumento == null ? 0 : numeroDocumento.length();
        if (length < 1 || length > 36) {
            throw new IllegalArgumentException("Wrong parameter 'numeroDocumento' in CreditoFiscal.DocumentoRelacionadoItem.setNumeroDocumento()");
        }
        this.numeroDocumento = numeroDocumento;
    }

    public String getFechaEmision() {
        return this.fechaEmision;
    }

    public void setFechaEmision(String fechaEmision) {
        if (fechaEmision == null) {
            throw new IllegalArgumentException("Wrong parameter 'fechaEmision' in CreditoFiscal.DocumentoRelacionadoItem.setFechaEmision()");
        }
        this.fechaEmision = fechaEmision;
    }

    public static void main(String[] args) {
    }
}

