/*
 * Decompiled with CFR 0.152.
 */
package org.shw.einvoice.es.feccfcreditofiscalv3;

import java.util.regex.Pattern;

public class Identificacion {
    static final int VERSION = 3;
    static final String TIPO_DE_DOCUMENTO = "03";
    static final String TIPOMONEDA = "USD";
    static final String VALIDATION_RESULT_OK = "OK";
    static final String VALIDATION_TIPOMODELO_FAILED_1 = "Documento: Credito Fiscal, clase: Identificacion. Validacion fall\u00f3: valor de 'tipoModelo' no debe ser diferente a 1";
    static final String VALIDATION_TIPOCONTINGENCIA_NOT_NULL = "Documento: Credito Fiscal, clase: Identificacion. Validacion fall\u00f3: valor de 'tipoContingencia' debe ser ='null'";
    static final String VALIDATION_MOTIVOCONTINGENCIA_NOT_NULL = "Documento: Credito Fiscal, clase: Identificacion. Validacion fall\u00f3: valor de 'motivoContingencia' debe ser ='null'";
    static final String VALIDATION_TIPOMODELO_FAILED_2 = "Documento: Credito Fiscal, clase: Identificacion. Validacion fall\u00f3: valor de 'tipoModelo' no debe ser diferente a 2";
    static final String VALIDATION_TIPOCONTINGENCIA_IS_NULL = "Documento: Credito Fiscal, clase: Identificacion. Validacion fall\u00f3: valor de 'tipoContingencia' no debe ser ='null'";
    static final String VALIDATION_MOTIVOCONTINGENCIA_IS_NULL = "Documento: Credito Fiscal, clase: Identificacion. Validacion fall\u00f3: valor de 'motivoContingencia' no debe ser ='null'";
    int version = 3;
    String ambiente;
    String tipoDte = "03";
    String numeroControl;
    String codigoGeneracion;
    int tipoModelo;
    int tipoOperacion;
    Integer tipoContingencia = null;
    String motivoContin = null;
    String fecEmi;
    String horEmi;
    String tipoMoneda = "USD";

    public String validateValues() {
        if (this.getTipoOperacion() == 1) {
            if (this.getTipoModelo() != 1) {
                return VALIDATION_TIPOMODELO_FAILED_1;
            }
            if (this.getTipoContingencia() != null) {
                return VALIDATION_TIPOCONTINGENCIA_NOT_NULL;
            }
            if (this.getMotivoContin() != null) {
                return VALIDATION_MOTIVOCONTINGENCIA_NOT_NULL;
            }
        } else if (this.getTipoModelo() != 2) {
            return VALIDATION_TIPOMODELO_FAILED_2;
        }
        if (this.getTipoOperacion() == 2 && this.getTipoContingencia() == null) {
            return VALIDATION_TIPOCONTINGENCIA_IS_NULL;
        }
        if (this.getTipoContingencia() != null && this.getTipoContingencia() == 5 && this.getMotivoContin() == null) {
            return VALIDATION_MOTIVOCONTINGENCIA_IS_NULL;
        }
        return VALIDATION_RESULT_OK;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getAmbiente() {
        return this.ambiente;
    }

    public void setAmbiente(String ambiente) {
        if (ambiente.compareTo("00") != 0 && ambiente.compareTo("01") != 0) {
            throw new IllegalArgumentException("Wrong parameter 'ambiente' in CreditoFiscal.Identificacion.setAmbiente()");
        }
        this.ambiente = ambiente;
    }

    public String getTipoDte() {
        return this.tipoDte;
    }

    public void setTipoDte(String tipoDte) {
        this.tipoDte = tipoDte;
    }

    public String getNumeroControl() {
        return this.numeroControl;
    }

    public void setNumeroControl(String numeroControl) {
        boolean patternOK;
        String PATTERN = "^DTE-03-[A-Z0-9]{8}-[0-9]{15}$";
        boolean bl = patternOK = numeroControl != null && Pattern.matches("^DTE-03-[A-Z0-9]{8}-[0-9]{15}$", numeroControl);
        if (!patternOK) {
            throw new IllegalArgumentException("Wrong expression 'numeroControl' in CreditoFiscal.Identificacion.setNumeroControl()");
        }
        this.numeroControl = numeroControl;
    }

    public String getCodigoGeneracion() {
        return this.codigoGeneracion;
    }

    public Integer getTipoContingencia() {
        return this.tipoContingencia;
    }

    public void setTipoContingencia(Integer tipoContingencia) {
        if (tipoContingencia != null && tipoContingencia != 1 && tipoContingencia != 2 && tipoContingencia != 3 && tipoContingencia != 4 && tipoContingencia != 5) {
            throw new IllegalArgumentException("Wrong parameter 'tipoContingencia' in CreditoFiscal.Identificacion.setTipoContingencia()");
        }
        this.tipoContingencia = tipoContingencia;
    }

    public void setCodigoGeneracion(String codigoGeneracion) {
        boolean patternOK;
        String PATTERN = "^[A-F0-9]{8}-[A-F0-9]{4}-[A-F0-9]{4}-[A-F0-9]{4}-[A-F0-9]{12}$";
        boolean bl = patternOK = codigoGeneracion != null && Pattern.matches("^[A-F0-9]{8}-[A-F0-9]{4}-[A-F0-9]{4}-[A-F0-9]{4}-[A-F0-9]{12}$", codigoGeneracion);
        if (!patternOK) {
            throw new IllegalArgumentException("Wrong expression 'codigoGeneracion' in CreditoFiscal.Identificacion.setCodigoGeneracion()");
        }
        this.codigoGeneracion = codigoGeneracion;
    }

    public String getMotivoContin() {
        return this.motivoContin;
    }

    public void setMotivoContin(String motivoContin) {
        int length;
        boolean MINLENGTH = true;
        int MAXLENGTH = 150;
        int n = length = motivoContin == null ? 0 : motivoContin.length();
        if (length < 1 || length > 150) {
            throw new IllegalArgumentException("Wrong parameter 'motivoContin' in CreditoFiscal.Identificacion.setMotivoContin()");
        }
        this.motivoContin = motivoContin;
    }

    public String getFecEmi() {
        return this.fecEmi;
    }

    public void setFecEmi(String fecEmi) {
        if (fecEmi == null) {
            throw new IllegalArgumentException("Wrong parameter 'fecEmi' in CreditoFiscal.Identificacion.setFecEmi()");
        }
        this.fecEmi = fecEmi;
    }

    public String getHorEmi() {
        return this.horEmi;
    }

    public void setHorEmi(String horEmi) {
        boolean patternOK;
        String PATTERN = "^(0[0-9]|1[0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]?$";
        boolean bl = patternOK = horEmi != null && Pattern.matches("^(0[0-9]|1[0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]?$", horEmi);
        if (!patternOK) {
            throw new IllegalArgumentException("Wrong expression 'horEmi' in CreditoFiscal.Identificacion.setHorEmi()");
        }
        this.horEmi = horEmi;
    }

    public String getTipoMoneda() {
        return this.tipoMoneda;
    }

    public void setTipoMoneda(String tipoMoneda) {
        this.tipoMoneda = tipoMoneda;
    }

    public int getTipoModelo() {
        return this.tipoModelo;
    }

    public void setTipoModelo(int tipoModelo) {
        if (tipoModelo != 1 && tipoModelo != 2) {
            throw new IllegalArgumentException("Wrong parameter 'tipoModelo' in CreditoFiscal.Identificacion.setTipoModelo()");
        }
        this.tipoModelo = tipoModelo;
    }

    public int getTipoOperacion() {
        return this.tipoOperacion;
    }

    public void setTipoOperacion(int tipoOperacion) {
        if (tipoOperacion != 1 && tipoOperacion != 2) {
            throw new IllegalArgumentException("Wrong parameter 'tipoOperacion' in CreditoFiscal.Identificacion.setTipoOperacion()");
        }
        this.tipoOperacion = tipoOperacion;
    }

    public static void main(String[] args) {
    }
}

