/*
 * Decompiled with CFR 0.152.
 */
package org.shw.einvoice.es.fecrretencionv1;

import java.util.Arrays;
import java.util.regex.Pattern;
import org.shw.einvoice.es.util.pojo.Direccion;

public class Receptor {
    static final String VALIDATION_RESULT_OK = "OK";
    static final String VALIDATION_NUMERODOCUMENTO_PATTERN_FAILED = "Documento: Retencion, clase: Receptor. Validacion fall\u00f3: valor de 'numDocumento' no corresponde a patr\u00f3n";
    static final String VALIDATION_NRC_PATTERN_FAILED = "Documento: Retencion, clase: Receptor. Validacion fall\u00f3: valor de 'nrc' no corresponde a patr\u00f3n";
    String tipoDocumento = null;
    String numDocumento = null;
    String nrc;
    String nombre = null;
    String codActividad;
    String descActividad = null;
    String nombreComercial = null;
    Direccion direccion;
    String telefono = null;
    String correo;

    public Receptor() {
    }

    public Receptor(String tipoDocumento, String numDocumento, String nrc, String nombre, String codActividad, String descActividad, String nombreComercial, Direccion direccion, String telefono, String correo) {
        this.tipoDocumento = tipoDocumento;
        this.numDocumento = numDocumento;
        this.nrc = nrc;
        this.nombre = nombre;
        this.codActividad = codActividad;
        this.descActividad = descActividad;
        this.nombreComercial = nombreComercial;
        this.direccion = direccion;
        this.telefono = telefono;
        this.correo = correo;
    }

    public String validateValues() {
        boolean patternOK;
        String pattern;
        if (this.getTipoDocumento().equals("36")) {
            pattern = "^([0-9]{14}|[0-9]{9})$";
            boolean bl = patternOK = this.getNumDocumento() != null && Pattern.matches(pattern, this.getNumDocumento());
            if (!patternOK) {
                return VALIDATION_NUMERODOCUMENTO_PATTERN_FAILED;
            }
        }
        if (this.getTipoDocumento().equals("13")) {
            pattern = "^[0-9]{9}$";
            boolean bl = patternOK = this.getNumDocumento() != null && Pattern.matches(pattern, this.getNumDocumento());
            if (!patternOK) {
                return VALIDATION_NUMERODOCUMENTO_PATTERN_FAILED;
            }
        }
        if (this.getTipoDocumento().equals("36")) {
            pattern = "^[0-9]{1,8}$";
            boolean bl = patternOK = this.getNrc() != null && Pattern.matches(pattern, this.getNrc());
            if (!patternOK) {
                return VALIDATION_NRC_PATTERN_FAILED;
            }
        }
        return VALIDATION_RESULT_OK;
    }

    public String getTipoDocumento() {
        return this.tipoDocumento;
    }

    public void setTipoDocumento(String tipoDocumento) {
        String[] validTipoDocumento = new String[]{"36", "13", "02", "03", "37"};
        if (tipoDocumento != null) {
            if (Arrays.stream(validTipoDocumento).anyMatch(tipoDocumento::equals)) {
            } else {
                throw new IllegalArgumentException("Wrong parameter 'tipoDocumento' in Retencion.Receptor.setTipoDocumento()");
            }
        }
        this.tipoDocumento = tipoDocumento;
    }

    public String getNumDocumento() {
        return this.numDocumento;
    }

    public void setNumDocumento(String numDocumento) {
        int length;
        int MINLENGTH = 3;
        int MAXLENGTH = 20;
        int n = length = numDocumento == null ? 0 : numDocumento.length();
        if (length < 3 || length > 20) {
            throw new IllegalArgumentException("Wrong parameter 'numDocumento' in Retencion.Receptor.setNumDocumento()");
        }
        this.numDocumento = numDocumento;
    }

    public String getNrc() {
        return this.nrc;
    }

    public void setNrc(String nrc) {
        boolean patternOK;
        String PATTERN = "^[0-9]{1,8}$";
        boolean bl = patternOK = nrc != null && Pattern.matches("^[0-9]{1,8}$", nrc);
        if (!patternOK) {
            throw new IllegalArgumentException("Wrong expression 'nrc' in Retencion.Receptor.setNrc()");
        }
        this.nrc = nrc;
    }

    public String getNombre() {
        return this.nombre;
    }

    public void setNombre(String nombre) {
        int length;
        boolean MINLENGTH = true;
        int MAXLENGTH = 250;
        int n = length = nombre == null ? 0 : nombre.length();
        if (length < 1 || length > 250) {
            throw new IllegalArgumentException("Wrong parameter 'nombre' in Retencion.Receptor.setNombre()");
        }
        this.nombre = nombre;
    }

    public String getCodActividad() {
        return this.codActividad;
    }

    public void setCodActividad(String codActividad) {
        boolean patternOK;
        String PATTERN = "^[0-9]{5,6}$";
        boolean bl = patternOK = codActividad != null && Pattern.matches("^[0-9]{5,6}$", codActividad);
        if (!patternOK) {
            throw new IllegalArgumentException("Wrong expression 'codActividad' in Retencion.Receptor.setCodActividad()");
        }
        this.codActividad = codActividad;
    }

    public String getDescActividad() {
        return this.descActividad;
    }

    public void setDescActividad(String descActividad) {
        int length;
        int MINLENGTH = 5;
        int MAXLENGTH = 150;
        int n = length = descActividad == null ? 0 : descActividad.length();
        if (length < 5 || length > 150) {
            throw new IllegalArgumentException("Wrong parameter 'descActividad' in Retencion.Receptor.setDescActividad()");
        }
        this.descActividad = descActividad;
    }

    public String getNombreComercial() {
        return this.nombreComercial;
    }

    public void setNombreComercial(String nombreComercial) {
        int length;
        boolean MINLENGTH = true;
        int MAXLENGTH = 150;
        int n = length = nombreComercial == null ? 0 : nombreComercial.length();
        if ((length < 1 || length > 150) && nombreComercial != null) {
            throw new IllegalArgumentException("Wrong parameter 'nombreComercial' in Retencion.Receptor.setNombreComercial()");
        }
        this.nombreComercial = nombreComercial;
    }

    public Direccion getDireccion() {
        return this.direccion;
    }

    public void setDireccion(Direccion direccion) {
        this.direccion = direccion;
    }

    public String getTelefono() {
        return this.telefono;
    }

    public void setTelefono(String telefono) {
        int length;
        int MINLENGTH = 8;
        int MAXLENGTH = 30;
        int n = length = telefono == null ? 0 : telefono.length();
        if ((length < 8 || length > 30) && telefono != null) {
            throw new IllegalArgumentException("Wrong parameter 'telefono' in Retencion.Receptor.setTelefono()");
        }
        this.telefono = telefono;
    }

    public String getCorreo() {
        return this.correo;
    }

    public void setCorreo(String correo) {
        int length;
        int MAXLENGTH = 100;
        int n = length = correo == null ? 0 : correo.length();
        if (length > 100) {
            throw new IllegalArgumentException("Wrong parameter 'correo' in Retencion.Receptor.setCorreo()");
        }
        this.correo = correo;
    }

    public static void main(String[] args) {
    }
}

