/*
 * Decompiled with CFR 0.152.
 */
package org.shw.einvoice.es.fefcfacturaelectronicav1;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.adempiere.core.domains.models.X_E_InvoiceElectronic;
import org.apache.commons.lang3.StringUtils;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MInvoiceTax;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MTax;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.shw.einvoice.es.fefcfacturaelectronicav1.CuerpoDocumentoItem;
import org.shw.einvoice.es.fefcfacturaelectronicav1.EI_CreateInvoice_Factura_SVAbstract;
import org.shw.einvoice.es.fefcfacturaelectronicav1.FacturaElectronica;
import org.shw.einvoice.es.fefcfacturaelectronicav1.Identificacion;
import org.shw.einvoice.es.fefcfacturaelectronicav1.Receptor;
import org.shw.einvoice.es.fefcfacturaelectronicav1.Resumen;
import org.shw.einvoice.es.util.pojo.ApendiceItem;
import org.shw.einvoice.es.util.pojo.Direccion;
import org.shw.einvoice.es.util.pojo.Emisor;
import org.shw.einvoice.es.util.pojo.Extension;
import org.shw.einvoice.es.util.pojo.PagosItem;

public class EI_CreateInvoice_Factura_SV
extends EI_CreateInvoice_Factura_SVAbstract {
    static final String VALIDATION_RESULT_OK = "OK";
    String numeroControl;
    String codigoGeneracion;
    MClient client = null;
    MOrgInfo orgInfo = null;
    List<MInvoiceTax> invoiceTaxes = null;
    BigDecimal zero = new BigDecimal(0.0);
    StringBuffer error = new StringBuffer();

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        MInvoice invoice = new MInvoice(this.getCtx(), this.getInvoiceId(), this.get_TrxName());
        this.invoiceTaxes = new Query(this.getCtx(), "C_InvoiceTax", "C_Invoice_ID=?", this.get_TrxName()).setParameters(invoice.getC_Invoice_ID()).list();
        int orgID = invoice.getAD_Org_ID();
        this.orgInfo = MOrgInfo.get(this.getCtx(), orgID, this.get_TrxName());
        this.client = new MClient(this.getCtx(), invoice.getAD_Client_ID(), this.get_TrxName());
        Integer id = invoice.get_ID();
        String idIdentification = StringUtils.leftPad((String)id.toString(), (int)15, (String)"0");
        String duns = this.orgInfo.getDUNS().replace("-", "");
        this.numeroControl = "DTE-01-" + StringUtils.leftPad((String)duns.trim(), (int)8, (String)"0") + "-" + idIdentification;
        Integer clientID = this.client.getAD_Client_ID();
        this.codigoGeneracion = StringUtils.leftPad((String)clientID.toString(), (int)8, (String)"0") + "-0000-0000-0000-" + StringUtils.leftPad((String)id.toString(), (int)12, (String)"0");
        if (invoice.getC_DocType().getE_DocType_ID() <= 0 || !invoice.getC_DocType().getE_DocType().getValue().equals("01")) {
            this.error.append("el documento no es Factura");
            return this.error.toString();
        }
        FacturaElectronica facturaElectronica = new FacturaElectronica();
        try {
            this.fillReceptor(facturaElectronica.getReceptor(), invoice);
        }
        catch (Exception e) {
            this.error.append(e);
        }
        try {
            this.fillemisor(facturaElectronica.getEmisor(), invoice);
        }
        catch (Exception e) {
            this.error.append(e);
        }
        try {
            this.fillResumen(facturaElectronica.getResumen(), invoice);
        }
        catch (Exception e) {
            this.error.append(e);
        }
        try {
            this.fillIdentification(facturaElectronica.getIdentificacion(), invoice);
        }
        catch (Exception e) {
            this.error.append(e);
        }
        for (MInvoiceLine invoiceLine : invoice.getLines()) {
            int numItem = invoiceLine.getLine();
            int tipoItem = 2;
            String numeroDocumento = this.numeroControl;
            BigDecimal cantidad = invoiceLine.getQtyInvoiced();
            String codigo = invoiceLine.getM_Product_ID() > 0 ? invoiceLine.getProduct().getValue() : invoiceLine.getC_Charge().getName();
            ArrayList tributosItems = new ArrayList();
            int uniMedida = 1;
            String descripcion = invoiceLine.getM_Product_ID() > 0 ? invoiceLine.getM_Product().getName() : invoiceLine.getC_Charge().getName();
            BigDecimal precioUni = invoiceLine.getPriceActual();
            BigDecimal montoDescu = Env.ZERO;
            BigDecimal ventaNoSuj = Env.ZERO;
            BigDecimal ventaExenta = Env.ZERO;
            BigDecimal ventaGravada = Env.ONEHUNDRED;
            BigDecimal ivaItem = Env.ZERO;
            if (invoiceLine.getC_Tax().getTaxIndicator().equals("NSUJ")) {
                ventaNoSuj = invoiceLine.getLineNetAmt();
            }
            if (invoiceLine.getC_Tax().getTaxIndicator().equals("EXT")) {
                ventaExenta = invoiceLine.getLineNetAmt();
            }
            if (invoiceLine.getC_Tax().getTaxIndicator().equals("IVA")) {
                ventaGravada = invoiceLine.getLineNetAmt();
                MTax tax = (MTax)invoiceLine.getC_Tax();
                if (invoiceLine.getTaxAmt().compareTo(Env.ZERO) == 0) {
                    ivaItem = tax.calculateTax(invoiceLine.getLineNetAmt(), invoice.getM_PriceList().isTaxIncluded(), 2);
                }
            }
            BigDecimal psv = invoiceLine.getTaxAmt();
            BigDecimal noGravado = ventaNoSuj.add(ventaNoSuj);
            CuerpoDocumentoItem cuerpoDocumentoItem = new CuerpoDocumentoItem(numItem, tipoItem, numeroDocumento, cantidad, codigo, null, uniMedida, descripcion, precioUni, montoDescu, ventaNoSuj, ventaExenta, ventaGravada, null, psv, noGravado, ivaItem);
            cuerpoDocumentoItem.validateValues();
            facturaElectronica.getCuerpoDocumento().add(cuerpoDocumentoItem);
        }
        this.validateValues(facturaElectronica, this.error);
        X_E_InvoiceElectronic invoiceElectronic = new X_E_InvoiceElectronic(this.getCtx(), 0, this.get_TrxName());
        invoiceElectronic.setC_Invoice_ID(invoice.getC_Invoice_ID());
        invoiceElectronic.setei_ValidationStatus("01");
        if (this.error.length() > 0) {
            invoiceElectronic.seterrMsgIntern(this.error.toString());
            invoiceElectronic.setei_ValidationStatus("02");
            invoiceElectronic.saveEx();
            return this.error.toString();
        }
        ObjectMapper objectMapper = new ObjectMapper();
        String json = objectMapper.writeValueAsString((Object)facturaElectronica);
        invoiceElectronic.setjson(json);
        invoiceElectronic.saveEx();
        this.log.config(json);
        System.out.println(json);
        return "";
    }

    private void fillIdentification(Identificacion identificacion, MInvoice invoice) {
        identificacion.setNumeroControl(this.numeroControl);
        identificacion.setCodigoGeneracion(this.codigoGeneracion);
        identificacion.setTipoModelo(1);
        identificacion.setTipoOperacion(1);
        String fecha = invoice.getDateAcct().toString().substring(0, 10);
        identificacion.setFecEmi(fecha);
        identificacion.setHorEmi("00:00:00");
        identificacion.setTipoMoneda("USD");
        identificacion.setAmbiente("00");
    }

    private void fillemisor(Emisor emisor, MInvoice invoice) {
        emisor.setNit(this.orgInfo.getTaxID().replace("-", ""));
        emisor.setNrc(StringUtils.leftPad((String)this.orgInfo.getDUNS().trim().replace("-", ""), (int)7));
        emisor.setNombre(this.client.getName());
        emisor.setCodActividad(this.client.getE_Activity().getValue());
        emisor.setDescActividad(this.client.getE_Activity().getName());
        emisor.setNombreComercial(this.client.getDescription());
        emisor.setTipoEstablecimiento(this.client.getE_PlantType().getValue());
        String departamento = this.orgInfo.getC_Location().getC_City().getC_Region().getValue();
        String municipio = this.orgInfo.getC_Location().getC_City().getValue();
        String complemento = this.orgInfo.getC_Location().getAddress1();
        Direccion direccion = new Direccion(departamento, municipio, complemento);
        emisor.setDireccion(direccion);
        emisor.setTelefono(this.client.get_ValueAsString("phone"));
        emisor.setCorreo(this.client.getEMail());
    }

    private void fillReceptor(Receptor receptor, MInvoice invoice) {
        MBPartner partner = (MBPartner)invoice.getC_BPartner();
        if (partner.getE_Activity_ID() <= 0 || partner.getE_Recipient_Identification_ID() <= 0) {
            this.error.append("SdN: Falta configuracion para Facturacion Electronica");
            return;
        }
        receptor.setTipoDocumento(partner.getE_Recipient_Identification().getValue());
        if (receptor.getTipoDocumento().equals("NIT")) {
            receptor.setNumDocumento(partner.getTaxID());
        }
        receptor.setNombre(partner.getName());
        receptor.setCodActividad(partner.getI_E_Activity().getValue());
        receptor.setDescActividad(partner.getI_E_Activity().getName());
        String departamento = "";
        String municipio = "";
        Object complemento = "";
        for (MBPartnerLocation partnerLocation : MBPartnerLocation.getForBPartner(this.getCtx(), partner.getC_BPartner_ID(), this.get_TrxName())) {
            if (!partnerLocation.isBillTo()) continue;
            departamento = partnerLocation.getC_Location().getC_City().getC_Region().getValue();
            municipio = partnerLocation.getC_Location().getC_City().getValue();
            complemento = partnerLocation.getC_Location().getAddress1() + " " + partnerLocation.getC_Location().getAddress2();
            break;
        }
        Direccion direccion = new Direccion(departamento, municipio, (String)complemento);
        receptor.setDireccion(direccion);
        receptor.setTelefono("79309099");
        receptor.setCorreo(partner.get_ValueAsString("EMail"));
    }

    private void fillResumen(Resumen resumen, MInvoice invoice) {
        BigDecimal TotalNoSuj = Env.ZERO;
        BigDecimal TotalExenta = Env.ZERO;
        BigDecimal TotalGravada = Env.ZERO;
        BigDecimal SubTotalVentas = Env.ZERO;
        BigDecimal DescuNoSuj = Env.ZERO;
        BigDecimal DescuExenta = Env.ZERO;
        BigDecimal DescuGravada = Env.ZERO;
        BigDecimal PorcentajeDescuento = Env.ZERO;
        BigDecimal SubTotal = invoice.getTotalLines();
        BigDecimal IvaPerci1 = Env.ZERO;
        BigDecimal IvaRete1 = Env.ZERO;
        BigDecimal MontoTotalOperacion = invoice.getGrandTotal();
        BigDecimal TotalPagar = invoice.getGrandTotal();
        BigDecimal totalIVA = Env.ZERO;
        int CondicionOperacion = 2;
        ArrayList<PagosItem> pagosItems = new ArrayList<PagosItem>();
        PagosItem pagoitem = new PagosItem("05", this.zero, "Transferencia_ Dep\u00f3sito Bancario", invoice.getC_PaymentTerm().getE_TimeSpan().getValue(), invoice.getC_PaymentTerm().getNetDays());
        pagosItems.add(pagoitem);
        resumen.setPagos(pagosItems);
        String TotalLetras = Msg.getAmtInWords(Env.getLanguage(this.getCtx()), invoice.getGrandTotal().setScale(2).toString());
        BigDecimal SaldoFavor = Env.ZERO;
        for (MInvoiceTax invoiceTax : this.invoiceTaxes) {
            if (invoiceTax.getC_Tax().getTaxIndicator().equals("NSUJ")) {
                TotalNoSuj = invoiceTax.getTaxBaseAmt();
            }
            if (!invoiceTax.getC_Tax().getTaxIndicator().equals("NSUJ") && invoiceTax.getC_Tax().getRate().doubleValue() == 0.0) {
                TotalExenta = invoiceTax.getTaxBaseAmt();
            }
            if (invoiceTax.getC_Tax().getTaxIndicator().equals("NSUJ") || invoiceTax.getC_Tax().getRate().doubleValue() == 0.0) continue;
            TotalGravada = invoiceTax.getTaxBaseAmt();
            totalIVA = invoiceTax.getTaxAmt();
        }
        resumen.setTotalNoSuj(TotalNoSuj);
        resumen.setTotalExenta(TotalExenta);
        resumen.setTotalGravada(TotalGravada);
        resumen.setSubTotalVentas(TotalGravada.add(TotalNoSuj).add(TotalExenta));
        resumen.setDescuNoSuj(DescuNoSuj);
        resumen.setDescuExenta(DescuExenta);
        resumen.setDescuGravada(DescuGravada);
        resumen.setPorcentajeDescuento(PorcentajeDescuento);
        resumen.setSubTotal(TotalGravada.add(TotalNoSuj).add(TotalExenta));
        resumen.setIvaRete1(IvaRete1);
        resumen.setMontoTotalOperacion(invoice.getGrandTotal());
        resumen.setTotalNoGravado(TotalExenta.add(TotalNoSuj));
        resumen.setTotalPagar(invoice.getGrandTotal());
        resumen.setTotalLetras(TotalLetras);
        resumen.setSaldoFavor(invoice.getGrandTotal());
        resumen.setCondicionOperacion(1);
        resumen.setTotalDescu(Env.ZERO);
        resumen.setReteRenta(Env.ZERO);
        resumen.setTotalIva(totalIVA);
    }

    private void fillExtension(Extension extension, MInvoice invoice) {
        extension.setDocuEntrega("555");
        extension.setDocuRecibe("555");
        extension.setNombEntrega("55");
        extension.setNombRecibe("55");
        extension.setObservaciones("55");
    }

    private void fillApendiceItem(ApendiceItem apendiceItem, MInvoice invoice) {
        apendiceItem.setCampo("11");
        apendiceItem.setEtiqueta("777");
        apendiceItem.setValor("uu");
    }

    private void validateValues(FacturaElectronica facturaElectronica, StringBuffer error) {
        String result = "";
        if (facturaElectronica.getResumen() != null && !(result = facturaElectronica.getResumen().validateValues()).equals(VALIDATION_RESULT_OK)) {
            error.append(result);
        }
        if (facturaElectronica.getIdentificacion() != null && !(result = facturaElectronica.getIdentificacion().validateValues()).equals(VALIDATION_RESULT_OK)) {
            error.append(result);
        }
        if (facturaElectronica.getReceptor() != null && !(result = facturaElectronica.getReceptor().validateValues()).equals(VALIDATION_RESULT_OK)) {
            error.append(result);
        }
        if (facturaElectronica.getCuerpoDocumento() != null) {
            for (CuerpoDocumentoItem cuerpoDocumentoItem : facturaElectronica.getCuerpoDocumento()) {
                result = cuerpoDocumentoItem.validateValues();
                if (result.equals(VALIDATION_RESULT_OK)) continue;
                error.append(result);
            }
        }
    }
}

