/*
 * Decompiled with CFR 0.152.
 */
package org.shw.einvoice.es.fefexfacturaexportacionv1;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.adempiere.core.domains.models.X_E_InvoiceElectronic;
import org.apache.commons.lang3.StringUtils;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MInvoiceTax;
import org.compiere.model.MOrgInfo;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.shw.einvoice.es.fefexfacturaexportacionv1.CuerpoDocumentoItem;
import org.shw.einvoice.es.fefexfacturaexportacionv1.EI_CreateInvoice_FacturaExport_SVAbstract;
import org.shw.einvoice.es.fefexfacturaexportacionv1.Emisor;
import org.shw.einvoice.es.fefexfacturaexportacionv1.FacturaExportacion;
import org.shw.einvoice.es.fefexfacturaexportacionv1.Identificacion;
import org.shw.einvoice.es.fefexfacturaexportacionv1.Receptor;
import org.shw.einvoice.es.fefexfacturaexportacionv1.Resumen;
import org.shw.einvoice.es.util.pojo.Direccion;
import org.shw.einvoice.es.util.pojo.PagosItem;

public class EI_CreateInvoice_FacturaExport_SV
extends EI_CreateInvoice_FacturaExport_SVAbstract {
    static final String VALIDATION_RESULT_OK = "OK";
    String numeroControl;
    String codigoGeneracion;
    MClient client = null;
    MOrgInfo orgInfo = null;
    List<MInvoiceTax> invoiceTaxes = null;
    BigDecimal zero = new BigDecimal(0.0);
    StringBuffer error = new StringBuffer();

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        MInvoice invoice = new MInvoice(this.getCtx(), this.getInvoiceId(), this.get_TrxName());
        this.invoiceTaxes = new Query(this.getCtx(), "C_InvoiceTax", "C_Invoice_ID=?", this.get_TrxName()).setParameters(invoice.getC_Invoice_ID()).list();
        int orgID = invoice.getAD_Org_ID();
        this.orgInfo = MOrgInfo.get(this.getCtx(), orgID, this.get_TrxName());
        this.client = new MClient(this.getCtx(), invoice.getAD_Client_ID(), this.get_TrxName());
        Integer id = invoice.get_ID();
        String idIdentification = StringUtils.leftPad((String)id.toString(), (int)15, (String)"0");
        String duns = this.orgInfo.getDUNS().replace("-", "");
        this.numeroControl = "DTE-11-" + StringUtils.leftPad((String)duns.trim(), (int)8, (String)"0") + "-" + idIdentification;
        Integer clientID = this.client.getAD_Client_ID();
        this.codigoGeneracion = StringUtils.leftPad((String)clientID.toString(), (int)8, (String)"0") + "-0000-0000-0000-" + StringUtils.leftPad((String)id.toString(), (int)12, (String)"0");
        if (invoice.getC_DocType().getE_DocType_ID() <= 0 || !invoice.getC_DocType().getE_DocType().getValue().equals("11")) {
            this.error.append("el documento no es Factura");
            return this.error.toString();
        }
        FacturaExportacion facturaExportacion = new FacturaExportacion();
        try {
            this.fillReceptor(facturaExportacion.getReceptor(), invoice);
        }
        catch (Exception e) {
            this.error.append(e);
        }
        try {
            this.fillemisor(facturaExportacion.getEmisor(), invoice);
        }
        catch (Exception e) {
            this.error.append(e);
        }
        try {
            this.fillResumen(facturaExportacion.getResumen(), invoice);
        }
        catch (Exception e) {
            this.error.append(e);
        }
        try {
            this.fillIdentification(facturaExportacion.getIdentificacion(), invoice);
        }
        catch (Exception e) {
            this.error.append(e);
        }
        try {
            for (MInvoiceLine invoiceLine : invoice.getLines()) {
                int numItem = invoiceLine.getLine();
                BigDecimal cantidad = invoiceLine.getQtyInvoiced();
                String codigo = invoiceLine.getM_Product_ID() > 0 ? invoiceLine.getProduct().getValue() : invoiceLine.getC_Charge().getName();
                ArrayList<String> tributosItems = new ArrayList<String>();
                tributosItems.add("C3");
                int uniMedida = 1;
                String descripcion = invoiceLine.getM_Product_ID() > 0 ? invoiceLine.getM_Product().getName() : invoiceLine.getC_Charge().getName();
                BigDecimal precioUni = invoiceLine.getPriceActual();
                BigDecimal montoDescu = Env.ZERO;
                BigDecimal ventaNoSuj = Env.ZERO;
                BigDecimal ventaExenta = Env.ZERO;
                BigDecimal ventaGravada = Env.ONEHUNDRED;
                if (invoiceLine.getC_Tax().getTaxIndicator().equals("NSUJ")) {
                    ventaNoSuj = invoiceLine.getLineNetAmt();
                }
                if (!invoiceLine.getC_Tax().getTaxIndicator().equals("EXT")) {
                    ventaExenta = invoiceLine.getLineNetAmt();
                }
                if (!invoiceLine.getC_Tax().getTaxIndicator().equals("IVA")) {
                    ventaGravada = invoiceLine.getLineNetAmt();
                }
                BigDecimal noGravado = ventaNoSuj.add(ventaNoSuj);
                CuerpoDocumentoItem cuerpoDocumentoItem = new CuerpoDocumentoItem(numItem, cantidad, codigo, uniMedida, descripcion, precioUni, montoDescu, ventaGravada, tributosItems, noGravado);
                cuerpoDocumentoItem.validateValues();
                facturaExportacion.getCuerpoDocumento().add(cuerpoDocumentoItem);
            }
        }
        catch (Exception e) {
            this.error.append(e);
        }
        this.validateValues(facturaExportacion, this.error);
        X_E_InvoiceElectronic invoiceElectronic = new X_E_InvoiceElectronic(this.getCtx(), 0, this.get_TrxName());
        invoiceElectronic.setC_Invoice_ID(invoice.getC_Invoice_ID());
        invoiceElectronic.setei_ValidationStatus("01");
        if (this.error.length() > 0) {
            invoiceElectronic.seterrMsgIntern(this.error.toString());
            invoiceElectronic.setei_ValidationStatus("02");
            invoiceElectronic.saveEx();
            return this.error.toString();
        }
        ObjectMapper objectMapper = new ObjectMapper();
        String json = objectMapper.writeValueAsString((Object)facturaExportacion);
        invoiceElectronic.setjson(json);
        invoiceElectronic.saveEx();
        this.log.config(json);
        System.out.println(json);
        return "";
    }

    private void fillIdentification(Identificacion identificacion, MInvoice invoice) {
        identificacion.setNumeroControl(this.numeroControl);
        identificacion.setCodigoGeneracion(this.codigoGeneracion);
        identificacion.setTipoModelo(1);
        identificacion.setTipoOperacion(1);
        String fecha = invoice.getDateAcct().toString().substring(0, 10);
        identificacion.setFecEmi(fecha);
        identificacion.setHorEmi("00:00:00");
        identificacion.setTipoMoneda("USD");
        identificacion.setAmbiente("00");
    }

    private void fillemisor(Emisor emisor, MInvoice invoice) {
        emisor.setNit(this.orgInfo.getTaxID().replace("-", ""));
        emisor.setNrc(StringUtils.leftPad((String)this.orgInfo.getDUNS().trim().replace("-", ""), (int)7));
        emisor.setNombre(this.client.getName());
        emisor.setCodActividad(this.client.getE_Activity().getValue());
        emisor.setDescActividad(this.client.getE_Activity().getName());
        emisor.setNombreComercial(this.client.getDescription());
        emisor.setTipoEstablecimiento(this.client.getE_PlantType().getValue());
        String departamento = this.orgInfo.getC_Location().getC_City().getC_Region().getValue();
        String municipio = this.orgInfo.getC_Location().getC_City().getValue();
        String complemento = this.orgInfo.getC_Location().getAddress1();
        Direccion direccion = new Direccion(departamento, municipio, complemento);
        emisor.setDireccion(direccion);
        emisor.setTelefono(this.client.get_ValueAsString("phone"));
        emisor.setCorreo(this.client.getEMail());
        emisor.setTipoItemExpor(2);
        emisor.setCodPuntoVentaMH(null);
    }

    private void fillReceptor(Receptor receptor, MInvoice invoice) {
        MBPartner partner = (MBPartner)invoice.getC_BPartner();
        String codPais = "";
        String nombrePais = "";
        Object complemento = "";
        String departamento = "";
        String municipio = "";
        Object telefono = null;
        Object correo = null;
        receptor.setNombre(partner.getName());
        if (partner.getE_Recipient_Identification_ID() <= 0 || partner.getE_Activity_ID() <= 0 || partner.getE_BPType_ID() < 0) {
            this.error.append("SdN: Falta configuracion para Fcturacion Electronica");
            return;
        }
        receptor.setTipoDocumento(partner.getE_Recipient_Identification().getValue());
        if (partner.getE_Recipient_Identification().getValue().equals("36")) {
            receptor.setNumDocumento(partner.getTaxID().replace("-", ""));
        } else {
            receptor.setNumDocumento(partner.getDUNS());
        }
        receptor.setNombreComercial(partner.getName());
        receptor.setDescActividad(partner.getDescription());
        receptor.setTipoPersona(Integer.valueOf(partner.getE_BPType().getValue()));
        for (MBPartnerLocation partnerLocation : MBPartnerLocation.getForBPartner(this.getCtx(), partner.getC_BPartner_ID(), this.get_TrxName())) {
            if (!partnerLocation.isBillTo()) continue;
            if (partnerLocation.getC_Location().getC_City_ID() > 0) {
                departamento = partnerLocation.getC_Location().getC_City().getC_Region().getValue();
            }
            municipio = partnerLocation.getC_Location().getCity();
            complemento = partnerLocation.getC_Location().getAddress1() + " " + partnerLocation.getC_Location().getAddress2();
            codPais = partnerLocation.getC_Location().getC_Country().getValue();
            nombrePais = partnerLocation.getC_Location().getC_Country().getName();
            break;
        }
        receptor.setCodPais(codPais);
        receptor.setNombrePais(nombrePais);
        receptor.setComplemento((String)complemento);
        receptor.setCorreo(partner.getEMail());
        receptor.setTelefono(partner.getPhone());
    }

    private void fillResumen(Resumen resumen, MInvoice invoice) {
        BigDecimal totalGravada = null;
        String totalLetras = Msg.getAmtInWords(Env.getLanguage(this.getCtx()), invoice.getGrandTotal().setScale(2).toString());
        ArrayList<PagosItem> pagosItems = new ArrayList<PagosItem>();
        PagosItem pagoitem = new PagosItem("05", this.zero, "Transferencia_ Dep\u00f3sito Bancario", invoice.getC_PaymentTerm().getE_TimeSpan().getValue(), invoice.getC_PaymentTerm().getNetDays());
        pagosItems.add(pagoitem);
        resumen.setPagos(pagosItems);
        BigDecimal SaldoFavor = Env.ZERO;
        for (MInvoiceTax invoiceTax : this.invoiceTaxes) {
            totalGravada = invoiceTax.getTaxBaseAmt();
        }
        resumen.setCondicionOperacion(2);
        resumen.setTotalDescu(totalGravada);
        resumen.setDescuento(Env.ZERO);
        resumen.setPorcentajeDescuento(Env.ZERO);
        resumen.setTotalDescu(Env.ZERO);
        resumen.setMontoTotalOperacion(invoice.getGrandTotal());
        resumen.setTotalNoGravado(Env.ZERO);
        resumen.setTotalGravada(invoice.getGrandTotal());
        resumen.setTotalPagar(invoice.getGrandTotal());
        resumen.setTotalLetras(totalLetras);
    }

    private void validateValues(FacturaExportacion facturaExportacion, StringBuffer error) {
        String result = "";
        if (facturaExportacion.getIdentificacion() != null && !(result = facturaExportacion.getIdentificacion().validateValues()).equals(VALIDATION_RESULT_OK)) {
            error.append(result);
        }
        if (facturaExportacion.getReceptor() != null && !(result = facturaExportacion.getReceptor().validateValues()).equals(VALIDATION_RESULT_OK)) {
            error.append(result);
        }
        if (facturaExportacion.getEmisor() != null && !(result = facturaExportacion.getEmisor().validateValues()).equals(VALIDATION_RESULT_OK)) {
            error.append(result);
        }
        if (facturaExportacion.getCuerpoDocumento() != null) {
            for (CuerpoDocumentoItem cuerpoDocumentoItem : facturaExportacion.getCuerpoDocumento()) {
                result = cuerpoDocumentoItem.validateValues();
                if (result.equals(VALIDATION_RESULT_OK)) continue;
                error.append(result);
            }
        }
    }
}

