/*
 * Decompiled with CFR 0.152.
 */
package org.shw.einvoice.es.fefexfacturaexportacionv1;

import java.util.Arrays;
import java.util.regex.Pattern;

public class Receptor {
    static final String VALIDATION_RESULT_OK = "OK";
    static final String VALIDATION_NUMDOCUMENTO_PATTERN_FAILED = "Documento: Factura de Exportacion, clase: Receptor. Validacion fall\u00f3: valor de 'numDocumento' no corresponde a patr\u00f3n";
    String nombre;
    String tipoDocumento;
    String numDocumento;
    String nombreComercial = null;
    String codPais;
    String nombrePais;
    String complemento;
    int tipoPersona;
    String descActividad;
    String telefono = null;
    String correo = null;

    public String validateValues() {
        boolean patternOK;
        String pattern;
        if (this.getTipoDocumento() != null && this.getTipoDocumento().equals("36")) {
            pattern = "^([0-9]{14}|[0-9]{9})$";
            boolean bl = patternOK = this.getNumDocumento() != null && Pattern.matches(pattern, this.getNumDocumento());
            if (!patternOK) {
                return VALIDATION_NUMDOCUMENTO_PATTERN_FAILED;
            }
        }
        if (this.getTipoDocumento() != null && this.getTipoDocumento().equals("13")) {
            pattern = "^[0-9]{8}-[0-9]{1}$";
            boolean bl = patternOK = this.getNumDocumento() != null && Pattern.matches(pattern, this.getNumDocumento());
            if (!patternOK) {
                return VALIDATION_NUMDOCUMENTO_PATTERN_FAILED;
            }
        }
        return VALIDATION_RESULT_OK;
    }

    public String getTipoDocumento() {
        return this.tipoDocumento;
    }

    public void setTipoDocumento(String tipoDocumento) {
        String[] validTipoDocumento = new String[]{"36", "13", "02", "03", "37"};
        if (!Arrays.stream(validTipoDocumento).anyMatch(tipoDocumento::equals)) {
            throw new IllegalArgumentException("Wrong parameter 'tipoDocumento' in FacturaExportacion.Receptor.setTipoDocumento()");
        }
        this.tipoDocumento = tipoDocumento;
    }

    public String getNumDocumento() {
        return this.numDocumento;
    }

    public void setNumDocumento(String numDocumento) {
        int length;
        int MINLENGTH = 3;
        int MAXLENGTH = 20;
        int n = length = numDocumento == null ? 0 : numDocumento.length();
        if (length < 3 || length > 20) {
            throw new IllegalArgumentException("Wrong parameter 'numDocumento' in FacturaExportacion.Receptor.setNumDocumento()");
        }
        this.numDocumento = numDocumento;
    }

    public String getNombreComercial() {
        return this.nombreComercial;
    }

    public void setNombreComercial(String nombreComercial) {
        int length;
        boolean MINLENGTH = true;
        int MAXLENGTH = 150;
        int n = length = nombreComercial == null ? 0 : nombreComercial.length();
        if ((length < 1 || length > 150) && nombreComercial != null) {
            throw new IllegalArgumentException("Wrong parameter 'nombreComercial' in FacturaExportacion.Receptor.setNombreComercial()");
        }
        this.nombreComercial = nombreComercial;
    }

    public String getCodPais() {
        return this.codPais;
    }

    public void setCodPais(String codPais) {
        String[] validPais = new String[]{"9320", "9539", "9565", "9905", "9999", "9303", "9306", "9309", "9310", "9315", "9317", "9318", "9319", "9324", "9327", "9330", "9333", "9336", "9339", "9342", "9345", "9348", "9349", "9350", "9354", "9357", "9360", "9363", "9366", "9372", "9374", "9375", "9377", "9378", "9381", "9384", "9387", "9390", "9393", "9394", "9396", "9399", "9402", "9405", "9408", "9411", "9414", "9417", "9420", "9423", "9426", "9432", "9435", "9438", "9440", "9441", "9444", "9446", "9447", "9450", "9453", "9456", "9459", "9462", "9465", "9468", "9471", "9474", "9477", "9480", "9481", "9483", "9486", "9487", "9495", "9498", "9501", "9504", "9507", "9513", "9516", "9519", "9522", "9525", "9526", "9528", "9531", "9534", "9537", "9540", "9543", "9544", "9546", "9549", "9552", "9555", "9558", "9561", "9564", "9567", "9570", "9573", "9576", "9577", "9582", "9585", "9591", "9594", "9597", "9600", "9601", "9603", "9606", "9609", "9611", "9612", "9615", "9618", "9621", "9624", "9627", "9633", "9636", "9638", "9639", "9642", "9645", "9648", "9651", "9660", "9663", "9666", "9669", "9672", "9675", "9677", "9678", "9679", "9680", "9681", "9682", "9683", "9684", "9687", "9690", "9691", "9693", "9696", "9699", "9702", "9705", "9706", "9707", "9708", "9714", "9717", "9720", "9722", "9723", "9725", "9726", "9727", "9729", "9732", "9735", "9738", "9739", "9740", "9741", "9744", "9747", "9750", "9756", "9758", "9759", "9760", "9850", "9862", "9863", "9865", "9886", "9898", "9899", "9897", "9887", "9571", "9300", "9369", "9439", "9510", "9579", "9654", "9711", "9736", "9737", "9640", "9641", "9673", "9472", "9311", "9733", "9541", "9746", "9551", "9451", "9338", "9353", "9482", "9494", "9524", "9304", "9332", "9454", "9457", "9489", "9491", "9492", "9523", "9530", "9532", "9535", "9542", "9547", "9548", "9574", "9598", "9602", "9607", "9608", "9623", "9652", "9692", "9709", "9712", "9716", "9718", "9719", "9751", "9452", "9901", "9902", "9903", "9664", "9415", "9904", "9514", "9906", "9359", "9493", "9521", "9533", "9538", "9689", "9713", "9449", "9888", "9490", "9527", "9529", "9536", "9545", "9568", "9610", "9622", "9643", "9667", "9676", "9685", "9686", "9688", "9715", "9900", "9371", "9376", "9907"};
        if (!Arrays.stream(validPais).anyMatch(codPais::equals)) {
            throw new IllegalArgumentException("Wrong parameter 'codPais' in FacturaExportacion.Receptor.setCodPais()");
        }
        this.codPais = codPais;
    }

    public String getNombrePais() {
        return this.nombrePais;
    }

    public void setNombrePais(String nombrePais) {
        int length;
        int MINLENGTH = 3;
        int MAXLENGTH = 50;
        int n = length = nombrePais == null ? 0 : nombrePais.length();
        if (length < 3 || length > 50) {
            throw new IllegalArgumentException("Wrong parameter 'nombrePais' in FacturaExportacion.Receptor.setNombrePais()");
        }
        this.nombrePais = nombrePais;
    }

    public String getComplemento() {
        return this.complemento;
    }

    public void setComplemento(String complemento) {
        int length;
        int MINLENGTH = 5;
        int MAXLENGTH = 300;
        int n = length = complemento == null ? 0 : complemento.length();
        if (length < 5 || length > 300) {
            throw new IllegalArgumentException("Wrong parameter 'complemento' in FacturaExportacion.Receptor.setComplemento()");
        }
        this.complemento = complemento;
    }

    public int getTipoPersona() {
        return this.tipoPersona;
    }

    public void setTipoPersona(int tipoPersona) {
        if (tipoPersona != 1 && tipoPersona != 2) {
            throw new IllegalArgumentException("Wrong parameter 'tipoPersona' in FacturaExportacion.Receptor.setTipoPersona()");
        }
        this.tipoPersona = tipoPersona;
    }

    public String getNombre() {
        return this.nombre;
    }

    public void setNombre(String nombre) {
        int length;
        boolean MINLENGTH = true;
        int MAXLENGTH = 250;
        int n = length = nombre == null ? 0 : nombre.length();
        if (length < 1 || length > 250) {
            throw new IllegalArgumentException("Wrong parameter 'nombre' in FacturaExportacion.Receptor.setNombre()");
        }
        this.nombre = nombre;
    }

    public String getDescActividad() {
        return this.descActividad;
    }

    public void setDescActividad(String descActividad) {
        int length;
        int MINLENGTH = 5;
        int MAXLENGTH = 150;
        int n = length = descActividad == null ? 0 : descActividad.length();
        if (length < 5 || length > 150) {
            throw new IllegalArgumentException("Wrong parameter 'descActividad' in FacturaExportacion.Receptor.setDescActividad()");
        }
        this.descActividad = descActividad;
    }

    public String getTelefono() {
        return this.telefono;
    }

    public void setTelefono(String telefono) {
        int length;
        int MINLENGTH = 8;
        int MAXLENGTH = 50;
        int n = length = telefono == null ? 0 : telefono.length();
        if ((length < 8 || length > 50) && telefono != null) {
            throw new IllegalArgumentException("Wrong parameter 'telefono' in FacturaExportacion.Receptor.setTelefono()");
        }
        this.telefono = telefono;
    }

    public String getCorreo() {
        return this.correo;
    }

    public void setCorreo(String correo) {
        int length;
        int MINLENGTH = 3;
        int MAXLENGTH = 100;
        int n = length = correo == null ? 0 : correo.length();
        if ((length < 3 || length > 100) && correo != null) {
            throw new IllegalArgumentException("Wrong parameter 'correo' in FacturaExportacion.Receptor.setCorreo()");
        }
        this.correo = correo;
    }

    public static void main(String[] args) {
    }
}

