/*
 * Decompiled with CFR 0.152.
 */
package org.shw.einvoice.es.util.pojo;

import java.util.Hashtable;
import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.process.ProcessInfo;
import org.eevolution.services.dsl.ProcessBuilder;
import org.shw.einvoice.es.feccfcreditofiscalv3.EI_CreateInvoice_CCFF_SV;
import org.shw.einvoice.es.fefcfacturaelectronicav1.EI_CreateInvoice_Factura_SV;
import org.shw.einvoice.es.fefexfacturaexportacionv1.EI_CreateInvoice_FacturaExport_SV;
import org.shw.einvoice.es.util.pojo.SB_ElectronicInvoiceAbstract;

public class SB_ElectronicInvoice
extends SB_ElectronicInvoiceAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() {
        String filedirectory = this.getDirectory();
        List<?> invoices = this.getInstancesForSelection(this.get_TrxName());
        Hashtable<Integer, MInvoice> invoicesList = new Hashtable<Integer, MInvoice>();
        invoices.forEach(invoice -> {
            if (!invoicesList.contains(invoice.get_ID())) {
                invoicesList.put(invoice.get_ID(), (MInvoice)invoice);
            }
        });
        invoicesList.forEach((key, invoice) -> {
            MDocType docType = (MDocType)invoice.getC_DocType();
            if (docType.get_ValueAsInt("C_INvoiceType_ID") == 1000003) {
                this.processingCCFF((MInvoice)invoice);
            }
            if (docType.get_ValueAsInt("C_INvoiceType_ID") == 1000004) {
                this.processingFactura((MInvoice)invoice);
            }
            if (docType.get_ValueAsInt("C_INvoiceType_ID") == 1000006) {
                this.processingFacturaExportacion((MInvoice)invoice);
            }
        });
        return "";
    }

    private void processingCCFF(MInvoice invoice) {
        ProcessInfo processInfo = ProcessBuilder.create(this.getCtx()).process(EI_CreateInvoice_CCFF_SV.getProcessId()).withParameter("C_Invoice_ID", invoice.getC_Invoice_ID()).withParameter("IsSaveInHistoric", this.isSaveInHistoric()).withoutTransactionClose().execute(this.get_TrxName());
        if (processInfo.isError()) {
            throw new AdempiereException(processInfo.getSummary());
        }
        this.addLog(processInfo.getSummary());
    }

    private void processingFactura(MInvoice invoice) {
        ProcessInfo processInfo = ProcessBuilder.create(this.getCtx()).process(EI_CreateInvoice_Factura_SV.getProcessId()).withParameter("C_Invoice_ID", invoice.getC_Invoice_ID()).withParameter("IsSaveInHistoric", this.isSaveInHistoric()).withoutTransactionClose().execute(this.get_TrxName());
        if (processInfo.isError()) {
            throw new AdempiereException(processInfo.getSummary());
        }
        this.addLog(processInfo.getSummary());
    }

    private void processingFacturaExportacion(MInvoice invoice) {
        ProcessInfo processInfo = ProcessBuilder.create(this.getCtx()).process(EI_CreateInvoice_FacturaExport_SV.getProcessId()).withParameter("C_Invoice_ID", invoice.getC_Invoice_ID()).withParameter("IsSaveInHistoric", this.isSaveInHistoric()).withoutTransactionClose().execute(this.get_TrxName());
        if (processInfo.isError()) {
            throw new AdempiereException(processInfo.getSummary());
        }
        this.addLog(processInfo.getSummary());
    }
}

