/*
 * Decompiled with CFR 0.152.
 */
package org.shw.model;

import java.math.BigDecimal;
import java.util.Properties;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.util.Env;

public class CalloutSHW_WeightStation
extends CalloutEngine {
    private boolean steps = false;

    public String weight_net(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        BigDecimal MovementQty;
        MUOMConversion[] rates;
        if (Env.isSOTrx(ctx, WindowNo) && mField.getColumnName().equals("Weight_tare")) {
            return "";
        }
        if (!Env.isSOTrx(ctx, WindowNo) && mField.getColumnName().equals("Weight_gross")) {
            return "";
        }
        BigDecimal weightGross = (BigDecimal)mTab.getValue("Weight_gross");
        BigDecimal weightTare = (BigDecimal)mTab.getValue("Weight_tare");
        BigDecimal weightPacking = (BigDecimal)mTab.getValue("Weight_PackingMaterial");
        BigDecimal netweight = weightGross.subtract(weightTare).subtract(weightPacking);
        mTab.setValue("Weight_net", (Object)netweight);
        BigDecimal factor = Env.ZERO;
        int c_UOM_ID = Env.getContextAsInt(ctx, WindowNo, "C_UOM_ID");
        int M_Product_ID = Env.getContextAsInt(ctx, WindowNo, "M_Product_ID");
        int m_Product_ID = Env.getContextAsInt(ctx, WindowNo, "M_Product_ID");
        int uom_Libra = 1000017;
        for (MUOMConversion rate : rates = MUOMConversion.getProductConversions(ctx, m_Product_ID)) {
            if (rate.getC_UOM_To_ID() != uom_Libra || rate.getC_UOM_ID() != c_UOM_ID) continue;
            factor = rate.getDivideRate();
            break;
        }
        BigDecimal qty = (BigDecimal)mTab.getValue("Weight_net");
        qty = qty.multiply(factor);
        mTab.setValue("QtyEntered", (Object)qty);
        int C_UOM_To_ID = Env.getContextAsInt(ctx, WindowNo, "C_UOM_ID");
        BigDecimal QtyEntered = qty;
        BigDecimal QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision(ctx, C_UOM_To_ID), 4);
        if (QtyEntered.compareTo(QtyEntered1) != 0) {
            this.log.fine("Corrected QtyEntered Scale UOM=" + C_UOM_To_ID + "; QtyEntered=" + QtyEntered + "->" + QtyEntered1);
            QtyEntered = QtyEntered1;
            mTab.setValue("QtyEntered", (Object)QtyEntered);
        }
        if ((MovementQty = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, QtyEntered)) == null) {
            MovementQty = QtyEntered;
        }
        boolean conversion = QtyEntered.compareTo(MovementQty) != 0;
        Env.setContext(ctx, WindowNo, "UOMConversion", conversion ? "Y" : "N");
        mTab.setValue("MovementQty", (Object)MovementQty);
        return "";
    }

    public String weight_total(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        MInOutLine[] lines;
        int M_Inout_ID = Env.getContextAsInt(ctx, WindowNo, "M_InOut_ID");
        BigDecimal c = Env.ZERO;
        BigDecimal peso = Env.ZERO;
        MInOut inout = new MInOut(ctx, M_Inout_ID, null);
        for (MInOutLine line : lines = inout.getLines()) {
            c = line.getC_UOM_ID() == 1000017 ? Env.ONE : MUOMConversion.getProductRateTo(ctx, line.getM_Product_ID(), 1000017);
            if (c == null) {
                return "No hay conversi\u00f3n a libra para " + line.getM_Product().getName();
            }
            peso = peso.add(c.multiply(line.getMovementQty()));
        }
        peso = peso.add((BigDecimal)mTab.getValue("Weight_PackingMaterial"));
        mTab.setValue("Weight", (Object)peso);
        return "";
    }

    public String weight_net_total(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        BigDecimal weightGross = (BigDecimal)mTab.getValue("Weight_gross");
        BigDecimal weightTare = (BigDecimal)mTab.getValue("Weight_tare");
        BigDecimal netweight = weightGross.subtract(weightTare);
        mTab.setValue("Weight_net", (Object)netweight);
        return "";
    }
}

