/*
 * Decompiled with CFR 0.152.
 */
package org.shw.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MPriceList;
import org.compiere.model.MTax;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class LCO_CalloutWithholding
extends CalloutEngine {
    public String fillIsUse(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
        this.log.info("");
        int wht_id = (Integer)mTab.getValue("LCO_WithholdingType_ID");
        String sql = "SELECT IsUseBPISIC, IsUseBPTaxPayerType, IsUseBPCity, IsUseOrgISIC, IsUseOrgTaxPayerType, IsUseOrgCity, IsUseWithholdingCategory, IsUseProductTaxCategory FROM LCO_WithholdingRuleConf WHERE LCO_WithholdingType_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, wht_id);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                mTab.setValue("IsUseBPISIC", (Object)rs.getString("IsUseBPISIC"));
                mTab.setValue("IsUseBPTaxPayerType", (Object)rs.getString("IsUseBPTaxPayerType"));
                mTab.setValue("IsUseBPCity", (Object)rs.getString("IsUseBPCity"));
                mTab.setValue("IsUseOrgISIC", (Object)rs.getString("IsUseOrgISIC"));
                mTab.setValue("IsUseOrgTaxPayerType", (Object)rs.getString("IsUseOrgTaxPayerType"));
                mTab.setValue("IsUseOrgCity", (Object)rs.getString("IsUseOrgCity"));
                mTab.setValue("IsUseWithholdingCategory", (Object)rs.getString("IsUseWithholdingCategory"));
                mTab.setValue("IsUseProductTaxCategory", (Object)rs.getString("IsUseProductTaxCategory"));
            } else {
                mTab.setValue("IsUseBPISIC", (Object)"N");
                mTab.setValue("IsUseBPTaxPayerType", (Object)"N");
                mTab.setValue("IsUseBPCity", (Object)"N");
                mTab.setValue("IsUseOrgISIC", (Object)"N");
                mTab.setValue("IsUseOrgTaxPayerType", (Object)"N");
                mTab.setValue("IsUseOrgCity", (Object)"N");
                mTab.setValue("IsUseWithholdingCategory", (Object)"N");
                mTab.setValue("IsUseProductTaxCategory", (Object)"N");
                this.log.warning("Rule not configured for withholding type");
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
            return e.getLocalizedMessage();
        }
        return "";
    }

    public String fillPercentFromTax(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
        this.log.info("");
        int taxint = 0;
        BigDecimal percent = null;
        if (value != null) {
            taxint = (Integer)value;
        }
        if (taxint != 0) {
            MTax tax = new MTax(ctx, taxint, null);
            percent = tax.getRate();
        }
        mTab.setValue("Percent", percent);
        return this.recalc_taxamt(ctx, WindowNo, mTab, mField, value, oldValue);
    }

    public String recalc_taxamt(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
        BigDecimal oldtaxbaseamt;
        BigDecimal newtaxbaseamt;
        this.log.info("");
        if (mField.getColumnName().equals("TaxBaseAmt") && value != null && oldValue != null && (newtaxbaseamt = (BigDecimal)value).compareTo(oldtaxbaseamt = (BigDecimal)oldValue) == 0) {
            return "";
        }
        BigDecimal percent = (BigDecimal)mTab.getValue("Percent");
        BigDecimal taxbaseamt = (BigDecimal)mTab.getValue("TaxBaseAmt");
        BigDecimal taxamt = null;
        if (percent != null && taxbaseamt != null) {
            int pricelist_id = DB.getSQLValue(null, "SELECT M_PriceList_ID FROM C_Invoice WHERE C_Invoice_ID=?", (Integer)mTab.getValue("C_Invoice_ID"));
            taxamt = percent.multiply(taxbaseamt).divide(Env.ONEHUNDRED);
            int stdPrecision = MPriceList.getStandardPrecision(ctx, pricelist_id);
            taxamt = taxamt.setScale(stdPrecision, 4);
        }
        mTab.setValue("TaxAmt", taxamt);
        return "";
    }

    public String fillWriteOff(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
        this.log.info("");
        if (this.isCalloutActive()) {
            return "";
        }
        Integer invInt = (Integer)value;
        int inv_id = 0;
        if (value != null) {
            inv_id = invInt;
        }
        String sql = "SELECT NVL(SUM(TaxAmt),0)   FROM LCO_InvoiceWithholding  WHERE C_Invoice_ID = ?    AND IsCalcOnPayment = 'Y'   AND Processed = 'N'   AND C_AllocationLine_ID IS NULL   AND IsActive = 'Y'";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, inv_id);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                mTab.setValue("WriteOffAmt", (Object)rs.getBigDecimal(1));
            } else {
                mTab.setValue("WriteOffAmt", (Object)Env.ZERO);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
            return e.getLocalizedMessage();
        }
        return "";
    }
}

