/*
 * Decompiled with CFR 0.152.
 */
package org.shw.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MConversionRate;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MLocation;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPriceList;
import org.compiere.model.MTax;
import org.compiere.model.Query;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.shw.model.MLCOInvoiceWithholding;
import org.shw.model.X_LCO_WithholdingCalc;
import org.shw.model.X_LCO_WithholdingRule;
import org.shw.model.X_LCO_WithholdingRuleConf;
import org.shw.model.X_LCO_WithholdingType;

public class LCO_MInvoice
extends MInvoice {
    private static final long serialVersionUID = -924606040343895114L;

    public LCO_MInvoice(Properties ctx, int C_Invoice_ID, String trxName) {
        super(ctx, C_Invoice_ID, trxName);
    }

    public int recalcWithholdings() {
        MDocType dt = new MDocType(this.getCtx(), this.getC_DocTypeTarget_ID(), this.get_TrxName());
        String genwh = dt.get_ValueAsString("GenerateWithholding");
        if (genwh == null || genwh.equals("N")) {
            return 0;
        }
        int noins = 0;
        this.log.info("");
        BigDecimal totwith = new BigDecimal("0");
        try {
            String sqldel = "DELETE FROM LCO_InvoiceWithholding  WHERE C_Invoice_ID = ?";
            CPreparedStatement pstmtdel = DB.prepareStatement(sqldel, this.get_TrxName());
            pstmtdel.setInt(1, this.getC_Invoice_ID());
            int nodel = pstmtdel.executeUpdate();
            this.log.config("LCO_InvoiceWithholding deleted=" + nodel);
            pstmtdel.close();
            MBPartner bp = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
            Integer bp_isic_int = (Integer)bp.get_Value("LCO_ISIC_ID");
            int bp_isic_id = 0;
            if (bp_isic_int != null) {
                bp_isic_id = bp_isic_int;
            }
            Integer bp_taxpayertype_int = (Integer)bp.get_Value("LCO_TaxPayerType_ID");
            int bp_taxpayertype_id = 0;
            if (bp_taxpayertype_int != null) {
                bp_taxpayertype_id = bp_taxpayertype_int;
            }
            MBPartnerLocation mbpl = new MBPartnerLocation(this.getCtx(), this.getC_BPartner_Location_ID(), this.get_TrxName());
            MLocation bpl = MLocation.get(this.getCtx(), mbpl.getC_Location_ID(), this.get_TrxName());
            int bp_city_id = bpl.getC_City_ID();
            MOrgInfo oi = MOrgInfo.get(this.getCtx(), this.getAD_Org_ID());
            Integer org_isic_int = (Integer)oi.get_Value("LCO_ISIC_ID");
            int org_isic_id = 0;
            if (org_isic_int != null) {
                org_isic_id = org_isic_int;
            }
            Integer org_taxpayertype_int = (Integer)oi.get_Value("LCO_TaxPayerType_ID");
            int org_taxpayertype_id = 0;
            if (org_taxpayertype_int != null) {
                org_taxpayertype_id = org_taxpayertype_int;
            }
            MLocation ol = MLocation.get(this.getCtx(), oi.getC_Location_ID(), this.get_TrxName());
            int org_city_id = ol.getC_City_ID();
            String sqlt = "SELECT LCO_WithholdingType_ID  FROM LCO_WithholdingType  WHERE IsSOTrx = ? AND IsActive = 'Y' and ad_client_ID=?";
            CPreparedStatement pstmtt = DB.prepareStatement(sqlt, this.get_TrxName());
            pstmtt.setString(1, this.isSOTrx() ? "Y" : "N");
            pstmtt.setInt(2, Env.getAD_Client_ID(this.getCtx()));
            ResultSet rst = pstmtt.executeQuery();
            while (rst.next()) {
                boolean addedlines;
                int wcid;
                int i;
                X_LCO_WithholdingType wt = new X_LCO_WithholdingType(this.getCtx(), rst.getInt(1), this.get_TrxName());
                X_LCO_WithholdingRuleConf wrc = null;
                this.log.info("Withholding Type: " + wt.getLCO_WithholdingType_ID() + "/" + wt.getName());
                String sqlrc = "SELECT *  FROM LCO_WithholdingRuleConf  WHERE LCO_WithholdingType_ID = ? AND IsActive = 'Y'";
                CPreparedStatement pstmtrc = DB.prepareStatement(sqlrc, this.get_TrxName());
                pstmtrc.setInt(1, wt.getLCO_WithholdingType_ID());
                ResultSet rsrc = pstmtrc.executeQuery();
                if (!rsrc.next()) {
                    this.log.warning("No LCO_WithholdingRuleConf for LCO_WithholdingType = " + wt.getLCO_WithholdingType_ID());
                    rsrc.close();
                    pstmtrc.close();
                    continue;
                }
                wrc = new X_LCO_WithholdingRuleConf(this.getCtx(), rsrc, this.get_TrxName());
                rsrc.close();
                pstmtrc.close();
                StringBuffer sqlr = new StringBuffer("SELECT LCO_WithholdingRule_ID   FROM LCO_WithholdingRule  WHERE LCO_WithholdingType_ID = ?    AND IsActive = 'Y'    AND ValidFrom <= ? ");
                if (wrc.isUseBPISIC()) {
                    sqlr.append(" AND LCO_BP_ISIC_ID = ? ");
                }
                if (wrc.isUseBPTaxPayerType()) {
                    sqlr.append(" AND LCO_BP_TaxPayerType_ID = ? ");
                }
                if (wrc.isUseOrgISIC()) {
                    sqlr.append(" AND LCO_Org_ISIC_ID = ? ");
                }
                if (wrc.isUseOrgTaxPayerType()) {
                    sqlr.append(" AND LCO_Org_TaxPayerType_ID = ? ");
                }
                if (wrc.isUseBPCity()) {
                    sqlr.append(" AND LCO_BP_City_ID = ? ");
                }
                if (wrc.isUseOrgCity()) {
                    sqlr.append(" AND LCO_Org_City_ID = ? ");
                }
                if (wrc.isUseWithholdingCategory()) {
                    String sqlwcs = "SELECT DISTINCT COALESCE (p.LCO_WithholdingCategory_ID, COALESCE (c.LCO_WithholdingCategory_ID, 0))   FROM C_InvoiceLine il   LEFT OUTER JOIN M_Product p ON (il.M_Product_ID = p.M_Product_ID)   LEFT OUTER JOIN C_Charge c ON (il.C_Charge_ID = c.C_Charge_ID)   WHERE C_Invoice_ID = ? AND il.IsActive='Y'";
                    CPreparedStatement pstmtwcs = DB.prepareStatement(sqlwcs, this.get_TrxName());
                    pstmtwcs.setInt(1, this.getC_Invoice_ID());
                    ResultSet rswcs = pstmtwcs.executeQuery();
                    i = 0;
                    wcid = 0;
                    addedlines = false;
                    while (rswcs.next()) {
                        wcid = rswcs.getInt(1);
                        if (wcid <= 0) continue;
                        if (i == 0) {
                            sqlr.append(" AND LCO_WithholdingCategory_ID IN (");
                            addedlines = true;
                        } else {
                            sqlr.append(",");
                        }
                        sqlr.append(wcid);
                        ++i;
                    }
                    if (addedlines) {
                        sqlr.append(") ");
                    }
                    rswcs.close();
                    pstmtwcs.close();
                }
                if (wrc.isUseProductTaxCategory()) {
                    String sqlwct = "SELECT DISTINCT COALESCE (p.C_TaxCategory_ID, COALESCE (c.C_TaxCategory_ID, 0))   FROM C_InvoiceLine il   LEFT OUTER JOIN M_Product p ON (il.M_Product_ID = p.M_Product_ID)   LEFT OUTER JOIN C_Charge c ON (il.C_Charge_ID = c.C_Charge_ID)   WHERE C_Invoice_ID = ? AND il.IsActive='Y'";
                    CPreparedStatement pstmtwct = DB.prepareStatement(sqlwct, this.get_TrxName());
                    pstmtwct.setInt(1, this.getC_Invoice_ID());
                    ResultSet rswct = pstmtwct.executeQuery();
                    i = 0;
                    wcid = 0;
                    addedlines = false;
                    while (rswct.next()) {
                        wcid = rswct.getInt(1);
                        if (wcid <= 0) continue;
                        if (i == 0) {
                            sqlr.append(" AND C_TaxCategory_ID IN (");
                            addedlines = true;
                        } else {
                            sqlr.append(",");
                        }
                        sqlr.append(wcid);
                        ++i;
                    }
                    if (addedlines) {
                        sqlr.append(") ");
                    }
                    rswct.close();
                    pstmtwct.close();
                }
                CPreparedStatement pstmtr = DB.prepareStatement(sqlr.toString(), this.get_TrxName());
                int idxpar = 1;
                pstmtr.setInt(idxpar, wt.getLCO_WithholdingType_ID());
                pstmtr.setTimestamp(++idxpar, this.getDateInvoiced());
                if (wrc.isUseBPISIC()) {
                    pstmtr.setInt(++idxpar, bp_isic_id);
                }
                if (wrc.isUseBPTaxPayerType()) {
                    pstmtr.setInt(++idxpar, bp_taxpayertype_id);
                }
                if (wrc.isUseOrgISIC()) {
                    pstmtr.setInt(++idxpar, org_isic_id);
                }
                if (wrc.isUseOrgTaxPayerType()) {
                    pstmtr.setInt(++idxpar, org_taxpayertype_id);
                }
                if (wrc.isUseBPCity()) {
                    pstmtr.setInt(++idxpar, bp_city_id);
                    if (bp_city_id <= 0) {
                        this.log.warning("Possible configuration error bp city is used but not set");
                    }
                }
                if (wrc.isUseOrgCity()) {
                    pstmtr.setInt(++idxpar, org_city_id);
                    if (org_city_id <= 0) {
                        this.log.warning("Possible configuration error org city is used but not set");
                    }
                }
                ResultSet rsr = pstmtr.executeQuery();
                while (rsr.next()) {
                    X_LCO_WithholdingRule wr = new X_LCO_WithholdingRule(this.getCtx(), rsr.getInt(1), this.get_TrxName());
                    X_LCO_WithholdingCalc wc = new X_LCO_WithholdingCalc(this.getCtx(), wr.getLCO_WithholdingCalc_ID(), this.get_TrxName());
                    if (wc.getLCO_WithholdingCalc_ID() == 0) {
                        this.log.severe("Rule without calc " + rsr.getInt(1));
                        continue;
                    }
                    MTax tax = new MTax(this.getCtx(), wc.getC_Tax_ID(), this.get_TrxName());
                    this.log.info("WithholdingRule: " + wr.getLCO_WithholdingRule_ID() + "/" + wr.getName() + " BaseType:" + wc.getBaseType() + " Calc: " + wc.getLCO_WithholdingCalc_ID() + "/" + wc.getName() + " CalcOnInvoice:" + wc.isCalcOnInvoice() + " Tax: " + tax.getC_Tax_ID() + "/" + tax.getName());
                    BigDecimal base = null;
                    BigDecimal basenet = null;
                    if (wc.getBaseType() == null) {
                        this.log.severe("Base Type null in calc record " + wr.getLCO_WithholdingCalc_ID());
                    } else if (wc.getBaseType().equals("D")) {
                        base = this.getTotalLines();
                        basenet = new Query(this.getCtx(), "C_InvoiceLine", " c_invoice_id=?", this.get_TrxName()).setParameters(this.getC_Invoice_ID()).aggregate("LineNetAmt", "SUM");
                    } else if (wc.getBaseType().equals("L")) {
                        String sqllca = wrc.isUseWithholdingCategory() && wrc.isUseProductTaxCategory() ? "SELECT SUM (LineNetAmt), sum(il.priceList*il.qtyinvoiced)   FROM C_InvoiceLine il  WHERE IsActive='Y' AND C_Invoice_ID = ?    AND (   EXISTS (               SELECT 1                 FROM M_Product p                WHERE il.M_Product_ID = p.M_Product_ID                  AND p.C_TaxCategory_ID = ?                  AND p.LCO_WithholdingCategory_ID = ?)         OR EXISTS (               SELECT 1                 FROM C_Charge c                WHERE il.C_Charge_ID = c.C_Charge_ID                  AND c.C_TaxCategory_ID = ?                  AND c.LCO_WithholdingCategory_ID = ?)        ) " : (wrc.isUseWithholdingCategory() ? "SELECT SUM (LineNetAmt) , sum(il.priceList*il.qtyinvoiced)  FROM C_InvoiceLine il  WHERE IsActive='Y' AND C_Invoice_ID = ?    AND (   EXISTS (               SELECT 1                 FROM M_Product p                WHERE il.M_Product_ID = p.M_Product_ID                  AND p.LCO_WithholdingCategory_ID = ?)         OR EXISTS (               SELECT 1                 FROM C_Charge c                WHERE il.C_Charge_ID = c.C_Charge_ID                  AND c.LCO_WithholdingCategory_ID = ?)        ) " : (wrc.isUseProductTaxCategory() ? "SELECT SUM (LineNetAmt), sum(il.priceList*il.qtyinvoiced)   FROM C_InvoiceLine il  WHERE IsActive='Y' AND C_Invoice_ID = ?    AND (   EXISTS (               SELECT 1                 FROM M_Product p                WHERE il.M_Product_ID = p.M_Product_ID                  AND p.C_TaxCategory_ID = ?)         OR EXISTS (               SELECT 1                 FROM C_Charge c                WHERE il.C_Charge_ID = c.C_Charge_ID                  AND c.C_TaxCategory_ID = ?)        ) " : "SELECT SUM (LineNetAmt), sum(il.priceList*il.qtyinvoiced)   FROM C_InvoiceLine il  WHERE IsActive='Y' AND C_Invoice_ID = ? "));
                        CPreparedStatement pstmtlca = DB.prepareStatement(sqllca, this.get_TrxName());
                        pstmtlca.setInt(1, this.getC_Invoice_ID());
                        if (wrc.isUseWithholdingCategory() && wrc.isUseProductTaxCategory()) {
                            pstmtlca.setInt(2, wr.getC_TaxCategory_ID());
                            pstmtlca.setInt(3, wr.getLCO_WithholdingCategory_ID());
                            pstmtlca.setInt(4, wr.getC_TaxCategory_ID());
                            pstmtlca.setInt(5, wr.getLCO_WithholdingCategory_ID());
                        } else if (wrc.isUseWithholdingCategory()) {
                            pstmtlca.setInt(2, wr.getLCO_WithholdingCategory_ID());
                            pstmtlca.setInt(3, wr.getLCO_WithholdingCategory_ID());
                        } else if (wrc.isUseProductTaxCategory()) {
                            pstmtlca.setInt(2, wr.getC_TaxCategory_ID());
                            pstmtlca.setInt(3, wr.getC_TaxCategory_ID());
                        }
                        ResultSet rslca = pstmtlca.executeQuery();
                        if (rslca.next()) {
                            base = rslca.getBigDecimal(1);
                            basenet = rslca.getBigDecimal(2);
                        }
                        rslca.close();
                        pstmtlca.close();
                    } else if (wc.getBaseType().equals("T")) {
                        if (wc.getC_BaseTax_ID() != 0) {
                            String sqlbst = "SELECT SUM(taxbaseamt)  FROM C_InvoiceTax  WHERE IsActive='Y' AND C_Invoice_ID = ?    AND C_Tax_ID = ?";
                            CPreparedStatement pstmtbst = DB.prepareStatement(sqlbst, this.get_TrxName());
                            pstmtbst.setInt(1, this.getC_Invoice_ID());
                            pstmtbst.setInt(2, wc.getC_BaseTax_ID());
                            ResultSet rsbst = pstmtbst.executeQuery();
                            if (rsbst.next()) {
                                base = rsbst.getBigDecimal(1);
                            }
                            rsbst.close();
                            pstmtbst.close();
                        } else {
                            String sqlbsat = "SELECT SUM(TaxAmt)  FROM C_InvoiceTax  WHERE IsActive='Y' AND C_Invoice_ID = ? ";
                            CPreparedStatement pstmtbsat = DB.prepareStatement(sqlbsat, this.get_TrxName());
                            pstmtbsat.setInt(1, this.getC_Invoice_ID());
                            ResultSet rsbsat = pstmtbsat.executeQuery();
                            if (rsbsat.next()) {
                                base = rsbsat.getBigDecimal(1);
                            }
                            rsbsat.close();
                            pstmtbsat.close();
                        }
                    }
                    this.log.info("Base: " + base + " Thresholdmin:" + wc.getThresholdmin());
                    BigDecimal threshholdMin = BigDecimal.ZERO;
                    BigDecimal threshholdMax = BigDecimal.ZERO;
                    String whereClause = "AD_Client_ID=?";
                    MAcctSchema as = (MAcctSchema)new Query(this.getCtx(), "C_AcctSchema", "AD_Client_ID=?", this.get_TrxName()).setParameters(this.getAD_Client_ID()).first();
                    if (this.getC_Currency_ID() == as.getC_Currency_ID()) {
                        threshholdMin = wc.getThresholdmin();
                        threshholdMax = wc.getThresholdMax();
                    } else {
                        threshholdMin = MConversionRate.convert(this.getCtx(), wc.getThresholdmin(), as.getC_Currency_ID(), this.getC_Currency_ID(), this.getDateAcct(), this.getC_ConversionType_ID(), this.getAD_Client_ID(), 0);
                        threshholdMax = MConversionRate.convert(this.getCtx(), wc.getThresholdMax(), as.getC_Currency_ID(), this.getC_Currency_ID(), this.getDateAcct(), this.getC_ConversionType_ID(), this.getAD_Client_ID(), 0);
                    }
                    if (base == null || base.compareTo(Env.ZERO) == 0 || base.compareTo(threshholdMin) < 0 || threshholdMax != null && threshholdMax.compareTo(Env.ZERO) != 0 && base.compareTo(threshholdMax) > 0 || tax.getRate() == null || tax.getRate().compareTo(Env.ZERO) == 0) continue;
                    MLCOInvoiceWithholding iwh = new MLCOInvoiceWithholding(this.getCtx(), 0, this.get_TrxName());
                    iwh.setAD_Org_ID(this.getAD_Org_ID());
                    iwh.setC_Invoice_ID(this.getC_Invoice_ID());
                    iwh.setDateAcct(this.getDateAcct());
                    iwh.setDateTrx(this.getDateInvoiced());
                    iwh.setIsCalcOnPayment(!wc.isCalcOnInvoice());
                    iwh.setIsTaxIncluded(false);
                    iwh.setLCO_WithholdingRule_ID(wr.getLCO_WithholdingRule_ID());
                    iwh.setLCO_WithholdingType_ID(wt.getLCO_WithholdingType_ID());
                    iwh.setC_Tax_ID(tax.getC_Tax_ID());
                    iwh.setPercent(tax.getRate());
                    iwh.setProcessed(false);
                    int stdPrecision = MPriceList.getStandardPrecision(this.getCtx(), this.getM_PriceList_ID());
                    BigDecimal taxamt = tax.calculateTax(base, false, stdPrecision);
                    if (wc.getAmountRefunded() != null && wc.getAmountRefunded().compareTo(Env.ZERO) > 0) {
                        taxamt = taxamt.subtract(wc.getAmountRefunded());
                    }
                    iwh.setTaxAmt(taxamt);
                    iwh.setTaxBaseAmt(base);
                    BigDecimal taxnetamt = Env.ZERO;
                    if (basenet != null && basenet.compareTo(Env.ZERO) != 0) {
                        taxnetamt = tax.calculateTax(basenet, false, stdPrecision);
                        iwh.set_ValueOfColumn("NetAmtToInvoice", (Object)basenet);
                        iwh.set_ValueOfColumn("taxnetamt", (Object)taxnetamt);
                    }
                    iwh.save();
                    totwith = totwith.add(taxamt);
                    ++noins;
                    this.log.info("LCO_InvoiceWithholding saved:" + iwh.getTaxAmt());
                }
            }
            LCO_MInvoice.updateHeaderWithholding(this.getC_Invoice_ID(), this.get_TrxName());
            this.save();
            rst.close();
            pstmtt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "", e);
            return -1;
        }
        return noins;
    }

    public static boolean updateHeaderWithholding(int C_Invoice_ID, String trxName) {
        String sql = "UPDATE C_Invoice  SET WithholdingAmt=(SELECT COALESCE(SUM(TaxAmt),0) FROM LCO_InvoiceWithholding iw WHERE iw.IsActive = 'Y' AND iw.IsCalcOnPayment = 'N' AND C_Invoice.C_Invoice_ID=iw.C_Invoice_ID) WHERE C_Invoice_ID=?";
        int no = DB.executeUpdate(sql, C_Invoice_ID, trxName);
        return no == 1;
    }

    public static boolean setWithholdingAmtWithoutLogging(MInvoice inv, BigDecimal wamt) {
        DB.executeUpdate("UPDATE C_Invoice SET WithholdingAmt=? WHERE C_Invoice_ID=?", new Object[]{wamt, inv.getC_Invoice_ID()}, true, inv.get_TrxName());
        return true;
    }
}

