/*
 * Decompiled with CFR 0.152.
 */
package org.shw.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.DocTax;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentAllocate;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.shw.model.LCO_MInvoice;
import org.shw.model.MLCOInvoiceWithholding;
import org.shw.model.X_LCO_WithholdingCalc;

public class LCO_Validator
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(LCO_Validator.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_Invoice", this);
        engine.addModelChange("C_InvoiceLine", this);
        engine.addModelChange("C_BPartner", this);
        engine.addModelChange("LCO_WithholdingCalc", this);
        engine.addDocValidate("C_Invoice", this);
        engine.addDocValidate("C_Payment", this);
        engine.addDocValidate("C_AllocationHdr", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        X_LCO_WithholdingCalc lwc;
        String msg;
        log.info(po.get_TableName() + " Type: " + type);
        if (po.get_TableName().equals("C_Invoice") && type == 2 && (msg = this.clearInvoiceWithholdingAmtFromInvoice((MInvoice)po)) != null) {
            return msg;
        }
        if (po.get_TableName().equals("C_InvoiceLine") && (type == 1 || type == 2 || type == 3) && (msg = this.clearInvoiceWithholdingAmtFromInvoiceLine((MInvoiceLine)po, type)) != null) {
            return msg;
        }
        if (po.get_TableName().equals("C_BPartner") && (type == 1 || type == 2)) {
            MBPartner bpartner = (MBPartner)po;
            msg = this.mcheckTaxIdDigit(bpartner);
            if (msg != null) {
                return msg;
            }
            msg = this.mfillName(bpartner);
            if (msg != null) {
                return msg;
            }
        }
        if (po.get_TableName().equals("LCO_WithholdingCalc") && (type == 2 || type == 1) && (lwc = (X_LCO_WithholdingCalc)po).isCalcOnInvoice() && lwc.isCalcOnPayment()) {
            lwc.setIsCalcOnPayment(false);
        }
        return null;
    }

    private String clearInvoiceWithholdingAmtFromInvoice(MInvoice inv) {
        if (inv.is_ValueChanged("AD_Org_ID") || inv.is_ValueChanged("C_BPartner_ID") || inv.is_ValueChanged("C_DocTypeTarget_ID")) {
            boolean thereAreCalc;
            try {
                thereAreCalc = this.thereAreCalc(inv);
            }
            catch (SQLException e) {
                log.log(Level.SEVERE, "Error looking for calc on invoice rules", e);
                return "Error looking for calc on invoice rules";
            }
            BigDecimal curWithholdingAmt = (BigDecimal)inv.get_Value("WithholdingAmt");
            if (thereAreCalc) {
                if (curWithholdingAmt != null) {
                    inv.set_CustomColumn("WithholdingAmt", null);
                }
            } else if (curWithholdingAmt == null) {
                inv.set_CustomColumn("WithholdingAmt", Env.ZERO);
            }
        }
        return null;
    }

    private String clearInvoiceWithholdingAmtFromInvoiceLine(MInvoiceLine invline, int type) {
        if (type == 1 || type == 3 || type == 2 && (invline.is_ValueChanged("LineNetAmt") || invline.is_ValueChanged("M_Product_ID") || invline.is_ValueChanged("C_Charge_ID") || invline.is_ValueChanged("IsActive") || invline.is_ValueChanged("C_Tax_ID"))) {
            boolean thereAreCalc;
            MInvoice inv = invline.getParent();
            try {
                thereAreCalc = this.thereAreCalc(inv);
            }
            catch (SQLException e) {
                log.log(Level.SEVERE, "Error looking for calc on invoice rules", e);
                return "Error looking for calc on invoice rules";
            }
            BigDecimal curWithholdingAmt = (BigDecimal)inv.get_Value("WithholdingAmt");
            if (thereAreCalc ? curWithholdingAmt != null && !LCO_MInvoice.setWithholdingAmtWithoutLogging(inv, null) : curWithholdingAmt == null && !LCO_MInvoice.setWithholdingAmtWithoutLogging(inv, Env.ZERO)) {
                return "Error saving C_Invoice clearInvoiceWithholdingAmtFromInvoiceLine";
            }
        }
        return null;
    }

    private boolean thereAreCalc(MInvoice inv) throws SQLException {
        boolean thereAreCalc = false;
        String sqlwccoi = "SELECT 1   FROM LCO_WithholdingType wt, LCO_WithholdingCalc wc  WHERE wt.LCO_WithholdingType_ID = wc.LCO_WithholdingType_ID";
        CPreparedStatement pstmtwccoi = DB.prepareStatement(sqlwccoi, inv.get_TrxName());
        ResultSet rswccoi = null;
        try {
            rswccoi = pstmtwccoi.executeQuery();
            if (rswccoi.next()) {
                thereAreCalc = true;
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            DB.close(rswccoi, pstmtwccoi);
            rswccoi = null;
            pstmtwccoi = null;
        }
        return thereAreCalc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String docValidate(PO po, int timing) {
        String msg;
        String string;
        ResultSet rs;
        CPreparedStatement pstmt;
        MInvoice inv;
        log.info(po.get_TableName() + " Timing: " + timing);
        if (po.get_TableName().equals("C_Invoice") && timing == 1 && (inv = (MInvoice)po).isReversal()) {
            int invid = inv.getReversal_ID();
            if (invid <= 0) {
                return "Can't get the number of the invoice reversed";
            }
            MInvoice invreverted = new MInvoice(inv.getCtx(), invid, inv.get_TrxName());
            String sql = "SELECT LCO_InvoiceWithholding_ID  FROM LCO_InvoiceWithholding  WHERE C_Invoice_ID = ?  ORDER BY LCO_InvoiceWithholding_ID";
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql, inv.get_TrxName());
                pstmt.setInt(1, invreverted.getC_Invoice_ID());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    MLCOInvoiceWithholding iwh = new MLCOInvoiceWithholding(inv.getCtx(), rs.getInt(1), inv.get_TrxName());
                    MLCOInvoiceWithholding newiwh = new MLCOInvoiceWithholding(inv.getCtx(), 0, inv.get_TrxName());
                    newiwh.setC_Invoice_ID(inv.getC_Invoice_ID());
                    newiwh.setAD_Org_ID(newiwh.getC_Invoice().getAD_Org_ID());
                    newiwh.setLCO_WithholdingType_ID(iwh.getLCO_WithholdingType_ID());
                    newiwh.setPercent(iwh.getPercent());
                    newiwh.setTaxAmt(iwh.getTaxAmt().negate());
                    newiwh.setTaxBaseAmt(iwh.getTaxBaseAmt().negate());
                    newiwh.setC_Tax_ID(iwh.getC_Tax_ID());
                    newiwh.setIsCalcOnPayment(iwh.isCalcOnPayment());
                    newiwh.setLCO_WithholdingRule_ID(iwh.getLCO_WithholdingRule_ID());
                    if (newiwh.save()) continue;
                    string = "Error saving LCO_InvoiceWithholding docValidate";
                }
            }
            catch (Exception e) {
                String string2;
                try {
                    log.log(Level.SEVERE, sql, e);
                    string2 = "Error creating LCO_InvoiceWithholding for reversal invoice";
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                return string2;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (!(!po.get_TableName().equals("C_Invoice") || timing != 1 || (inv = (MInvoice)po).getDescription() != null && inv.getDescription().contains("{->") && inv.getDescription().endsWith(")"))) {
            MDocType dt;
            String genwh;
            BigDecimal WithholdingAmt = (BigDecimal)inv.get_Value("WithholdingAmt");
            if ((inv.get_Value("WithholdingAmt") == null || WithholdingAmt.compareTo(Env.ZERO) == 0) && (genwh = (dt = new MDocType(inv.getCtx(), inv.getC_DocTypeTarget_ID(), inv.get_TrxName())).get_ValueAsString("GenerateWithholding")) != null) {
                if (genwh.equals("Y")) {
                    return Msg.getMsg(inv.getCtx(), "LCO_WithholdingNotGenerated");
                }
                if (genwh.equals("A")) {
                    LCO_MInvoice lcoinv = new LCO_MInvoice(inv.getCtx(), inv.getC_Invoice_ID(), inv.get_TrxName());
                    lcoinv.recalcWithholdings();
                }
            }
        }
        if (po.get_TableName().equals("C_Invoice") && timing == 8 && (msg = this.translateWithholdingToTaxes((MInvoice)po)) != null) {
            return msg;
        }
        if (po.get_TableName().equals("C_Invoice") && timing == 9 && (msg = this.completeInvoiceWithholding((MInvoice)po)) != null) {
            return msg;
        }
        if (po.get_TableName().equals("C_Payment") && timing == 7 && (msg = this.validateWriteOffVsPaymentWithholdings((MPayment)po)) != null) {
            return msg;
        }
        if (po.get_TableName().equals("C_AllocationHdr") && timing == 9 && (msg = this.completePaymentWithholdings((MAllocationHdr)po)) != null) {
            return msg;
        }
        if (po.get_TableName().equals("C_AllocationHdr") && timing == 15 && (msg = this.accountingForInvoiceWithholdingOnPayment((MAllocationHdr)po)) != null) {
            return msg;
        }
        if (po.get_TableName().equals("C_AllocationHdr") && (timing == 10 || timing == 13 || timing == 14) && (msg = this.reversePaymentWithholdings((MAllocationHdr)po)) != null) {
            return msg;
        }
        return null;
        DB.close(rs, pstmt);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String validateWriteOffVsPaymentWithholdings(MPayment pay) {
        if (pay.getC_Invoice_ID() > 0) {
            wo = pay.getWriteOffAmt();
            sumwhamt = Env.ZERO;
            whereClause = "C_Invoice_ID = ? AND IsActive = 'Y' AND IsCalcOnPayment = 'Y' AND Processed = 'N' AND C_AllocationLine_ID IS NULL";
            currency = (MCurrency)pay.getC_Currency();
            iwhs = new Query(pay.getCtx(), "LCO_InvoiceWithholding", whereClause, pay.get_TrxName()).setParameters(new Object[]{pay.getC_Invoice_ID()}).setOnlyActiveRecords(true).list();
            for (MLCOInvoiceWithholding iwh : iwhs) {
                CurrencyRate = Env.ONE;
                if (iwh.getC_Invoice().getC_Currency_ID() != pay.getC_Currency_ID()) {
                    CurrencyRate = MConversionRate.getRate(iwh.getC_Invoice().getC_Currency_ID(), pay.getC_Currency_ID(), pay.getDateAcct(), pay.getC_ConversionType_ID(), pay.getAD_Client_ID(), 0);
                }
                sumwhamt = sumwhamt.add(CurrencyRate.multiply(iwh.getTaxAmt()).setScale(currency.getStdPrecision(), 4));
            }
            if (sumwhamt == null) {
                sumwhamt = Env.ZERO;
            }
            if (wo.compareTo(sumwhamt) >= 0 || sumwhamt.compareTo(Env.ZERO) == 0) return null;
            return Msg.getMsg(pay.getCtx(), "LCO_WriteOffLowerThanWithholdings");
        }
        sql = "SELECT C_PaymentAllocate_ID FROM C_PaymentAllocate WHERE C_Payment_ID = ?";
        pstmt = DB.prepareStatement(sql, pay.get_TrxName());
        rs = null;
        try {
            pstmt.setInt(1, pay.getC_Payment_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                palid = rs.getInt(1);
                pal = new MPaymentAllocate(pay.getCtx(), palid, pay.get_TrxName());
                wo = pal.getWriteOffAmt();
                sumwhamt = Env.ZERO;
                whereClause = "C_Invoice_ID = ? AND IsActive = 'Y' AND IsCalcOnPayment = 'Y' AND Processed = 'N' AND C_AllocationLine_ID IS NULL";
                iwhs = new Query(pay.getCtx(), "LCO_InvoiceWithholding", whereClause, pay.get_TrxName()).setParameters(new Object[]{pay.getC_Invoice_ID()}).setOnlyActiveRecords(true).list();
                for (MLCOInvoiceWithholding iwh : iwhs) {
                    CurrencyRate = Env.ONE;
                    if (iwh.getC_Invoice().getC_Currency_ID() != pay.getC_Currency_ID()) {
                        CurrencyRate = MConversionRate.getRate(iwh.getC_Invoice().getC_Currency_ID(), pay.getC_Currency_ID(), pay.getDateAcct(), pay.getC_ConversionType_ID(), pay.getAD_Client_ID(), 0);
                    }
                    sumwhamt = sumwhamt.add(CurrencyRate.multiply(iwh.getTaxAmt()));
                }
                if (sumwhamt == null) {
                    sumwhamt = Env.ZERO;
                }
                if (wo.compareTo(sumwhamt) >= 0 || sumwhamt.compareTo(Env.ZERO) == 0) continue;
                var11_20 = Msg.getMsg(pay.getCtx(), "LCO_WriteOffLowerThanWithholdings");
                ** GOTO lbl52
            }
            ** GOTO lbl54
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                var6_12 = e.getLocalizedMessage();
            }
            catch (Throwable var14_23) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw var14_23;
            }
lbl52:
            // 1 sources

            DB.close(rs, pstmt);
            return var11_20;
lbl54:
            // 1 sources

            DB.close(rs, pstmt);
            return null;
            DB.close(rs, pstmt);
            return var6_12;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String completePaymentWithholdings(MAllocationHdr ah) {
        String string;
        ResultSet rs;
        CPreparedStatement pstmt;
        MAllocationLine[] als = ah.getLines(true);
        int i = 0;
        block5: while (true) {
            if (i >= als.length) {
                return null;
            }
            MAllocationLine al = als[i];
            if (al.getC_Payment_ID() > 0 && al.getC_Invoice_ID() > 0) {
                String sql = "SELECT LCO_InvoiceWithholding_ID FROM LCO_InvoiceWithholding WHERE C_Invoice_ID = ? AND IsActive = 'Y' AND IsCalcOnPayment = 'Y' AND Processed = 'N' AND C_AllocationLine_ID IS NULL";
                pstmt = DB.prepareStatement(sql, ah.get_TrxName());
                rs = null;
                try {
                    pstmt.setInt(1, al.getC_Invoice_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int iwhid = rs.getInt(1);
                        MLCOInvoiceWithholding iwh = new MLCOInvoiceWithholding(ah.getCtx(), iwhid, ah.get_TrxName());
                        iwh.setC_AllocationLine_ID(al.getC_AllocationLine_ID());
                        iwh.setDateAcct(ah.getDateAcct());
                        iwh.setDateTrx(ah.getDateTrx());
                        iwh.setProcessed(true);
                        if (iwh.save()) continue;
                        string = "Error saving LCO_InvoiceWithholding completePaymentWithholdings";
                        break block5;
                    }
                }
                catch (SQLException e) {
                    String string2;
                    try {
                        e.printStackTrace();
                        string2 = e.getLocalizedMessage();
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        throw throwable;
                    }
                    DB.close(rs, pstmt);
                    return string2;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
            ++i;
        }
        DB.close(rs, pstmt);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String reversePaymentWithholdings(MAllocationHdr ah) {
        MAllocationLine[] als = ah.getLines(true);
        for (int i = 0; i < als.length; ++i) {
            MAllocationLine al = als[i];
            if (al.getC_Invoice_ID() <= 0) continue;
            String sql = "SELECT LCO_InvoiceWithholding_ID FROM LCO_InvoiceWithholding WHERE C_Invoice_ID = ? AND IsActive = 'Y' AND IsCalcOnPayment = 'Y' AND Processed = 'Y' AND C_AllocationLine_ID = ?";
            CPreparedStatement pstmt = DB.prepareStatement(sql, ah.get_TrxName());
            ResultSet rs = null;
            try {
                pstmt.setInt(1, al.getC_Invoice_ID());
                pstmt.setInt(2, al.getC_AllocationLine_ID());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int iwhid = rs.getInt(1);
                    MLCOInvoiceWithholding iwh = new MLCOInvoiceWithholding(ah.getCtx(), iwhid, ah.get_TrxName());
                    iwh.setC_AllocationLine_ID(0);
                    iwh.setProcessed(false);
                    if (iwh.save()) continue;
                    String string = "Error saving LCO_InvoiceWithholding reversePaymentWithholdings";
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    return string;
                }
                DB.close(rs, pstmt);
            }
            catch (SQLException e) {
                e.printStackTrace();
                String string = e.getLocalizedMessage();
                return string;
            }
            finally {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
            rs = null;
            pstmt = null;
            continue;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String accountingForInvoiceWithholdingOnPayment(MAllocationHdr ah) {
        Doc doc = ah.getDoc();
        ArrayList<Fact> facts = doc.getFacts();
        for (int i = 0; i < facts.size(); ++i) {
            Fact fact = facts.get(i);
            MAcctSchema as = fact.getAcctSchema();
            MAllocationLine[] alloc_lines = ah.getLines(false);
            for (int j = 0; j < alloc_lines.length; ++j) {
                FactLine fl;
                BigDecimal tottax = new BigDecimal(0);
                MAllocationLine alloc_line = alloc_lines[j];
                doc.setC_BPartner_ID(alloc_line.getC_BPartner_ID());
                int inv_id = alloc_line.getC_Invoice_ID();
                if (inv_id <= 0) continue;
                MInvoice invoice = null;
                invoice = new MInvoice(ah.getCtx(), alloc_line.getC_Invoice_ID(), ah.get_TrxName());
                if (invoice == null || invoice.getC_Invoice_ID() == 0) continue;
                String sql = "SELECT i.C_Tax_ID, NVL(SUM(i.TaxBaseAmt),0) AS TaxBaseAmt, NVL(SUM(i.TaxAmt),0) AS TaxAmt, t.Name, t.Rate, t.IsSalesTax  FROM LCO_InvoiceWithholding i, C_Tax t  WHERE i.C_Invoice_ID = ? AND i.IsCalcOnPayment = 'Y' AND i.IsActive = 'Y' AND i.Processed = 'Y' AND i.C_AllocationLine_ID = ? AND i.C_Tax_ID = t.C_Tax_ID GROUP BY i.C_Tax_ID, t.Name, t.Rate, t.IsSalesTax";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    pstmt = DB.prepareStatement(sql, ah.get_TrxName());
                    pstmt.setInt(1, invoice.getC_Invoice_ID());
                    pstmt.setInt(2, alloc_line.getC_AllocationLine_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int tax_ID = rs.getInt(1);
                        BigDecimal taxBaseAmt = rs.getBigDecimal(2);
                        BigDecimal amount = rs.getBigDecimal(3);
                        String name = rs.getString(4);
                        BigDecimal rate = rs.getBigDecimal(5);
                        boolean salesTax = rs.getString(6).equals("Y");
                        BigDecimal CurrencyRate = Env.ONE;
                        if (alloc_line.getC_Invoice().getC_Currency_ID() != as.getC_Currency_ID()) {
                            CurrencyRate = MConversionRate.getRate(alloc_line.getC_Invoice().getC_Currency_ID(), as.getC_Currency_ID(), alloc_line.getC_Payment().getDateAcct(), alloc_line.getC_Payment().getC_ConversionType_ID(), alloc_line.getC_Payment().getAD_Client_ID(), 0);
                        }
                        amount = amount.multiply(CurrencyRate);
                        DocTax taxLine = new DocTax(tax_ID, name, rate, taxBaseAmt, amount, salesTax);
                        if (amount == null || amount.signum() == 0) continue;
                        FactLine tl = null;
                        tl = invoice.isSOTrx() ? fact.createLine(null, taxLine.getAccount(0, as), as.getC_Currency_ID(), amount, null) : fact.createLine(null, taxLine.getAccount(taxLine.getAPTaxType(), as), as.getC_Currency_ID(), null, amount);
                        if (tl != null) {
                            tl.setC_Tax_ID(taxLine.getC_Tax_ID());
                        }
                        tottax = tottax.add(amount);
                    }
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, sql, e);
                    String taxBaseAmt = "Error posting C_InvoiceTax from LCO_InvoiceWithholding";
                    return taxBaseAmt;
                }
                finally {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                }
                if (Env.ZERO.compareTo(tottax) == 0) continue;
                FactLine[] factlines = fact.getLines();
                boolean foundflwriteoff = false;
                for (int ifl = 0; ifl < factlines.length; ++ifl) {
                    fl = factlines[ifl];
                    if (fl.getLine_ID() != alloc_line.getC_AllocationLine_ID() || !fl.getAccount().equals(doc.getAccount(32, as))) continue;
                    foundflwriteoff = true;
                    BigDecimal balamt = fl.getAmtAcctDr().subtract(fl.getAmtAcctCr());
                    BigDecimal newbalamt = Env.ZERO;
                    newbalamt = invoice.isSOTrx() ? balamt.subtract(tottax) : balamt.add(tottax);
                    if (Env.ZERO.compareTo(newbalamt) == 0) {
                        fact.remove(fl);
                        break;
                    }
                    if (Env.ZERO.compareTo(newbalamt) > 0) {
                        fl.setAmtAcct(fl.getC_Currency_ID(), Env.ZERO, newbalamt);
                        fl.setAmtSource(fl.getC_Currency_ID(), Env.ZERO, newbalamt);
                        break;
                    }
                    fl.setAmtAcct(fl.getC_Currency_ID(), newbalamt, Env.ZERO);
                    fl.setAmtSource(fl.getC_Currency_ID(), newbalamt, Env.ZERO);
                    break;
                }
                if (foundflwriteoff) continue;
                DocLine line = new DocLine(alloc_line, doc);
                fl = null;
                fl = invoice.isSOTrx() ? fact.createLine(line, doc.getAccount(32, as), as.getC_Currency_ID(), null, tottax) : fact.createLine(line, doc.getAccount(32, as), as.getC_Currency_ID(), tottax, null);
                if (fl == null) continue;
                fl.setAD_Org_ID(ah.getAD_Org_ID());
            }
        }
        return null;
    }

    private String completeInvoiceWithholding(MInvoice inv) {
        String upd_dates = "UPDATE LCO_InvoiceWithholding    SET DateAcct =           (SELECT DateAcct              FROM C_Invoice             WHERE C_Invoice.C_Invoice_ID = LCO_InvoiceWithholding.C_Invoice_ID),        DateTrx =           (SELECT DateInvoiced              FROM C_Invoice             WHERE C_Invoice.C_Invoice_ID = LCO_InvoiceWithholding.C_Invoice_ID)  WHERE C_Invoice_ID = ? ";
        int noupddates = DB.executeUpdate(upd_dates, inv.getC_Invoice_ID(), inv.get_TrxName());
        if (noupddates == -1) {
            return "Error updating dates on invoice withholding";
        }
        String upd_proc = "UPDATE LCO_InvoiceWithholding    SET Processed = 'Y'  WHERE C_Invoice_ID = ? AND IsCalcOnPayment = 'N'";
        int noupdproc = DB.executeUpdate(upd_proc, inv.getC_Invoice_ID(), inv.get_TrxName());
        if (noupdproc == -1) {
            return "Error updating processed on invoice withholding";
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private String translateWithholdingToTaxes(MInvoice inv) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 10[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("LCO_Validator");
        return sb.toString();
    }

    private String mcheckTaxIdDigit(MBPartner bpartner) {
        return null;
    }

    public String mfillName(MBPartner bpartner) {
        log.info("");
        boolean isDetailedNames = false;
        Boolean boolIsDetailedNames = (Boolean)bpartner.get_Value("IsDetailedNames");
        if (boolIsDetailedNames != null) {
            isDetailedNames = boolIsDetailedNames;
        }
        if (!isDetailedNames) {
            bpartner.set_ValueOfColumn("FirstName1", null);
            bpartner.set_ValueOfColumn("FirstName2", null);
            bpartner.set_ValueOfColumn("LastName1", null);
            bpartner.set_ValueOfColumn("LastName2", null);
            return null;
        }
        Object filledName = null;
        if (bpartner.get_Value("FirstName1") == null || ((String)bpartner.get_Value("FirstName1")).length() == 0) {
            return Msg.getMsg(bpartner.getCtx(), "LCO_FirstName1Required");
        }
        if (bpartner.get_Value("LastName1") == null || ((String)bpartner.get_Value("LastName1")).length() == 0) {
            return Msg.getMsg(bpartner.getCtx(), "LCO_LastName1Required");
        }
        filledName = bpartner.get_ValueAsString("FirstName1").trim();
        if (bpartner.get_Value("FirstName2") != null) {
            filledName = (String)filledName + " " + bpartner.get_ValueAsString("FirstName2").trim();
        }
        if (filledName != null) {
            filledName = (String)filledName + " ";
        }
        filledName = (String)filledName + bpartner.get_ValueAsString("LastName1").trim();
        if (bpartner.get_Value("LastName2") != null) {
            filledName = (String)filledName + " " + bpartner.get_ValueAsString("LastName2").trim();
        }
        bpartner.setName((String)filledName);
        return null;
    }
}

