/*
 * Decompiled with CFR 0.152.
 */
package org.shw.model;

import java.util.ArrayList;
import java.util.List;
import org.compiere.acct.Doc;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class SHWValidator_BASICSNEW
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(SHWValidator_BASICSNEW.class);
    private int m_AD_Client_ID = -1;
    private int m_AD_User_ID = -1;
    private int m_AD_Role_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("C_Payment", this);
        engine.addDocValidate("C_AllocationHdr", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        String error = null;
        return error;
    }

    @Override
    public String docValidate(PO po, int timing) {
        String error = null;
        if (po.get_TableName().equals("C_AllocationHdr") && timing == 15) {
            error = this.AfterPost_CorrectGL_Category(po);
        }
        return error;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        this.m_AD_User_ID = AD_User_ID;
        this.m_AD_Role_ID = AD_Role_ID;
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SHWValidator");
        sb.append("]");
        return sb.toString();
    }

    public void beforeSaveProperties() {
        if (this.m_AD_User_ID == 0 || this.m_AD_User_ID == 100 || this.m_AD_Role_ID == 0 || this.m_AD_Role_ID == 1000000) {
            return;
        }
        log.info("Setting default Properties");
    }

    public String AfterPost_CorrectGL_Category(PO po) {
        MAllocationHdr ah = (MAllocationHdr)po;
        Doc doc = ah.getDoc();
        ArrayList<Fact> facts = doc.getFacts();
        Object description = "";
        for (Fact fact : facts) {
            for (FactLine fLine : fact.getLines()) {
                description = "";
                Boolean isPayment = false;
                MAllocationLine alo = new MAllocationLine(po.getCtx(), fLine.getLine_ID(), po.get_TrxName());
                if (alo.getC_Payment_ID() != 0) {
                    fLine.setGL_Category_ID(alo.getC_Payment().getC_DocType().getGL_Category_ID());
                    description = "Pago: " + alo.getC_Payment().getDocumentNo();
                    continue;
                }
                if (alo.getC_CashLine_ID() != 0) {
                    isPayment = alo.getC_CashLine().getC_Invoice_ID() != 0 ? Boolean.valueOf(alo.getC_Invoice().getC_DocType().getDocBaseType().equals("APP")) : Boolean.valueOf(alo.getAmount().compareTo(Env.ZERO) >= 0);
                }
                MDocType dt = null;
                dt = isPayment != false ? (MDocType)new Query(po.getCtx(), "C_DocType", "Docbasetype = 'APP'", null).first() : (MDocType)new Query(po.getCtx(), "C_DocType", "Docbasetype = 'ARR'", null).first();
                fLine.setGL_Category_ID(dt.getGL_Category_ID());
                if (alo.getC_Invoice_ID() != 0) {
                    description = (String)description + " Factura: " + alo.getC_Invoice().getDocumentNo();
                    continue;
                }
                if (alo.getC_Charge_ID() == 0) continue;
                description = (String)description + " Cargo: " + alo.getC_Charge().getName();
            }
        }
        return "";
    }

    public String PaymentCompleteNote(PO A_PO, int A_Type) {
        MPayment pay = (MPayment)A_PO;
        if (pay.getC_Charge_ID() != 0) {
            return "";
        }
        Object note = "";
        if (pay.getC_Invoice_ID() != 0) {
            note = "Factura # " + pay.getC_Invoice().getDocumentNo() + " de " + pay.getC_BPartner().getName();
            pay.set_ValueOfColumn("Note", note);
        }
        String whereClause = "C_Payment_ID=?";
        List alos = new Query(A_PO.getCtx(), "C_AllocationLine", whereClause, A_PO.get_TrxName()).list();
        for (MAllocationLine alo : alos) {
            note = "Facturas # ";
            if (alo.getC_Invoice_ID() == 0) continue;
            note = (String)note + ", " + alo.getC_Invoice().getDocumentNo() + " de " + alo.getC_BPartner().getName();
        }
        pay.set_ValueOfColumn("Note", note);
        return "";
    }

    public String InvoiceUpdateActivity(PO A_PO) {
        MAllocationHdr ah = (MAllocationHdr)A_PO;
        for (MAllocationLine alo : ah.getLines(true)) {
            if (alo.getC_Invoice_ID() == 0 || alo.getC_Invoice() == null) {
                return "";
            }
            if (alo.getC_Invoice().getDateAcct() != ah.getDateAcct()) continue;
            MInvoice invoice = (MInvoice)alo.getC_Invoice();
            int no = DB.executeUpdateEx("Delete from fact_Acct where ad_table_ID = 318 and record_ID = " + invoice.getC_Invoice_ID(), alo.get_TrxName());
            invoice.setPosted(false);
            invoice.setC_Activity_ID(1000145);
            invoice.saveEx();
        }
        return "";
    }
}

