/*
 * Decompiled with CFR 0.152.
 */
package org.shw.process;

import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.Adempiere;
import org.compiere.model.MPInstance;
import org.compiere.model.MSequence;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.process.ProcessInfo;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogMgt;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class EnableNativeSequence
extends SvrProcess {
    String tableName = "";

    @Override
    protected void prepare() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doIt() {
        boolean SYSTEM_NATIVE_SEQUENCE = MSysConfig.getBooleanValue("SYSTEM_NATIVE_SEQUENCE", false);
        if (!SYSTEM_NATIVE_SEQUENCE) {
            throw new AdempiereException("Native Sequence is not Actived");
        }
        boolean ok = false;
        MTable table = new MTable(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        try {
            this.createSequence(table, this.get_TrxName());
            ok = true;
        }
        finally {
            if (!ok) {
                this.setSystemNativeSequence(false);
            }
        }
        return "@OK@";
    }

    private void createSequence(MTable table, String trxName) {
        if (!table.isView()) {
            if (!MSequence.createTableSequence(this.getCtx(), table.getTableName(), trxName)) {
                throw new AdempiereException("Can not create Native Sequence for table " + table.getTableName());
            }
            this.addLog("Create Native Sequence for : " + table.getTableName());
        }
    }

    private void createSequence(String tableName, String trxName) {
        this.createSequence(MTable.get(this.getCtx(), tableName), trxName);
    }

    private void setSystemNativeSequence(boolean value) {
        DB.executeUpdateEx("UPDATE AD_SysConfig SET Value=? WHERE Name='SYSTEM_NATIVE_SEQUENCE'", new Object[]{value ? "Y" : "N"}, null);
        MSysConfig.resetCache();
    }

    public static void main(String[] args) {
        Adempiere.startupEnvironment(true);
        CLogMgt.setLevel(Level.INFO);
        Properties ctx = Env.getCtx();
        int AD_Process_ID = 53156;
        MPInstance pinstance = new MPInstance(ctx, AD_Process_ID, -1);
        pinstance.saveEx();
        ProcessInfo pi = new ProcessInfo("", AD_Process_ID, 0, 0);
        pi.setAD_Client_ID(Env.getAD_Client_ID(ctx));
        pi.setAD_User_ID(Env.getAD_User_ID(ctx));
        pi.setAD_PInstance_ID(pinstance.getAD_PInstance_ID());
        EnableNativeSequence proc = new EnableNativeSequence();
        proc.startProcess(ctx, pi, null);
        if (pi.isError()) {
            throw new AdempiereException(pi.getSummary());
        }
    }
}

