/*
 * Decompiled with CFR 0.152.
 */
package org.shw.process;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MElementValue;
import org.compiere.model.MRule;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class FactReconcile
extends SvrProcess {
    private MElementValue account;
    private int ruleID;
    private Timestamp p_DateAcct_From = null;
    private Timestamp p_DateAcct_To = null;

    @Override
    protected void prepare() {
        int accountID = 0;
        boolean acctSchemaID = false;
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_Rule_ID")) {
                    this.ruleID = para[i].getParameterAsInt();
                } else if (name.equals("Account_ID")) {
                    accountID = para[i].getParameterAsInt();
                } else if (name.equals("DateAcct")) {
                    this.p_DateAcct_From = (Timestamp)para[i].getParameter();
                    this.p_DateAcct_To = (Timestamp)para[i].getParameter_To();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            if (accountID <= 0) continue;
            this.account = new MElementValue(this.getCtx(), accountID, this.get_TrxName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doIt() throws Exception {
        int unmatched;
        int count;
        this.log.info("Reconcile Account: " + this.account.getName());
        String subselect = "null";
        MRule rule = MRule.get(this.getCtx(), this.ruleID);
        if (rule == null || rule.is_new() || !rule.getRuleType().equals("Q") || !rule.getEventType().equals("R")) {
            return "Invalid rule for account reconciliation.";
        }
        subselect = rule.getScript();
        this.log.log(Level.FINE, "Rule subselect: " + subselect);
        Object dateWhere = "";
        if (this.p_DateAcct_From != null) {
            dateWhere = (String)dateWhere + " AND TRUNC(f.DateAcct, 'DD') >= " + DB.TO_DATE(this.p_DateAcct_From);
        }
        if (this.p_DateAcct_To != null) {
            dateWhere = (String)dateWhere + " AND TRUNC(f.DateAcct, 'DD') <= " + DB.TO_DATE(this.p_DateAcct_To);
        }
        Object sql = "";
        this.log.info("AD_PInstance_ID= " + this.getAD_PInstance_ID());
        CPreparedStatement pstmt = null;
        Object rs = null;
        try {
            sql = "INSERT into Fact_Reconciliation (AD_Client_ID, AD_Org_ID, Created, CreatedBy, Updated, UpdatedBy, IsActive, Fact_Acct_ID, fact_reconciliation_ID) SELECT AD_Client_ID, AD_Org_ID, Created, CreatedBy, Updated, UpdatedBy, IsActive, Fact_Acct_ID, fact_Acct_ID FROM Fact_Acct f WHERE Account_ID = ?  AND NOT EXISTS (SELECT 1 FROM Fact_Reconciliation r WHERE r.Fact_Acct_ID = f.Fact_Acct_ID) ";
            pstmt = DB.prepareStatement((String)sql, this.get_TrxName());
            pstmt.setInt(1, this.account.get_ID());
            count = pstmt.executeUpdate();
            this.log.log(Level.FINE, "Inserted " + count + " new facts into Fact_Reconciliation");
            sql = "UPDATE Fact_Reconciliation SET MatchCode = (" + subselect + " ) WHERE MatchCode is null AND (SELECT f.Account_ID FROM Fact_Acct f      WHERE f.Fact_Acct_ID = Fact_Reconciliation.Fact_Acct_ID " + (String)dateWhere + ") = ? AND ( " + subselect + " ) IS NOT NULL ";
            pstmt = DB.prepareStatement((String)sql, this.get_TrxName());
            pstmt.setInt(1, this.account.get_ID());
            count = pstmt.executeUpdate();
            this.log.log(Level.FINE, "Updated " + count + " match codes.");
            sql = "UPDATE Fact_Reconciliation SET MatchCode = null  WHERE  (SELECT f1.Account_ID FROM Fact_Acct f1          WHERE f1.Fact_Acct_ID=Fact_Reconciliation.Fact_Acct_ID) = ?  AND (SELECT SUM(f2.amtacctdr-f2.amtacctcr) FROM Fact_Reconciliation r     INNER JOIN Fact_Acct f2 ON (f2.Fact_Acct_ID = r.Fact_Acct_ID)        WHERE r.MatchCode=Fact_Reconciliation.MatchCode       AND f2.Account_ID = ?) <> 0  AND MatchCode IS NOT NULL";
            pstmt = DB.prepareStatement((String)sql, this.get_TrxName());
            pstmt.setInt(1, this.account.get_ID());
            pstmt.setInt(2, this.account.get_ID());
            unmatched = pstmt.executeUpdate();
            this.log.log(Level.FINE, "Cleared match codes from " + unmatched + " unreconciled facts.");
        }
        catch (SQLException e) {
            String string;
            try {
                this.log.log(Level.SEVERE, (String)sql, e);
                string = e.getLocalizedMessage();
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            return string;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return "Matched " + (count - unmatched) + " facts";
    }
}

