/*
 * Decompiled with CFR 0.152.
 */
package org.shw.process;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.compiere.model.MConversionRate;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MProject;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class InvoiceUpdateProject
extends SvrProcess {
    @Override
    protected void prepare() {
    }

    @Override
    protected String doIt() throws Exception {
        MInvoice invoice = new MInvoice(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(invoice.getC_Invoice_ID());
        String updatesql = "update c_order o set isinvoiced = 'Y'  where docstatus in ('CO', 'CL')  and c_order_ID in  (select c_order_ID from adempiere.c_orderline ol where c_orderline_ID  in (select c_orderline_ID from c_invoiceline where qtyinvoiced = qtyordered and c_invoice_ID=?))";
        int no = DB.executeUpdateEx(updatesql, params.toArray(), this.get_TrxName());
        for (MInvoiceLine ivl : invoice.getLines()) {
            BigDecimal Cost;
            BigDecimal lineNetAmt;
            MProject project = (MProject)ivl.getC_Project();
            BigDecimal rate = Env.ONE;
            if (project.getC_Currency_ID() != invoice.getC_Currency_ID()) {
                rate = MConversionRate.getRate(invoice.getC_Currency_ID(), project.getC_Currency_ID(), invoice.getDateInvoiced(), 104, invoice.getAD_Client_ID(), 0);
            }
            if (invoice.isSOTrx()) {
                BigDecimal openAmt = (BigDecimal)project.get_Value("OpenAmt");
                project.set_ValueOfColumn("OpenAmt", (Object)openAmt.add(rate.multiply(invoice.getGrandTotal())));
                lineNetAmt = (BigDecimal)project.get_Value("LineNetAmt");
                project.set_ValueOfColumn("LineNetAmt", (Object)lineNetAmt.add(rate.multiply(ivl.getLineNetAmt())));
                if (invoice.getC_Project_ID() <= 0) {
                    project.setInvoicedAmt(project.getInvoicedAmt().add(ivl.getLineTotalAmt()));
                }
            } else {
                Cost = (BigDecimal)project.get_Value("Cost");
                project.set_ValueOfColumn("Cost", (Object)Cost.add(ivl.getLineNetAmt()));
            }
            Cost = (BigDecimal)project.get_Value("Cost");
            lineNetAmt = (BigDecimal)project.get_Value("LineNetAmt");
            BigDecimal distributedAmt = (BigDecimal)project.get_Value("distributedAmt");
            project.setProjectBalanceAmt(lineNetAmt.subtract(Cost).subtract(distributedAmt));
            project.saveEx();
        }
        return "";
    }
}

