/*
 * Decompiled with CFR 0.152.
 */
package org.shw.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.compiere.model.MPayment;
import org.compiere.model.MProject;
import org.compiere.model.MRequest;
import org.compiere.model.MRequestType;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;

public class Order_AfterPrepare_CreateRequest
extends SvrProcess {
    private int p_C_UOM_Volumen_ID = 0;
    private int p_C_UOM_Weight_ID = 0;
    private BigDecimal p_qtyWeight = Env.ZERO;
    private BigDecimal p_qtyVolumen = Env.ZERO;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] parameters;
        for (ProcessInfoParameter parameter : parameters = this.getParameter()) {
            String name = parameter.getParameterName();
            if (parameter.getParameter() == null) continue;
            if (name.equals("C_UOM_Volume_ID")) {
                this.p_C_UOM_Volumen_ID = parameter.getParameterAsInt();
                continue;
            }
            if (name.equals("C_UOM_Weight_ID")) {
                this.p_C_UOM_Weight_ID = parameter.getParameterAsInt();
                continue;
            }
            if (name.equals("QtyVolume")) {
                this.p_qtyVolumen = parameter.getParameterAsBigDecimal();
                continue;
            }
            if (!name.equals("QtyWeight")) continue;
            this.p_qtyWeight = parameter.getParameterAsBigDecimal();
        }
    }

    @Override
    protected String doIt() throws Exception {
        MRequest req = new MRequest(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        if (req.get_ValueAsInt("C_BPartnerVendor_ID") == 0) {
            return "Hay que definir el Proveedor";
        }
        int defaultaccount = new Query(req.getCtx(), "C_BankAccount", "", req.get_TrxName()).setClient_ID().setOnlyActiveRecords(true).firstId();
        MPayment pay = new MPayment(this.getCtx(), 0, this.get_TrxName());
        pay.setC_BankAccount_ID(defaultaccount);
        pay.setDateTrx(new Timestamp(System.currentTimeMillis()));
        pay.setAD_Org_ID(req.getAD_Org_ID());
        pay.setC_Project_ID(req.getC_Project_ID());
        pay.setC_BPartner_ID(req.get_ValueAsInt("C_BPartnerVendor_ID"));
        MRequestType rtype = (MRequestType)req.getR_RequestType();
        if (rtype.get_ValueAsInt("C_DocType_ID") != 0) {
            pay.setC_DocType_ID(rtype.get_ValueAsInt("C_DocType_ID"));
        } else {
            pay.setC_DocType_ID(false);
        }
        pay.setC_Charge_ID(req.get_ValueAsInt("C_Charge_ID"));
        pay.setC_Currency_ID(100);
        pay.setPayAmt(req.getRequestAmt());
        pay.setC_Activity_ID(req.getC_Activity_ID());
        pay.setC_Campaign_ID(req.getC_Campaign_ID());
        MProject prj = (MProject)req.getC_Project();
        pay.setUser1_ID(prj.get_ValueAsInt("User1_ID"));
        pay.set_ValueOfColumn("R_Request_ID", (Object)req.getR_Request_ID());
        pay.saveEx();
        req.setC_Payment_ID(pay.getC_Payment_ID());
        req.saveEx();
        return "";
    }
}

