/*
 * Decompiled with CFR 0.152.
 */
package org.shw.process;

import java.math.BigDecimal;
import java.util.List;
import org.compiere.model.MBPartner;
import org.compiere.model.MCharge;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentAllocate;
import org.compiere.model.MRequest;
import org.compiere.model.MTaxCategory;
import org.compiere.model.Query;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;

public class PaymentCTAJCompleteRequest
extends SvrProcess {
    private MPayment pay = null;

    @Override
    protected void prepare() {
    }

    @Override
    protected String doIt() throws Exception {
        this.pay = new MPayment(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        List reqs = new Query(this.getCtx(), "R_Request", "c_payment_ID=?", this.get_TrxName()).setParameters(this.pay.getC_Payment_ID()).list();
        if (reqs == null || reqs.isEmpty()) {
            return "";
        }
        for (MRequest req : reqs) {
            if (req.getC_Order_ID() <= 0) {
                return "";
            }
            if (req.getR_Status().isClosed()) {
                return "";
            }
            if (this.pay.getC_Charge_ID() != 0) {
                this.CreateCTAJPayment(req);
                continue;
            }
            this.CreateCTAJPaymentAllocs(req);
        }
        int r_status = 0;
        if (Env.getAD_Client_ID(Env.getCtx()) == 1000001) {
            r_status = 1000001;
        } else if (Env.getAD_Client_ID(Env.getCtx()) == 1000012) {
            r_status = 1000011;
        }
        if (r_status == 0) {
            return "";
        }
        for (MRequest req : reqs) {
            req.setR_Status_ID(r_status);
            req.setSalesRep_ID(req.getCreatedBy());
            req.saveEx();
        }
        return "";
    }

    private void CreateInvoicePayment(MRequest req) {
        MOrder order = (MOrder)req.getC_Order();
        BigDecimal p_DistributionAmt = this.pay.getPayAmt();
        MOrderLine oLine = new MOrderLine(order);
        MInvoice invoice = (MInvoice)this.pay.getC_Invoice();
        for (MInvoiceLine ivl : invoice.getLines()) {
            if (ivl.getC_Charge_ID() <= 0) continue;
            MTaxCategory tc = (MTaxCategory)ivl.getC_Charge().getC_TaxCategory();
            oLine.setC_Tax_ID(tc.getDefaultTax().getC_Tax_ID());
            oLine.setQty(Env.ONE);
            oLine.setPrice(p_DistributionAmt);
            oLine.set_ValueOfColumn("C_Payment_ID", (Object)this.pay.getC_Payment_ID());
            oLine.setC_Project_ID(this.pay.getC_Project_ID());
            MBPartner bpartner = (MBPartner)oLine.getC_Order().getC_BPartner();
            oLine.set_ValueOfColumn("isSplitInvoice", (Object)bpartner.get_ValueAsBoolean("isSplitInvoice"));
            oLine.saveEx();
        }
        this.pay.set_ValueOfColumn("isInvoiced", (Object)true);
        this.pay.setDescription((String)(this.pay.getDescription() == null ? "" : this.pay.getDescription() + " Asignado en orden: " + order.getDocumentNo()));
        this.pay.saveEx();
    }

    private void CreateCTAJPayment(MRequest req) {
        MOrder order = (MOrder)req.getC_Order();
        BigDecimal p_DistributionAmt = this.pay.getPayAmt();
        MOrderLine oLine = (MOrderLine)new Query(this.getCtx(), "C_OrderLine", "c_order_ID=? and c_payment_ID=?", this.get_TrxName()).setParameters(order.getC_Order_ID(), this.pay.getC_Payment_ID()).first();
        if (oLine != null) {
            return;
        }
        oLine = new MOrderLine(order);
        int chargeID = this.pay.getC_Charge_ID();
        oLine.setC_Charge_ID(chargeID);
        MCharge charge = new MCharge(this.getCtx(), chargeID, this.get_TrxName());
        MTaxCategory tc = (MTaxCategory)charge.getC_TaxCategory();
        oLine.setC_Tax_ID(tc.getDefaultTax().getC_Tax_ID());
        oLine.setQty(Env.ONE);
        oLine.setPrice(p_DistributionAmt);
        oLine.set_ValueOfColumn("C_Payment_ID", (Object)this.pay.getC_Payment_ID());
        oLine.setC_Project_ID(this.pay.getC_Project_ID());
        MBPartner bpartner = (MBPartner)oLine.getC_Order().getC_BPartner();
        oLine.set_ValueOfColumn("isSplitInvoice", (Object)bpartner.get_ValueAsBoolean("isSplitInvoice"));
        oLine.saveEx();
        this.pay.set_ValueOfColumn("isInvoiced", (Object)true);
        this.pay.setDescription((String)(this.pay.getDescription() == null ? "" : this.pay.getDescription() + " Asignado en orden: " + order.getDocumentNo()));
        this.pay.set_ValueOfColumn("ControlAmt", (Object)p_DistributionAmt);
        this.pay.saveEx();
    }

    private void CreateCTAJPaymentAllocs(MRequest req) {
        MPaymentAllocate[] pAllocs;
        MOrder order = (MOrder)req.getC_Order();
        BigDecimal p_DistributionAmt = this.pay.getPayAmt();
        for (MPaymentAllocate alloc : pAllocs = MPaymentAllocate.get(this.pay)) {
            MOrderLine oLine = (MOrderLine)new Query(this.getCtx(), "C_OrderLine", "c_order_ID=? and c_payment_ID=?", this.get_TrxName()).setParameters(order.getC_Order_ID(), this.pay.getC_Payment_ID()).first();
            if (oLine != null) {
                return;
            }
            oLine = new MOrderLine(order);
            int chargeID = alloc.get_ValueAsInt("C_Charge_ID");
            oLine.setC_Charge_ID(chargeID);
            MCharge charge = new MCharge(this.getCtx(), chargeID, this.get_TrxName());
            MTaxCategory tc = (MTaxCategory)charge.getC_TaxCategory();
            oLine.setC_Tax_ID(tc.getDefaultTax().getC_Tax_ID());
            oLine.setQty(Env.ONE);
            oLine.setPrice(p_DistributionAmt);
            oLine.set_ValueOfColumn("C_Payment_ID", (Object)this.pay.getC_Payment_ID());
            oLine.setC_Project_ID(this.pay.getC_Project_ID());
            MBPartner bpartner = (MBPartner)oLine.getC_Order().getC_BPartner();
            oLine.set_ValueOfColumn("isSplitInvoice", (Object)bpartner.get_ValueAsBoolean("isSplitInvoice"));
            oLine.saveEx();
        }
        this.pay.set_ValueOfColumn("isInvoiced", (Object)true);
        this.pay.setDescription((String)(this.pay.getDescription() == null ? "" : this.pay.getDescription() + " Asignado en orden: " + order.getDocumentNo()));
        this.pay.set_ValueOfColumn("ControlAmt", (Object)p_DistributionAmt);
        this.pay.saveEx();
    }
}

