/*
 * Decompiled with CFR 0.152.
 */
package org.shw.process;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MDistribution;
import org.compiere.model.MDistributionLine;
import org.compiere.model.MGLCategory;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPeriod;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.model.PO;
import org.compiere.model.ProductCost;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ProjectClose
extends SvrProcess {
    private int m_C_Project_ID = 0;
    private MProject project = null;
    private Boolean p_isshipped = false;
    private MDistribution distribution = null;
    private ArrayList<MOrder> ordersToPost = new ArrayList();
    private ArrayList<MInvoice> invoicesToPost = new ArrayList();

    @Override
    protected void prepare() {
        ProcessInfoParameter[] parameters;
        for (ProcessInfoParameter para : parameters = this.getParameter()) {
            String name = para.getParameterName();
            if (para.getParameter() == null) {
                // empty if block
            }
            if (!name.equals("isshipped")) continue;
            this.p_isshipped = para.getParameterAsBoolean();
        }
        this.m_C_Project_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        this.project = new MProject(this.getCtx(), this.m_C_Project_ID, this.get_TrxName());
        String result = "";
        result = this.openInSale(this.project);
        if (!result.equals("")) {
            return result;
        }
        result = this.ProjectOpeninPurchase(this.project);
        if (!result.equals("")) {
            return result;
        }
        if (this.project.getProjectCategory().equals("M")) {
            if (this.getChildren().length == 0) {
                return "El proyecto no tiene proyectos hijo";
            }
            this.distributeProject();
        }
        this.log.info("doIt - " + this.project);
        if (this.p_isshipped.booleanValue()) {
            this.project.set_ValueOfColumn("isshipped", (Object)this.p_isshipped);
            this.project.saveEx();
            return "";
        }
        MProjectLine[] projectLines = this.project.getLines().toArray(new MProjectLine[this.project.getLines().size()]);
        if ("W".equals(this.project.getProjectCategory()) || "A".equals(this.project.getProjectCategory())) {
            // empty if block
        }
        for (int line = 0; line < projectLines.length; ++line) {
            projectLines[line].setProcessed(true);
            projectLines[line].saveEx();
        }
        this.project.setProcessed(true);
        this.project.saveEx();
        return "";
    }

    private MProject[] getChildren() {
        String whereClause = " C_Project_Parent_ID =?";
        List<MProject> list = new Query(this.getCtx(), "C_Project", whereClause, this.get_TrxName()).setApplyAccessFilter(true).setParameters(this.m_C_Project_ID).list();
        return list.toArray(new MProject[list.size()]);
    }

    private String openInSale(MProject project) {
        List oLines = new Query(this.getCtx(), "C_OrderLine", "C_Project_ID=? ", this.get_TrxName()).setParameters(project.getC_Project_ID()).list();
        for (MOrderLine oLine : oLines) {
            if (!oLine.getParent().isSOTrx() || oLine.getParent().getDocStatus().equals("VO") || oLine.getParent().getDocStatus().equals("RE") || !oLine.getParent().getDocStatus().equals("DR") && !oLine.getParent().getDocStatus().equals("IP") && !oLine.getParent().getDocStatus().equals("IN")) continue;
            return "El projecto hijo " + project.getValue() + " tiene OdV no completadas";
        }
        return "";
    }

    private String ProjectOpeninPurchase(MProject project) {
        List oLines = new Query(this.getCtx(), "C_OrderLine", "C_Project_ID=? ", this.get_TrxName()).setParameters(project.getC_Project_ID()).list();
        for (MOrderLine oLine : oLines) {
            if (oLine.getParent().isSOTrx() || oLine.getParent().getDocStatus().equals("VO") || oLine.getParent().getDocStatus().equals("RE") || !oLine.getParent().getDocStatus().equals("DR") && !oLine.getParent().getDocStatus().equals("IP") && !oLine.getParent().getDocStatus().equals("IN")) continue;
            return "El projecto " + project.getValue() + " tiene OdC no completadas";
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String distributeProject() {
        String error;
        Object result = "";
        for (MAcctSchema as : MAcctSchema.getClientAcctSchema(this.getCtx(), this.project.getAD_Client_ID())) {
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(this.project.getC_Project_ID());
            params.add(this.project.getName());
            params.add(as.getC_AcctSchema_ID());
            this.distribution = (MDistribution)new Query(this.getCtx(), "GL_Distribution", "c_Project_ID=? and name = ? and c_acctschema_ID=?", this.get_TrxName()).setParameters(params).first();
            if (this.distribution == null) {
                this.createDistribution(as);
            }
            this.distributeOrders(as);
            this.distributeInvoices(as);
        }
        for (MOrder order : this.ordersToPost) {
            Doc doc = Doc.get(MAcctSchema.getClientAcctSchema(this.getCtx(), this.project.getAD_Client_ID()), MOrder.Table_ID, order.getC_Order_ID(), this.get_TrxName());
            try {
                if (doc == null) {
                    this.log.severe(this.getName() + ": No Doc for C_Order");
                    continue;
                }
                error = doc.post(false, false);
                String postStatus = doc.getPostStatus();
                result = (String)result + " " + error + " " + postStatus;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, this.getName() + ": C_Order", e);
            }
        }
        for (MInvoice invoice : this.invoicesToPost) {
            Doc doc = Doc.get(MAcctSchema.getClientAcctSchema(this.getCtx(), this.project.getAD_Client_ID()), MInvoice.Table_ID, invoice.getC_Invoice_ID(), this.get_TrxName());
            try {
                if (doc == null) {
                    this.log.severe(this.getName() + ": No Doc for C_Invoice");
                    continue;
                }
                error = doc.post(false, false);
                String string = doc.getPostStatus();
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, this.getName() + ": C_Order", e);
            }
        }
        return result;
    }

    private void createDistribution(MAcctSchema as) {
        String ProjectDistribution = this.project.get_ValueAsString("ProjectDistribution");
        if (ProjectDistribution == null || ProjectDistribution == "") {
            ProjectDistribution = "I";
        }
        if (this.distribution == null) {
            this.distribution = new MDistribution(this.getCtx(), 0, this.get_TrxName());
            this.distribution.setAnyProject(false);
            this.distribution.setC_Project_ID(this.project.getC_Project_ID());
            this.distribution.setName(this.project.getName());
            this.distribution.setC_AcctSchema_ID(as.getC_AcctSchema_ID());
            this.distribution.saveEx();
        }
        List projectsOfFather = new Query(this.getCtx(), "C_Project", "C_Project_Parent_ID=?", this.get_TrxName()).setParameters(this.project.getC_Project_ID()).list();
        BigDecimal weight_father = (BigDecimal)this.project.get_Value("Weight");
        BigDecimal Volume_father = (BigDecimal)this.project.get_Value("Volume");
        for (MProject projectson : projectsOfFather) {
            BigDecimal weight = (BigDecimal)projectson.get_Value("Weight");
            BigDecimal volume = (BigDecimal)projectson.get_Value("volume");
            BigDecimal share = ProjectDistribution.equals("W") ? weight.divide(weight_father, 5, 5) : volume.divide(Volume_father, 5, 5);
            share = share.multiply(Env.ONEHUNDRED);
            MDistributionLine dLine = new MDistributionLine(this.getCtx(), 0, this.get_TrxName());
            dLine.setGL_Distribution_ID(this.distribution.getGL_Distribution_ID());
            dLine.setOverwriteProject(true);
            dLine.setC_Project_ID(projectson.getC_Project_ID());
            dLine.setPercent(share);
            this.distribution.setPercentTotal(this.distribution.getPercentTotal().add(share));
            dLine.saveEx();
        }
        this.distribution.saveEx();
        BigDecimal diff = Env.ONEHUNDRED.subtract(this.distribution.getPercentTotal());
        if (diff.compareTo(Env.ONEHUNDRED) != 0) {
            String whereClause = "GL_Distribution_ID=?";
            MDistributionLine maxLine = (MDistributionLine)new Query(this.getCtx(), "GL_DistributionLine", "GL_Distribution_ID=?", this.get_TrxName()).setParameters(this.distribution.getGL_Distribution_ID()).setOrderBy("Percent desc").first();
            maxLine.setPercent(maxLine.getPercent().add(diff));
            maxLine.saveEx();
        }
        this.distribution.validate();
    }

    public boolean clearAccounting(MAcctSchema accountSchema, PO model) {
        String sqlUpdate = "UPDATE " + model.get_TableName() + " SET Posted = 'N' WHERE " + model.get_TableName() + "_ID=?";
        int no = DB.executeUpdate(sqlUpdate, new Object[]{model.get_ID()}, false, model.get_TrxName());
        String sqldelete = "DELETE FROM Fact_Acct WHERE Record_ID =? AND AD_Table_ID=?";
        no = DB.executeUpdate("DELETE FROM Fact_Acct WHERE Record_ID =? AND AD_Table_ID=?", new Object[]{model.get_ID(), model.get_Table_ID()}, false, model.get_TrxName());
        return true;
    }

    private String createJournal(MAcctSchema as, MOrderLine oLine) {
        MJournal journal = new MJournal(this.getCtx(), 0, this.get_TrxName());
        for (MJournalLine mJournalLine : journal.getLines(true)) {
        }
        int glcat_ID = MGLCategory.getDefault(this.getCtx(), "M").getGL_Category_ID();
        int c_doctype_ID = new Query(this.getCtx(), "C_DocType", "gl_category_ID=?", this.get_TrxName()).setParameters(glcat_ID).setOnlyActiveRecords(true).firstId();
        journal.setC_Currency_ID(100);
        journal.setC_AcctSchema_ID(as.get_ID());
        journal.setC_ConversionType_ID(114);
        journal.setDescription("");
        journal.setGL_Category_ID(glcat_ID);
        journal.setC_DocType_ID(c_doctype_ID);
        journal.setPostingType("A");
        journal.setDocumentNo(DB.getDocumentNo(this.getAD_Client_ID(), "GL_Journal", this.get_TrxName()));
        journal.setDescription(oLine.getParent().getDocumentInfo() + " " + oLine.getLine());
        journal.saveEx();
        MJournalLine jLine = new MJournalLine(journal);
        jLine.setM_Product_ID(oLine.getM_Product_ID());
        jLine.setC_Project_ID(oLine.getC_Project_ID());
        jLine.setC_BPartner_ID(oLine.getParent().getC_BPartner_ID());
        jLine.setC_Activity_ID(oLine.getParent().getC_Activity_ID());
        jLine.setC_Campaign_ID(oLine.getParent().getC_Campaign_ID());
        ProductCost pc = new ProductCost(this.getCtx(), oLine.getM_Product_ID(), 0, this.get_TrxName());
        MAccount expense = pc.getAccount(2, as);
        jLine.setAccount_ID(expense.getAccount_ID());
        jLine.setAmtSourceCr(oLine.getLineNetAmt());
        jLine.saveEx();
        for (MDistributionLine dLine : this.distribution.getLines(true)) {
            jLine = new MJournalLine(journal);
            jLine.setM_Product_ID(oLine.getM_Product_ID());
            jLine.setC_BPartner_ID(oLine.getParent().getC_BPartner_ID());
            jLine.setC_Activity_ID(oLine.getParent().getC_Activity_ID());
            jLine.setC_Campaign_ID(oLine.getParent().getC_Campaign_ID());
            jLine.setAccount_ID(expense.getAccount_ID());
            jLine.setAmtSourceDr(dLine.getPercent().divide(Env.ONEHUNDRED).multiply(oLine.getLineNetAmt()));
            jLine.saveEx();
        }
        journal.saveEx();
        return "";
    }

    private String createJournal(MAcctSchema as, MInvoiceLine oLine) {
        MJournal journal = new MJournal(this.getCtx(), 0, this.get_TrxName());
        for (MJournalLine mJournalLine : journal.getLines(true)) {
        }
        int glcat_ID = MGLCategory.getDefault(this.getCtx(), "M").getGL_Category_ID();
        int c_doctype_ID = new Query(this.getCtx(), "C_DocType", "gl_category_ID=?", this.get_TrxName()).setParameters(glcat_ID).setOnlyActiveRecords(true).firstId();
        journal.setC_Currency_ID(100);
        journal.setC_AcctSchema_ID(as.get_ID());
        journal.setC_ConversionType_ID(114);
        journal.setDescription("");
        journal.setGL_Category_ID(glcat_ID);
        journal.setC_DocType_ID(c_doctype_ID);
        journal.setPostingType("A");
        journal.setDocumentNo(DB.getDocumentNo(this.getAD_Client_ID(), "GL_Journal", this.get_TrxName()));
        journal.setDescription(oLine.getParent().getDocumentInfo() + " " + oLine.getLine());
        journal.saveEx();
        MJournalLine jLine = new MJournalLine(journal);
        jLine.setM_Product_ID(oLine.getM_Product_ID());
        jLine.setC_Project_ID(oLine.getC_Project_ID());
        jLine.setC_BPartner_ID(oLine.getParent().getC_BPartner_ID());
        jLine.setC_Activity_ID(oLine.getParent().getC_Activity_ID());
        jLine.setC_Campaign_ID(oLine.getParent().getC_Campaign_ID());
        ProductCost pc = new ProductCost(this.getCtx(), oLine.getM_Product_ID(), 0, this.get_TrxName());
        MAccount expense = pc.getAccount(2, as);
        jLine.setAccount_ID(expense.getAccount_ID());
        jLine.setAmtSourceCr(oLine.getLineNetAmt());
        jLine.saveEx();
        for (MDistributionLine dLine : this.distribution.getLines(true)) {
            jLine = new MJournalLine(journal);
            jLine.setM_Product_ID(oLine.getM_Product_ID());
            jLine.setC_BPartner_ID(oLine.getParent().getC_BPartner_ID());
            jLine.setC_Activity_ID(oLine.getParent().getC_Activity_ID());
            jLine.setC_Campaign_ID(oLine.getParent().getC_Campaign_ID());
            jLine.setAccount_ID(expense.getAccount_ID());
            jLine.setAmtSourceDr(dLine.getPercent().divide(Env.ONEHUNDRED).multiply(oLine.getLineNetAmt()));
            jLine.saveEx();
        }
        journal.saveEx();
        return "";
    }

    private String distributeOrders(MAcctSchema as) {
        String whereClause = "C_Project_ID=?";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.project.getC_Project_ID());
        List oLines = new Query(this.getCtx(), "C_OrderLine", whereClause, this.get_TrxName()).setParameters(params).setOrderBy("C_Order_ID ").list();
        if (oLines == null) {
            return "";
        }
        for (MOrderLine oLine : oLines) {
            if (oLine.getC_Order().getDocStatus().equals("DR") || oLine.getC_Order().getDocStatus().equals("IP") || oLine.getC_Order().getDocStatus().equals("IN")) continue;
            if (MPeriod.isOpen(this.getCtx(), oLine.getC_Order().getDateAcct(), oLine.getC_Order().getC_DocType().getDocBaseType(), oLine.getAD_Org_ID())) {
                Boolean isadded = false;
                for (MOrder order : this.ordersToPost) {
                    if (order.getC_Order_ID() != oLine.getC_Order_ID()) continue;
                    isadded = true;
                    break;
                }
                if (isadded.booleanValue()) continue;
                this.ordersToPost.add(oLine.getParent());
                continue;
            }
            this.createJournal(as, oLine);
        }
        for (MOrder order : this.ordersToPost) {
            this.clearAccounting(as, order);
        }
        return "";
    }

    private String distributeInvoices(MAcctSchema as) {
        String whereClause = "C_Project_ID=?";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.project.getC_Project_ID());
        List oLines = new Query(this.getCtx(), "C_InvoiceLine", whereClause, this.get_TrxName()).setParameters(params).setOrderBy("C_Invoice_ID ").list();
        if (oLines == null) {
            return "";
        }
        for (MInvoiceLine oLine : oLines) {
            if (oLine.getC_Invoice().getDocStatus().equals("DR") || oLine.getC_Invoice().getDocStatus().equals("IP") || oLine.getC_Invoice().getDocStatus().equals("IN")) continue;
            if (MPeriod.isOpen(this.getCtx(), oLine.getC_Invoice().getDateAcct(), oLine.getC_Invoice().getC_DocType().getDocBaseType(), oLine.getAD_Org_ID())) {
                Boolean isadded = false;
                for (MInvoice invoice : this.invoicesToPost) {
                    if (invoice.getC_Invoice_ID() != oLine.getC_Invoice_ID()) continue;
                    isadded = true;
                    break;
                }
                if (!isadded.booleanValue()) {
                    this.invoicesToPost.add(oLine.getParent());
                }
            } else {
                this.createJournal(as, oLine);
            }
            for (MInvoice invoice : this.invoicesToPost) {
                this.clearAccounting(as, invoice);
            }
        }
        return "";
    }
}

