/*
 * Decompiled with CFR 0.152.
 */
package org.shw.process;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.compiere.model.MRole;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;

public class RoleAccessUpdate
extends SvrProcess {
    private int P_AD_Role_ID = -1;
    private int P_AD_Client_ID = -1;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("AD_Role_ID")) {
                this.P_AD_Role_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("AD_Client_ID")) {
                this.P_AD_Client_ID = para[i].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("AD_Client_ID=" + this.P_AD_Client_ID + ", AD_Role_ID=" + this.P_AD_Role_ID);
        Object resultRole = "";
        Object result = "";
        ArrayList<Object> params = new ArrayList<Object>();
        Object whereClause = "1=1";
        if (this.P_AD_Client_ID > 0) {
            whereClause = (String)whereClause + " AND AD_Client_ID=? ";
            params.add(this.P_AD_Client_ID);
        }
        if (this.P_AD_Role_ID >= 0) {
            whereClause = (String)whereClause + " AND AD_Role_ID=?";
            params.add(this.P_AD_Role_ID);
        }
        List roles = new Query(this.getCtx(), "AD_Role", (String)whereClause, this.get_TrxName()).setOnlyActiveRecords(true).setParameters(params).setOrderBy("AD_Client_ID, Name").list();
        for (MRole role : roles) {
            String roleClientOrgUser = role.getAD_Role_ID() + "," + this.getAD_Client_ID() + "," + role.getAD_Org_ID() + ",'Y', SysDate," + role.getUpdatedBy() + ", SysDate," + role.getUpdatedBy() + ",'Y' ";
            String sqlWindow = "INSERT INTO AD_Window_Access (AD_Window_ID, AD_Role_ID, AD_Client_ID,AD_Org_ID,IsActive,Created,CreatedBy,Updated,UpdatedBy,IsReadWrite) SELECT DISTINCT w.AD_Window_ID, " + roleClientOrgUser + "FROM AD_Window w INNER JOIN AD_Tab t ON (w.AD_Window_ID=t.AD_Window_ID) INNER JOIN AD_Table tt ON (t.AD_Table_ID=tt.AD_Table_ID)  WHERE t.SeqNo=(SELECT MIN(SeqNo) FROM AD_Tab xt WHERE xt.AD_Window_ID=w.AD_Window_ID) and not exists(select 1 from ad_window_Access wa where ad_role_ID =? and wa.ad_window_ID = w.ad_window_ID) AND tt.AccessLevel IN ";
            String sqlProcess = "INSERT INTO AD_Process_Access (AD_Process_ID, AD_Role_ID, AD_Client_ID,AD_Org_ID,IsActive,Created,CreatedBy,Updated,UpdatedBy,IsReadWrite) SELECT DISTINCT p.AD_Process_ID, " + roleClientOrgUser + "FROM AD_Process p  WHERE not exists(select 1 from ad_process_Access pa where ad_role_ID = ? and pa.ad_process_ID = p.ad_process_ID) AND AccessLevel IN ";
            String sqlForm = "INSERT INTO AD_Form_Access (AD_Form_ID, AD_Role_ID, AD_Client_ID,AD_Org_ID,IsActive,Created,CreatedBy,Updated,UpdatedBy,IsReadWrite) SELECT f.AD_Form_ID, " + roleClientOrgUser + "FROM AD_Form f  where not exists(select 1 from ad_form_Access fa where ad_role_ID =? and fa.ad_form_ID = f.ad_form_ID) AND AccessLevel IN ";
            String sqlBrowse = "INSERT INTO AD_Browse_Access (AD_Browse_ID, AD_Role_ID, AD_Client_ID,AD_Org_ID,IsActive,Created,CreatedBy,Updated,UpdatedBy,IsReadWrite) SELECT b.AD_Browse_ID, " + roleClientOrgUser + "FROM AD_Browse b   where not exists(select 1 from ad_Browse_Access ba where ad_role_ID =? and ba.ad_browse_ID = b.ad_browse_ID) AND AccessLevel IN ";
            String sqlWorkflow = "INSERT INTO AD_WorkFlow_Access (AD_WorkFlow_ID, AD_Role_ID, AD_Client_ID,AD_Org_ID,IsActive,Created,CreatedBy,Updated,UpdatedBy,IsReadWrite) SELECT w.AD_WorkFlow_ID, " + roleClientOrgUser + "FROM AD_WorkFlow w   where not exists(select 1 from ad_workflow_Access wa where ad_role_ID =? and wa.ad_workflow_ID = w.ad_workflow_ID) AND AccessLevel IN ";
            String roleAccessLevel = null;
            Object roleAccessLevelWin = null;
            if ("S  ".equals(role.getUserLevel())) {
                roleAccessLevel = "('4','7','6')";
            } else if (" C ".equals(role.getUserLevel())) {
                roleAccessLevel = "('7','6','3','2')";
            } else if (" CO".equals(role.getUserLevel())) {
                roleAccessLevel = "('7','6','3','2','1')";
            } else {
                roleAccessLevel = "('3','1','7')";
                roleAccessLevelWin = roleAccessLevel + " AND w.Name NOT LIKE '%(all)%'";
            }
            if (roleAccessLevelWin == null) {
                roleAccessLevelWin = roleAccessLevel;
            }
            int win = DB.executeUpdate(sqlWindow + (String)roleAccessLevelWin, role.getAD_Role_ID(), this.get_TrxName());
            int proc = DB.executeUpdate(sqlProcess + roleAccessLevel, role.getAD_Role_ID(), this.get_TrxName());
            int form = DB.executeUpdate(sqlForm + roleAccessLevel, role.getAD_Role_ID(), this.get_TrxName());
            int browse = DB.executeUpdate(sqlBrowse + roleAccessLevel, role.getAD_Role_ID(), this.get_TrxName());
            int wf = DB.executeUpdate(sqlWorkflow + roleAccessLevel, role.getAD_Role_ID(), this.get_TrxName());
            role.loadAccess(true);
            resultRole = "@AD_Window_ID@ #" + win + " -  @AD_Process_ID@ #" + proc + " -  @AD_Form_ID@ #" + form + " -  @AD_Browse_ID@ #" + browse + " -  @AD_Workflow_ID@ #" + wf + " -  @DocAction@ #";
            result = (String)result + (String)resultRole;
        }
        return result;
    }
}

