/*
 * Decompiled with CFR 0.152.
 */
package org.shw.process;

import java.math.BigDecimal;
import org.compiere.model.MBPartner;
import org.compiere.model.MCharge;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MRequest;
import org.compiere.model.MTaxCategory;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;

public class SHW_CreateOrderLineCTAJ
extends SvrProcess {
    @Override
    protected void prepare() {
        ProcessInfoParameter[] parameters;
        for (ProcessInfoParameter parameter : parameters = this.getParameter()) {
            String name = parameter.getParameterName();
            if (parameter.getParameter() != null) continue;
        }
    }

    @Override
    protected String doIt() throws Exception {
        MRequest req = new MRequest(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        MOrder order = (MOrder)req.getC_Order();
        if (req.getC_Order_ID() <= 0) {
            return "la solicitud " + req.getDocumentNo() + "no tiene referencia a niguna orden";
        }
        BigDecimal p_DistributionAmt = req.getRequestAmt();
        MOrderLine oLine = (MOrderLine)new Query(this.getCtx(), "C_OrderLine", "c_order_ID=? and r_request_ID=?", this.get_TrxName()).setParameters(order.getC_Order_ID(), this.getRecord_ID()).first();
        if (oLine != null) {
            return "";
        }
        oLine = new MOrderLine(order);
        int chargeID = req.get_ValueAsInt("C_Charge_ID");
        oLine.setC_Charge_ID(chargeID);
        MCharge charge = new MCharge(this.getCtx(), chargeID, this.get_TrxName());
        MTaxCategory tc = (MTaxCategory)charge.getC_TaxCategory();
        oLine.setC_Tax_ID(tc.getDefaultTax().getC_Tax_ID());
        oLine.setQty(Env.ONE);
        oLine.setPrice(p_DistributionAmt);
        oLine.setC_Project_ID(req.getC_Project_ID());
        MBPartner bpartner = (MBPartner)oLine.getC_Order().getC_BPartner();
        oLine.set_ValueOfColumn("isSplitInvoice", (Object)bpartner.get_ValueAsBoolean("isSplitInvoice"));
        oLine.set_ValueOfColumn("R_Request_ID", (Object)this.getRecord_ID());
        oLine.saveEx();
        req.set_ValueOfColumn("C_OrderLine_ID", (Object)oLine.getC_OrderLine_ID());
        req.saveEx();
        return "";
    }
}

