/*
 * Decompiled with CFR 0.152.
 */
package org.shw.process;

import java.sql.Timestamp;
import java.util.List;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MPayment;
import org.compiere.model.MProject;
import org.compiere.model.MRequest;
import org.compiere.model.MRequestType;
import org.compiere.model.Query;
import org.shw.process.SHW_CreatePaymentFromRequestAbstract;

public class SHW_CreatePaymentFromRequest
extends SHW_CreatePaymentFromRequestAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        MRequest req = new MRequest(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        int defaultaccount = new Query(req.getCtx(), "C_BankAccount", "", req.get_TrxName()).setClient_ID().setOnlyActiveRecords(true).firstId();
        MPayment pay = new MPayment(this.getCtx(), 0, this.get_TrxName());
        pay.setC_BankAccount_ID(defaultaccount);
        pay.setDateTrx(new Timestamp(System.currentTimeMillis()));
        pay.setIsOverUnderPayment(true);
        pay.setAD_Org_ID(req.getAD_Org_ID());
        pay.setC_Project_ID(req.getC_Project_ID());
        MRequestType rtype = (MRequestType)req.getR_RequestType();
        if (rtype.get_ValueAsInt("C_DocType_ID") != 0) {
            pay.setC_DocType_ID(rtype.get_ValueAsInt("C_DocType_ID"));
        } else {
            pay.setC_DocType_ID(false);
        }
        int c_charge_ID = req.get_ValueAsInt("C_Charge_ID");
        int c_invoice_ID = req.getC_Invoice_ID();
        int c_order_PO_ID = req.get_ValueAsInt("c_order_ID");
        if (c_charge_ID == 0 && c_invoice_ID == 0 && c_order_PO_ID == 0) {
            return "";
        }
        if (c_charge_ID != 0) {
            if (req.get_ValueAsInt("C_BPartnerVendor_ID") == 0) {
                return "Hay que definir el Proveedor";
            }
            pay.setC_BPartner_ID(req.get_ValueAsInt("C_BPartnerVendor_ID"));
            pay.setC_Charge_ID(req.get_ValueAsInt("C_Charge_ID"));
            pay.setPayAmt(req.getRequestAmt());
        } else if (c_invoice_ID != 0) {
            pay.setC_BPartner_ID(req.getC_Invoice().getC_BPartner_ID());
            pay.setC_Invoice_ID(c_invoice_ID);
            pay.setPayAmt(req.getC_Invoice().getGrandTotal());
        } else if (c_order_PO_ID != 0) {
            MOrder order = new MOrder(this.getCtx(), c_order_PO_ID, this.get_TrxName());
            pay.setC_BPartner_ID(order.getC_BPartner_ID());
            pay.setC_Order_ID(order.getC_Order_ID());
            pay.setPayAmt(order.getGrandTotal());
        }
        pay.setC_Currency_ID(req.get_ValueAsInt("C_Currency_ID"));
        pay.setC_Activity_ID(req.getC_Activity_ID());
        pay.setC_Campaign_ID(req.getC_Campaign_ID());
        MProject prj = (MProject)req.getC_Project();
        pay.setUser1_ID(prj.get_ValueAsInt("User1_ID"));
        pay.set_ValueOfColumn("R_Request_ID", (Object)req.getR_Request_ID());
        String whereClause = "c_bpartner_ID = ? and ispaid = 'N' and docstatus in ('CO','CL') and issotrx = 'N' ";
        List invoices = new Query(this.getCtx(), "C_Invoice", whereClause, this.get_TrxName()).setParameters(pay.getC_BPartner_ID()).list();
        Object description = "";
        for (MInvoice inv : invoices) {
            if (!inv.getC_DocType().getDocBaseType().equals("APC")) continue;
            description = (String)description + " Nota de Credito: " + inv.getDocumentNo() + " " + inv.getGrandTotal().toString();
        }
        if (!((String)description).equals("")) {
            pay.setDescription(" " + (String)description);
        }
        pay.saveEx();
        req.setC_Payment_ID(pay.getC_Payment_ID());
        req.saveEx();
        return "Pago " + pay.getDocumentInfo();
    }
}

