/*
 * Decompiled with CFR 0.152.
 */
package org.shw.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MQuery;
import org.compiere.model.MSession;
import org.compiere.model.MStorage;
import org.compiere.model.MTable;
import org.compiere.model.MWarehouse;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.shw.model.MLGProductPriceRate;

public class SHW_InvoiceGenerate
extends SvrProcess {
    private Timestamp p_DateInvoiced = null;
    private boolean p_ConsolidateDocument = true;
    private String p_docAction = "";
    private MInvoice m_invoice = null;
    private MInOut m_ship = null;
    private int m_created = 0;
    private int m_line = 0;
    private MBPartner m_bp = null;
    private Boolean p_isExcludePriceRateProducts = false;
    private int P_C_Invoice_ID = 0;
    protected List<MOrder> m_records = null;
    protected List<MInvoice> m_invoices = null;
    private int errorcount = 0;
    private String error = "";

    @Override
    protected void prepare() {
        ProcessInfoParameter[] parameters;
        for (ProcessInfoParameter para : parameters = this.getParameter()) {
            String name = para.getParameterName();
            if (para.getParameter() == null) continue;
            if (name.equals("ConsolidateDocument")) {
                this.p_ConsolidateDocument = para.getParameterAsBoolean();
                continue;
            }
            if (name.equals("DocAction")) {
                this.p_docAction = para.getParameterAsString();
                continue;
            }
            if (name.equals("isExcludePriceRateProducts")) {
                this.p_isExcludePriceRateProducts = para.getParameterAsBoolean();
                continue;
            }
            if (name.equals("DateInvoiced")) {
                this.p_DateInvoiced = para.getParameterAsTimestamp();
                continue;
            }
            if (name.equals("C_Invoice_ID")) {
                this.P_C_Invoice_ID = para.getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        if (this.p_DateInvoiced == null) {
            this.p_DateInvoiced = Env.getContextAsDate(this.getCtx(), "#Date");
        }
        if (this.p_DateInvoiced == null) {
            this.p_DateInvoiced = new Timestamp(System.currentTimeMillis());
        }
    }

    @Override
    protected String doIt() throws Exception {
        StringBuffer orderClause = new StringBuffer();
        if (!this.p_ConsolidateDocument) {
            orderClause.append("C_BPartner_ID, C_Project_ID, c_doctypetarget_ID");
        } else {
            orderClause.append("C_BPartner_ID");
        }
        String whereClause = "DocStatus='CO' AND IsSOTrx='Y' AND C_Order_ID IN" + this.getSelectionKeys().toString().replace('[', '(').replace(']', ')');
        this.m_records = new Query(this.getCtx(), "C_Order", whereClause, this.get_TrxName()).setOrderBy(orderClause.toString()).setClient_ID().list();
        int ordercount = this.m_records.size();
        this.m_invoices = new ArrayList<MInvoice>();
        for (MOrder order : this.m_records) {
            try {
                this.CompleteOrder(order);
            }
            catch (Exception e) {
                ++this.errorcount;
                this.error = this.error + order.getDocumentNo();
            }
        }
        if (this.error != "") {
            return this.error;
        }
        for (MOrder order : this.m_records) {
            try {
                this.generate(order);
            }
            catch (Exception e) {
                ++this.errorcount;
                this.error = this.error + order.getDocumentNo();
            }
        }
        this.completeInvoice();
        Object result = "Fact. No";
        Object whereClauseWindow = "c_invoice_ID in (";
        for (MInvoice inv : this.m_invoices) {
            this.correctInvoice(inv);
            whereClauseWindow = (String)whereClauseWindow + inv.getC_Invoice_ID() + ",";
            result = (String)result + ", " + inv.getDocumentInfo();
        }
        result = (String)result + " Ordenes proc.: " + ordercount + " errores:" + this.errorcount;
        whereClauseWindow = ((String)whereClauseWindow).substring(0, ((String)whereClauseWindow).length() - 1) + ")";
        MQuery query = new MQuery("");
        MTable table = new MTable(this.getCtx(), MInvoice.Table_ID, this.get_TrxName());
        query.addRestriction((String)whereClauseWindow);
        query.setRecordCount(this.m_invoices.size());
        int AD_WindowNo = table.getAD_Window_ID();
        int ad_session_ID = Env.getContextAsInt(this.getCtx(), "AD_Session_ID");
        MSession session = new MSession(this.getCtx(), ad_session_ID, null);
        if (session.getWebSession() != null && session.getWebSession().length() != 0) {
            return result;
        }
        return result;
    }

    private String generate(MOrder order) throws Exception {
        boolean doInvoice;
        if (order.getDocStatus().equals("DR") || order.getDocStatus().equals("IP")) {
            order.setDocAction("CO");
            if (!order.processIt("CO")) {
                String status = Msg.parseTranslation(this.getCtx(), order.getProcessMsg());
                this.log.warning("No fue posible completar la orden ");
                return "No fue posible completar la orden #: " + order.getDocumentNo() + " " + status;
            }
            order.setDocAction("CL");
            order.setDocStatus("CO");
            order.saveEx();
        }
        if (order.getC_DocType().getDocSubTypeSO().equals("WI")) {
            MInvoice inv = (MInvoice)new Query(this.getCtx(), "C_Invoice", "c_order_ID=?", this.get_TrxName()).setParameters(order.getC_Order_ID()).first();
            if (inv == null) {
                throw new IllegalStateException("Orden al cr\ufffddito completada (" + order.getDocumentNo() + "), pero sin factura!!");
            }
            this.m_invoices.add(inv);
        }
        if (!this.p_ConsolidateDocument || this.m_invoice != null && this.m_invoice.getC_BPartner_ID() != order.getC_BPartner_ID()) {
            this.completeInvoice();
        }
        if ((doInvoice = false) || "D".equals(order.getInvoiceRule()) || "I".equals(order.getInvoiceRule())) {
            MDocType dt = (MDocType)order.getC_DocTypeTarget();
            this.createShipment(order, dt, null);
        }
        MInOut[] shipments = order.getShipments();
        for (int i = 0; i < shipments.length; ++i) {
            MInOut ship = shipments[i];
            if (!ship.isComplete() || ship.getDocStatus().equals("RE")) continue;
            MInOutLine[] shipLines = ship.getLines(true);
            for (int j = 0; j < shipLines.length; ++j) {
                MInOutLine shipLine = shipLines[j];
                if (this.p_isExcludePriceRateProducts.booleanValue() && this.isProductOfPriceRate(shipLine).booleanValue()) continue;
                shipLine.getC_OrderLine().getQtyInvoiced();
                if (!order.isOrderLine(shipLine.getC_OrderLine_ID())) continue;
                Boolean isInvoiced = shipLine.isInvoiced();
                if (shipLine.getC_OrderLine_ID() != 0 && shipLine.getC_OrderLine().getQtyInvoiced().compareTo(shipLine.getC_OrderLine().getQtyOrdered()) != 0) {
                    isInvoiced = false;
                }
                if (isInvoiced.booleanValue()) continue;
                this.createLine(order, ship, shipLine);
            }
            this.m_line += 10;
        }
        return "";
    }

    private void createLine(MOrder order, MOrderLine orderLine, BigDecimal qtyInvoiced, BigDecimal qtyEntered) {
        if (this.m_invoice == null) {
            this.m_invoice = new MInvoice(order, 0, this.p_DateInvoiced);
            this.m_invoice.setDescription(order.getC_Project().getValue() + "/");
            this.m_invoice.set_ValueOfColumn("DocumentoDeTransporte", order.get_Value("DocumentoDeTransporte"));
            this.m_invoice.set_ValueOfColumn("CodigoDeDeclaracion", order.get_Value("CodigoDeDeclaracion"));
            this.m_invoice.set_ValueOfColumn("ReferenciaDeDeclaracion", order.get_Value("ReferenciaDeDeclaracion"));
            String ProviderPO = order.get_ValueAsString("ProviderPO");
            Object ProviderPOField = this.m_invoice.get_ValueAsString("ProviderPO");
            if (!((String)ProviderPOField).contains(ProviderPO)) {
                ProviderPOField = (String)ProviderPOField + ", " + order.get_ValueAsString("ProviderPO");
            }
            this.m_invoice.set_ValueOfColumn("Provider", ProviderPOField);
            this.m_invoice.saveEx();
            this.m_invoices.add(this.m_invoice);
            this.m_line = 0;
        } else if (!this.m_invoice.getDescription().contains(order.getC_Project().getValue())) {
            this.m_invoice.setDescription(this.m_invoice.getDescription() + order.getC_Project().getValue() + "/");
            this.m_invoice.saveEx();
        }
        MInvoiceLine line = new MInvoiceLine(this.m_invoice);
        line.setOrderLine(orderLine);
        line.setQtyInvoiced(qtyInvoiced);
        line.setQtyEntered(qtyEntered);
        line.setC_Project_ID(orderLine.getC_Project_ID());
        this.m_line += 10;
        line.setLine(this.m_line);
        line.saveEx();
        this.log.fine(line.toString());
    }

    private void createLine(MOrder order, MInOut ship, MInOutLine sLine) {
        if (this.m_invoice == null) {
            if (this.P_C_Invoice_ID != 0) {
                this.m_invoice = new MInvoice(this.getCtx(), this.P_C_Invoice_ID, this.get_TrxName());
            } else {
                this.m_invoice = new MInvoice(order, 0, this.p_DateInvoiced);
                this.m_invoice.setDescription(order.getC_Project().getValue() + "/");
                if (order.getPaymentRule() != "" || order.getPaymentRule() != null) {
                    this.m_invoice.setPaymentRule(order.getPaymentRule());
                }
                if (order.getC_PaymentTerm_ID() > 0) {
                    this.m_invoice.setC_PaymentTerm_ID(order.getC_PaymentTerm_ID());
                }
                this.m_invoice.saveEx();
            }
            this.m_invoice.set_ValueOfColumn("DocumentoDeTransporte", order.get_Value("DocumentoDeTransporte"));
            this.m_invoice.set_ValueOfColumn("CodigoDeDeclaracion", order.get_Value("CodigoDeDeclaracion"));
            this.m_invoice.set_ValueOfColumn("ReferenciaDeDeclaracion", order.get_Value("ReferenciaDeDeclaracion"));
            String ProviderPO = order.get_ValueAsString("ProviderPO");
            Object ProviderPOField = this.m_invoice.get_ValueAsString("ProviderPO");
            if (!((String)ProviderPOField).contains(ProviderPO)) {
                ProviderPOField = (String)ProviderPOField + ", " + order.get_ValueAsString("ProviderPO");
            }
            this.m_invoice.set_ValueOfColumn("Provider", ProviderPOField);
            this.m_invoice.saveEx();
            this.m_invoices.add(this.m_invoice);
        } else if (!this.m_invoice.getDescription().contains(order.getC_Project().getValue())) {
            this.m_invoice.setDescription(this.m_invoice.getDescription() + order.getC_Project().getValue() + "/");
            this.m_invoice.saveEx();
        }
        if (this.m_ship == null || this.m_ship.getM_InOut_ID() != ship.getM_InOut_ID()) {
            if (this.m_bp == null || this.m_bp.getC_BPartner_ID() != ship.getC_BPartner_ID()) {
                this.m_bp = new MBPartner(this.getCtx(), ship.getC_BPartner_ID(), this.get_TrxName());
            }
            MClient client = MClient.get(this.getCtx(), order.getAD_Client_ID());
            String AD_Language = client.getAD_Language();
            if (client.isMultiLingualDocument() && this.m_bp.getAD_Language() != null) {
                AD_Language = this.m_bp.getAD_Language();
            }
            if (AD_Language == null) {
                AD_Language = Language.getBaseAD_Language();
            }
            SimpleDateFormat format = DisplayType.getDateFormat(15, Language.getLanguage(AD_Language));
            this.m_ship = ship;
        }
        if (this.oLineExists(sLine).booleanValue()) {
            return;
        }
        Boolean isRateProduct = this.IsRateProduct(sLine);
        BigDecimal qtyInvoiced = sLine.getMovementQty();
        BigDecimal qtyentered = sLine.getC_OrderLine().getQtyEntered();
        Integer repeat = 1;
        if (isRateProduct.booleanValue()) {
            qtyInvoiced = Env.ONE;
            repeat = sLine.getMovementQty().intValue();
            qtyentered = Env.ONE;
        }
        for (int j = 0; j < repeat; ++j) {
            MInvoiceLine iLine = new MInvoiceLine(this.m_invoice);
            iLine.setShipLine(sLine);
            if (sLine.sameOrderLineUOM()) {
                iLine.setQtyEntered(qtyentered);
            } else {
                iLine.setQtyEntered(qtyentered);
            }
            iLine.setQtyInvoiced(qtyInvoiced);
            if (!iLine.save(this.get_TrxName())) {
                throw new IllegalStateException("Could not create Shipment Line");
            }
            this.log.fine(iLine.toString());
            this.m_invoice.saveEx();
        }
        sLine.setIsInvoiced(true);
        if (!sLine.save()) {
            throw new IllegalStateException("Could not update Shipment Line");
        }
    }

    private void completeInvoice() {
        if (this.m_invoice != null) {
            this.m_invoice.set_ValueOfColumn("isSplitInvoice", (Object)true);
            this.SplitInvoice();
            if (this.m_invoice.getLines(true).length == 0) {
                this.m_invoice.setC_Order_ID(0);
                this.m_invoice.delete(true);
                this.m_invoice = null;
                this.m_ship = null;
                this.m_line = 0;
                return;
            }
            if ((this.p_docAction.equals("CO") || this.p_docAction.equals("PR")) && !this.m_invoice.processIt(this.p_docAction)) {
                this.log.warning("completeInvoice - failed: " + this.m_invoice);
                this.addLog("completeInvoice - failed: " + this.m_invoice);
            }
            this.m_invoice.saveEx();
            this.addLog(this.m_invoice.getC_Invoice_ID(), this.m_invoice.getDateInvoiced(), null, this.m_invoice.getDocumentNo());
            ++this.m_created;
        }
        this.m_invoice = null;
        this.m_ship = null;
        this.m_line = 0;
    }

    private void correctInvoice(MInvoice inv) {
        boolean oneProjectInvoice = true;
        List ivlList = new Query(this.getCtx(), "C_InvoiceLine", "C_Invoice_ID=?", this.get_TrxName()).setParameters(inv.getC_Invoice_ID()).setOrderBy("C_Project_ID").list();
        if (ivlList.isEmpty()) {
            return;
        }
        int C_Project_ID = ((MInvoiceLine)ivlList.get(0)).getC_Project_ID();
        for (MInvoiceLine ivl : ivlList) {
            if (C_Project_ID == ivl.getC_Project_ID()) continue;
            inv.set_ValueOfColumn("oneProjectInvoice", (Object)false);
            oneProjectInvoice = false;
            break;
        }
        if (oneProjectInvoice) {
            inv.setDescription("");
        } else {
            inv.setC_Order_ID(0);
            inv.setC_Project_ID(0);
        }
        inv.saveEx();
    }

    private MInOut createShipment(MOrder order, MDocType dt, Timestamp movementDate) {
        this.log.info("For " + dt);
        MInOut shipment = new MInOut(order, dt.getC_DocTypeShipment_ID(), movementDate);
        if (!shipment.save(this.get_TrxName())) {
            return null;
        }
        MOrderLine[] oLines = order.getLines(true, null);
        for (int i = 0; i < oLines.length; ++i) {
            BigDecimal MovementQty;
            MOrderLine oLine = oLines[i];
            if (this.p_isExcludePriceRateProducts.booleanValue() && this.isProductOfPriceRate(oLine).booleanValue() || (MovementQty = oLine.getQtyOrdered().subtract(oLine.getQtyDelivered())).compareTo(Env.ZERO) == 0) continue;
            MInOutLine ioLine = new MInOutLine(shipment);
            int M_Locator_ID = MStorage.getM_Locator_ID(oLine.getM_Warehouse_ID(), oLine.getM_Product_ID(), oLine.getM_AttributeSetInstance_ID(), MovementQty, this.get_TrxName());
            if (M_Locator_ID == 0) {
                MWarehouse wh = MWarehouse.get(this.getCtx(), oLine.getM_Warehouse_ID());
                M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
            }
            ioLine.setOrderLine(oLine, M_Locator_ID, MovementQty);
            ioLine.setQty(MovementQty);
            ioLine.setC_Project_ID(oLine.getC_Project_ID());
            if (oLine.getQtyEntered().compareTo(oLine.getQtyOrdered()) != 0) {
                ioLine.setQtyEntered(MovementQty.multiply(oLine.getQtyEntered()).divide(oLine.getQtyOrdered(), 6, 4));
            }
            if (ioLine.save(this.get_TrxName())) continue;
            return null;
        }
        MInOutLine[] lines = shipment.getLines(true);
        if (lines == null || lines.length == 0) {
            shipment.deleteEx(true);
            return null;
        }
        if (!shipment.processIt("CO")) {
            throw new AdempiereException("Error al procesar entrega " + order.getDocumentNo());
        }
        shipment.saveEx(this.get_TrxName());
        if (!"CO".equals(shipment.getDocStatus())) {
            return null;
        }
        return shipment;
    }

    private String SplitInvoice() {
        Boolean isSplitInvoice = this.m_invoice.get_ValueAsBoolean("isSplitInvoice");
        if (!isSplitInvoice.booleanValue()) {
            this.m_invoice.renumberLines(10);
            return "";
        }
        MDocType dt = (MDocType)this.m_invoice.getC_DocType();
        if (dt.get_ValueAsBoolean("isSplitInvoice")) {
            return "";
        }
        int c_doctype_ID = new Query(this.getCtx(), "C_DocType", "isSplitInvoice ='Y'", this.get_TrxName()).setOnlyActiveRecords(true).setClient_ID().firstId();
        MInvoice NdD = new MInvoice((MOrder)this.m_invoice.getC_Order(), c_doctype_ID, this.m_invoice.getDateInvoiced());
        NdD.saveEx();
        for (MInvoiceLine ivl : this.m_invoice.getLines(true)) {
            MOrderLine oLine;
            if (ivl.getC_OrderLine_ID() <= 0 || !(oLine = (MOrderLine)ivl.getC_OrderLine()).get_ValueAsBoolean("isSplitInvoice")) continue;
            ivl.setC_Invoice_ID(NdD.getC_Invoice_ID());
            ivl.saveEx();
        }
        this.m_invoice.saveEx();
        this.m_invoice.renumberLines(10);
        NdD.saveEx();
        if (NdD.getLines(true).length == 0) {
            NdD.setC_Order_ID(0);
            NdD.delete(true);
        } else {
            NdD.renumberLines(10);
            if (NdD.processIt(this.p_docAction)) {
                NdD.setDocAction("CO");
                NdD.saveEx();
                this.m_invoices.add(NdD);
            }
        }
        return "";
    }

    private Boolean isProductOfPriceRate(MOrderLine oLine) {
        String sql = "select count(*) from lg_productpricerate where isvalid = 'Y' and (c_bpartner_ID = ? or c_bpartner_ID is null) and lg_ratetype = 'G' and m_pricelist_ID = ?  and  exists (select 1 from lg_productpricerateline where m_product_id = ?) ";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(oLine.getC_Order().getC_BPartner_ID());
        params.add(oLine.getC_Order().getM_PriceList_ID());
        params.add(oLine.getM_Product_ID());
        int no = DB.getSQLValueEx(oLine.get_TrxName(), sql, params);
        if (no <= 0) {
            return false;
        }
        return true;
    }

    private Boolean isProductOfPriceRate(MInOutLine oLine) {
        String sql = "select count(*) from lg_productpricerate where isvalid = 'Y' and (c_bpartner_ID = ? or c_bpartner_ID is null) and lg_ratetype = 'G' and m_pricelist_ID = ?  and  exists (select 1 from lg_productpricerateline where m_product_id = ?) ";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(oLine.getM_InOut().getC_BPartner_ID());
        params.add(oLine.getC_OrderLine().getC_Order().getM_PriceList_ID());
        params.add(oLine.getM_Product_ID());
        int no = DB.getSQLValueEx(oLine.get_TrxName(), sql, params);
        if (no <= 0) {
            return false;
        }
        return true;
    }

    private Boolean IsRateProduct(MInOutLine ioLine) {
        if (ioLine.getM_Product_ID() <= 0) {
            return false;
        }
        String whereClause = "isvalid = 'Y' and (c_bpartner_ID = ? or c_bpartner_ID is null) and LG_RateType = 'G' and m_pricelist_ID = ?  and  exists (select 1 from lg_productpricerateline where m_product_id = ?) ";
        ArrayList<Object> param1 = new ArrayList<Object>();
        param1.add(ioLine.getM_InOut().getC_BPartner_ID());
        param1.add(ioLine.getC_OrderLine().getC_Order().getM_PriceList_ID());
        param1.add(ioLine.getM_Product_ID());
        MLGProductPriceRate pprl = (MLGProductPriceRate)new Query(this.getCtx(), "LG_ProductPriceRate", whereClause, this.get_TrxName()).setOnlyActiveRecords(true).setParameters(param1).first();
        if (pprl == null) {
            return false;
        }
        return true;
    }

    private Boolean oLineExists(MInOutLine ioLine) {
        if (this.m_invoice == null) {
            return false;
        }
        for (MInvoiceLine ivl : this.m_invoice.getLines(true)) {
            if (ivl.getC_OrderLine_ID() != ioLine.getC_OrderLine_ID()) continue;
            return true;
        }
        return false;
    }

    private String CompleteOrder(MOrder order) {
        if (order.getDocStatus().equals("DR") || order.getDocStatus().equals("IP")) {
            order.setDocAction("CO");
            if (!order.processIt("CO")) {
                this.log.warning("No fue posible completar la orden ");
                throw new IllegalStateException("No fue posible completar la orden #: " + order.getDocumentNo());
            }
            order.setDocAction("CL");
            order.setDocStatus("CO");
            order.saveEx();
        }
        return "";
    }
}

