/*
 * Decompiled with CFR 0.152.
 */
package org.shw.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProject;
import org.compiere.model.MStorage;
import org.compiere.model.MWarehouse;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Language;

public class SHW_InvoiceGenerateFromOrderLine
extends SvrProcess {
    private Timestamp p_DateInvoiced = null;
    private boolean p_ConsolidateDocument = true;
    private String p_docAction = "";
    private MInvoice m_invoice = null;
    private MInOut m_ship = null;
    private int m_created = 0;
    private int m_line = 0;
    private MBPartner m_bp = null;
    protected List<MOrderLine> m_records = null;
    protected List<MInvoice> m_invoices = null;
    protected List<MOrder> ordersToInvoice = null;
    protected List<MInOut> shipments = null;
    protected MInOut m_shipment = null;
    private MOrder m_order = null;
    private Boolean IsSoTrx = false;
    private int P_C_Invoice_ID = 0;
    private String alias = "";
    private int errorcount = 0;
    private String error = "";
    private int successcount = 0;
    private int ordercount = 0;
    private int p_C_Doctype_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] parameters;
        for (ProcessInfoParameter para : parameters = this.getParameter()) {
            String name = para.getParameterName();
            if (para.getParameter() == null) continue;
            if (name.equals("ConsolidateDocument")) {
                this.p_ConsolidateDocument = para.getParameterAsBoolean();
                continue;
            }
            if (name.equals("DocAction")) {
                this.p_docAction = para.getParameterAsString();
                continue;
            }
            if (name.equals("DateInvoiced")) {
                this.p_DateInvoiced = para.getParameterAsTimestamp();
                continue;
            }
            if (name.equals("Alias")) {
                this.alias = para.getParameterAsString();
                continue;
            }
            if (name.equals("C_Invoice_ID")) {
                this.P_C_Invoice_ID = para.getParameterAsInt();
                continue;
            }
            if (name.equals("C_DocType_ID")) {
                this.p_C_Doctype_ID = para.getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        if (this.p_DateInvoiced == null) {
            this.p_DateInvoiced = Env.getContextAsDate(this.getCtx(), "#Date");
        }
        if (this.p_DateInvoiced == null) {
            this.p_DateInvoiced = new Timestamp(System.currentTimeMillis());
        }
    }

    @Override
    protected String doIt() throws Exception {
        StringBuffer orderClause = new StringBuffer();
        if (!this.p_ConsolidateDocument) {
            orderClause.append("C_BPartner_ID, C_Project_ID, c_doctypetarget_ID");
        } else {
            orderClause.append("C_BPartner_ID");
        }
        String whereClause = "(C_OrderLine_ID in " + this.getSelectionKeys().toString().replace('[', '(').replace(']', ')') + ")";
        this.m_records = new Query(this.getCtx(), "C_OrderLine", whereClause, this.get_TrxName()).setOrderBy(orderClause.toString()).setClient_ID().list();
        this.m_invoices = new ArrayList<MInvoice>();
        this.ordersToInvoice = new ArrayList<MOrder>();
        this.shipments = new ArrayList<MInOut>();
        for (MOrderLine orderLine : this.m_records) {
            this.m_order = (MOrder)orderLine.getC_Order();
            Boolean isadded = false;
            for (MOrder order : this.ordersToInvoice) {
                if (order.getC_Order_ID() != this.m_order.getC_Order_ID()) continue;
                isadded = true;
                break;
            }
            if (isadded.booleanValue()) continue;
            this.ordersToInvoice.add(this.m_order);
        }
        for (MOrder order : this.ordersToInvoice) {
            try {
                this.generate(order);
            }
            catch (Exception e) {
                ++this.errorcount;
                this.error = this.error + order.getDocumentNo();
            }
        }
        this.completeInvoice();
        Object result = "Fact. No";
        for (MInvoice inv : this.m_invoices) {
            Env.setContext(this.getCtx(), "@WhereClause@", whereClause);
            result = (String)result + ", " + inv.getDocumentInfo();
        }
        return result;
    }

    private String generate(MOrder order) throws Exception {
        this.shipments = new ArrayList<MInOut>();
        this.shipments = new Query(this.getCtx(), "M_InOut", "C_Order_ID=? and docstatus in ('CO','CL')", this.get_TrxName()).setParameters(order.getC_Order_ID()).list();
        this.createShipment(order, null);
        for (MInOut ship : this.shipments) {
            if (!ship.isComplete() || ship.getDocStatus().equals("RE")) continue;
            MInOutLine[] shipLines = ship.getLines(true);
            for (int j = 0; j < shipLines.length; ++j) {
                MInOutLine shipLine = shipLines[j];
                MOrderLine oLine = (MOrderLine)shipLine.getC_OrderLine();
                if (oLine == null || !this.m_records.contains(oLine)) continue;
                Boolean isInvoiced = shipLine.isInvoiced();
                if (shipLine.getC_OrderLine_ID() != 0 && shipLine.getC_OrderLine().getQtyInvoiced().compareTo(shipLine.getC_OrderLine().getQtyOrdered()) != 0) {
                    isInvoiced = false;
                }
                shipLine.getC_OrderLine().getQtyInvoiced();
                if (isInvoiced.booleanValue()) continue;
                this.createLine(this.m_order, ship, shipLine);
            }
            this.m_line += 10;
        }
        return "";
    }

    private void createLine(MOrder order, MInOut ship, MInOutLine sLine) {
        if (this.m_invoice == null) {
            if (this.P_C_Invoice_ID != 0) {
                this.m_invoice = new MInvoice(this.getCtx(), this.P_C_Invoice_ID, this.get_TrxName());
            } else {
                this.m_invoice = new MInvoice(order, 0, this.p_DateInvoiced);
                this.m_invoice.setDescription(order.getC_Project().getValue() + "/");
                if (order.getPaymentRule() != "" || order.getPaymentRule() != null) {
                    this.m_invoice.setPaymentRule(order.getPaymentRule());
                }
                if (order.getC_PaymentTerm_ID() > 0) {
                    this.m_invoice.setC_PaymentTerm_ID(order.getC_PaymentTerm_ID());
                }
                if (this.p_C_Doctype_ID != 0) {
                    this.m_invoice.setC_DocTypeTarget_ID(this.p_C_Doctype_ID);
                }
                this.m_invoice.saveEx();
            }
        } else if (!this.m_invoice.getDescription().contains(order.getC_Project().getValue())) {
            this.m_invoice.setDescription(this.m_invoice.getDescription() + " " + order.getC_Project().getValue() + "/");
            this.m_invoice.saveEx();
        }
        if (this.m_ship == null || this.m_ship.getM_InOut_ID() != ship.getM_InOut_ID()) {
            if (this.m_bp == null || this.m_bp.getC_BPartner_ID() != ship.getC_BPartner_ID()) {
                this.m_bp = new MBPartner(this.getCtx(), ship.getC_BPartner_ID(), this.get_TrxName());
            }
            MClient client = MClient.get(this.getCtx(), order.getAD_Client_ID());
            String AD_Language = client.getAD_Language();
            if (client.isMultiLingualDocument() && this.m_bp.getAD_Language() != null) {
                AD_Language = this.m_bp.getAD_Language();
            }
            if (AD_Language == null) {
                AD_Language = Language.getBaseAD_Language();
            }
            this.m_ship = ship;
        }
        BigDecimal qtyToInvoice = sLine.getMovementQty();
        BigDecimal qtyentered = sLine.getC_OrderLine().getQtyEntered();
        Integer repeat = 1;
        for (int j = 0; j < repeat; ++j) {
            MInvoiceLine iLine = new MInvoiceLine(this.m_invoice);
            iLine.setShipLine(sLine);
            if (sLine.sameOrderLineUOM()) {
                iLine.setQtyEntered(qtyToInvoice);
            } else {
                iLine.setQtyEntered(qtyToInvoice);
            }
            iLine.setQtyInvoiced(qtyToInvoice);
            if (iLine.getUser1_ID() == 0) {
                MProject pr = (MProject)iLine.getC_Project();
                iLine.setUser1_ID(pr.get_ValueAsInt("User1_ID"));
            }
            if (!iLine.save(this.get_TrxName())) {
                throw new IllegalStateException("Could not create Invoice Line");
            }
            this.log.fine(iLine.toString());
        }
        sLine.setIsInvoiced(true);
        if (!sLine.save()) {
            throw new IllegalStateException("Could not update Shipment Line");
        }
        Boolean isadded = false;
        for (MInvoice inv : this.m_invoices) {
            if (inv.getC_Invoice_ID() != this.m_invoice.getC_Invoice_ID()) continue;
            isadded = true;
            break;
        }
        if (!isadded.booleanValue()) {
            this.m_invoices.add(this.m_invoice);
        }
    }

    private void completeInvoice() {
        if (this.m_invoice != null) {
            if (this.m_invoice.isSOTrx()) {
                this.m_invoice.set_ValueOfColumn("isSplitInvoice", (Object)true);
            }
            this.SplitInvoice();
            if (this.m_invoice.getLines(true).length == 0) {
                this.m_invoice.setC_Order_ID(0);
                this.m_invoice.delete(true);
                this.m_invoice = null;
                this.m_ship = null;
                this.m_line = 0;
                return;
            }
            if ((this.p_docAction.equals("CO") || this.p_docAction.equals("PR")) && !this.m_invoice.processIt(this.p_docAction)) {
                this.log.warning("completeInvoice - failed: " + this.m_invoice);
                this.addLog("completeInvoice - failed: " + this.m_invoice);
            }
            this.m_invoice.saveEx();
            this.addLog(this.m_invoice.getC_Invoice_ID(), this.m_invoice.getDateInvoiced(), null, this.m_invoice.getDocumentNo());
            ++this.m_created;
        }
        this.m_invoice = null;
        this.m_ship = null;
        this.m_line = 0;
    }

    private MInOut createShipment(MOrder order, Timestamp movementDate) {
        MInOut shipment = new MInOut(order, order.getC_DocType().getC_DocTypeShipment_ID(), movementDate);
        if (!shipment.save(this.get_TrxName())) {
            return null;
        }
        for (MOrderLine oLine : this.m_records) {
            if (oLine.getC_Order_ID() != order.getC_Order_ID()) continue;
            BigDecimal MovementQty = oLine.getQtyOrdered().subtract(oLine.getQtyDelivered());
            BigDecimal qtyTodeliver = this.getSelectionAsBigDecimal(oLine.get_ID(), "ODT_QtyToDeliver");
            if (qtyTodeliver.compareTo(MovementQty) < 0) {
                MovementQty = qtyTodeliver;
            }
            if (MovementQty.compareTo(Env.ZERO) == 0) continue;
            MInOutLine ioLine = new MInOutLine(shipment);
            int M_Locator_ID = MStorage.getM_Locator_ID(oLine.getM_Warehouse_ID(), oLine.getM_Product_ID(), oLine.getM_AttributeSetInstance_ID(), MovementQty, this.get_TrxName());
            if (M_Locator_ID == 0) {
                MWarehouse wh = MWarehouse.get(this.getCtx(), oLine.getM_Warehouse_ID());
                M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
            }
            ioLine.setOrderLine(oLine, M_Locator_ID, MovementQty);
            ioLine.setQty(MovementQty);
            ioLine.setC_Project_ID(oLine.getC_Project_ID());
            if (oLine.getQtyEntered().compareTo(oLine.getQtyOrdered()) != 0) {
                ioLine.setQtyEntered(MovementQty.multiply(oLine.getQtyEntered()).divide(oLine.getQtyOrdered(), 6, 4));
            }
            if (ioLine.save(this.get_TrxName())) continue;
            return null;
        }
        MInOutLine[] lines = shipment.getLines(true);
        if (lines == null || lines.length == 0) {
            shipment.deleteEx(true);
            return null;
        }
        if (!shipment.processIt("CO")) {
            throw new AdempiereException("Error al procesar entrega " + order.getDocumentNo());
        }
        shipment.saveEx(this.get_TrxName());
        if (!"CO".equals(shipment.getDocStatus())) {
            return null;
        }
        this.shipments.add(shipment);
        return shipment;
    }

    private String SplitInvoice() {
        Boolean isSplitInvoice = this.m_invoice.get_ValueAsBoolean("isSplitInvoice");
        if (!isSplitInvoice.booleanValue()) {
            this.m_invoice.renumberLines(10);
            return "";
        }
        MDocType dt = (MDocType)this.m_invoice.getC_DocType();
        if (dt.get_ValueAsBoolean("isSplitInvoice")) {
            return "";
        }
        int c_doctype_ID = new Query(this.getCtx(), "C_DocType", "isSplitInvoice ='Y'", this.get_TrxName()).setOnlyActiveRecords(true).setClient_ID().firstId();
        MInvoice NdD = new MInvoice((MOrder)this.m_invoice.getC_Order(), c_doctype_ID, this.m_invoice.getDateInvoiced());
        NdD.saveEx();
        for (MInvoiceLine ivl : this.m_invoice.getLines(true)) {
            MOrderLine oLine;
            if (ivl.getC_OrderLine_ID() <= 0 || !(oLine = (MOrderLine)ivl.getC_OrderLine()).get_ValueAsBoolean("isSplitInvoice")) continue;
            ivl.setC_Invoice_ID(NdD.getC_Invoice_ID());
            ivl.saveEx();
        }
        this.m_invoice.saveEx();
        this.m_invoice.renumberLines(10);
        NdD.saveEx();
        if (NdD.getLines(true).length == 0) {
            NdD.setC_Order_ID(0);
            NdD.delete(true);
        } else {
            NdD.renumberLines(10);
            if (NdD.processIt(this.p_docAction)) {
                NdD.setDocAction("CO");
                NdD.saveEx();
                this.m_invoices.add(NdD);
            }
        }
        return "";
    }
}

