/*
 * Decompiled with CFR 0.152.
 */
package org.shw.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MStorage;
import org.compiere.model.MWarehouse;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;

public class SHW_InvoiceGeneratePurchase
extends SvrProcess {
    private Timestamp p_DateInvoiced = null;
    private boolean p_ConsolidateDocument = true;
    private String p_docAction = "";
    private MInvoice m_invoice = null;
    private MInOut m_ship = null;
    private int m_created = 0;
    private int m_line = 0;
    private MBPartner m_bp = null;
    private int p_C_Invoice_ID = 0;
    protected List<MOrder> m_records = null;
    protected List<MInvoice> m_invoices = null;
    private String error = "";
    private int errorcount = 0;
    private int successcount = 0;
    private int ordercount = 0;
    private int p_C_Doctype_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] parameters;
        for (ProcessInfoParameter para : parameters = this.getParameter()) {
            String name = para.getParameterName();
            if (para.getParameter() == null) continue;
            if (name.equals("ConsolidateDocument")) {
                this.p_ConsolidateDocument = para.getParameterAsBoolean();
                continue;
            }
            if (name.equals("DocAction")) {
                this.p_docAction = para.getParameterAsString();
                continue;
            }
            if (name.equals("C_Invoice_ID")) {
                this.p_C_Invoice_ID = para.getParameterAsInt();
                continue;
            }
            if (name.equals("DateInvoiced")) {
                this.p_DateInvoiced = para.getParameterAsTimestamp();
                continue;
            }
            if (name.equals("C_DocType_ID")) {
                this.p_C_Doctype_ID = para.getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        if (this.p_DateInvoiced == null) {
            this.p_DateInvoiced = Env.getContextAsDate(this.getCtx(), "#Date");
        }
        if (this.p_DateInvoiced == null) {
            this.p_DateInvoiced = new Timestamp(System.currentTimeMillis());
        }
    }

    @Override
    protected String doIt() throws Exception {
        String whereClause = "";
        if (this.getRecord_ID() != 0) {
            MOrder order = new MOrder(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
            this.m_records = new ArrayList<MOrder>();
            this.m_records.add(order);
        } else {
            StringBuffer orderClause = new StringBuffer();
            if (!this.p_ConsolidateDocument) {
                orderClause.append("C_BPartner_ID, C_Project_ID, c_doctypetarget_ID");
            } else {
                orderClause.append("C_BPartner_ID");
            }
            whereClause = "EXISTS (SELECT T_Selection_ID FROM T_Selection WHERE  T_Selection.AD_PInstance_ID=?  AND T_Selection.T_Selection_ID=c_order.C_Order_ID)";
            this.m_records = new Query(this.getCtx(), "C_Order", whereClause, this.get_TrxName()).setParameters(this.getAD_PInstance_ID()).setOrderBy(orderClause.toString()).setClient_ID().list();
        }
        this.ordercount = this.m_records.size();
        this.m_invoices = new ArrayList<MInvoice>();
        for (MOrder order : this.m_records) {
            try {
                this.generate(order);
            }
            catch (Exception e) {
                ++this.errorcount;
                this.error = this.error + "," + order.getDocumentNo();
            }
        }
        this.completeInvoice();
        Object result = "Fact. No";
        for (MInvoice inv : this.m_invoices) {
            Env.setContext(this.getCtx(), "@WhereClause@", whereClause);
            result = (String)result + ", " + inv.getDocumentInfo();
        }
        result = (String)result + " Ordenes proc.: " + this.ordercount + " errores:" + this.errorcount;
        if (this.error.length() != 0) {
            result = (String)result + " " + this.error;
        }
        return result;
    }

    private String generate(MOrder order) throws Exception {
        if (!this.p_ConsolidateDocument || this.m_invoice != null && this.m_invoice.getC_BPartner_ID() != order.getC_BPartner_ID()) {
            this.completeInvoice();
        }
        MDocType dt = (MDocType)order.getC_DocTypeTarget();
        this.createShipment(order, dt, null);
        MInOut[] shipments = order.getShipments();
        for (int i = 0; i < shipments.length; ++i) {
            MInOut ship = shipments[i];
            if (!ship.isComplete() || ship.getDocStatus().equals("RE")) continue;
            MInOutLine[] shipLines = ship.getLines(true);
            for (int j = 0; j < shipLines.length; ++j) {
                MInOutLine shipLine = shipLines[j];
                Boolean isInvoiced = shipLine.isInvoiced();
                if (shipLine.getC_OrderLine_ID() != 0 && shipLine.getC_OrderLine().getQtyInvoiced().compareTo(shipLine.getC_OrderLine().getQtyOrdered()) != 0) {
                    isInvoiced = false;
                }
                if (!order.isOrderLine(shipLine.getC_OrderLine_ID()) || isInvoiced.booleanValue()) continue;
                this.createLine(order, ship, shipLine);
            }
            this.m_line += 10;
        }
        return "";
    }

    private void createLine(MOrder order, MOrderLine orderLine, BigDecimal qtyInvoiced, BigDecimal qtyEntered) {
        if (this.m_invoice == null) {
            this.m_invoice = new MInvoice(order, 0, this.p_DateInvoiced);
            if (this.p_C_Doctype_ID != 0) {
                this.m_invoice.setC_DocTypeTarget_ID(this.p_C_Doctype_ID);
            }
            this.m_invoice.setDescription(order.getC_Project().getValue() + "/");
            this.m_invoice.set_ValueOfColumn("DocumentoDeTransporte", order.get_Value("DocumentoDeTransporte"));
            this.m_invoice.set_ValueOfColumn("CodigoDeDeclaracion", order.get_Value("CodigoDeDeclaracion"));
            this.m_invoice.set_ValueOfColumn("ReferenciaDeDeclaracion", order.get_Value("ReferenciaDeDeclaracion"));
            String ProviderPO = order.get_ValueAsString("ProviderPO");
            Object ProviderPOField = this.m_invoice.get_ValueAsString("ProviderPO");
            if (!((String)ProviderPOField).contains(ProviderPO)) {
                ProviderPOField = (String)ProviderPOField + ", " + order.get_ValueAsString("ProviderPO");
            }
            this.m_invoice.set_ValueOfColumn("Provider", ProviderPOField);
            this.m_invoice.saveEx();
            this.m_invoices.add(this.m_invoice);
            this.m_line = 0;
        } else if (!this.m_invoice.getDescription().contains(order.getC_Project().getValue())) {
            this.m_invoice.setDescription(this.m_invoice.getDescription() + order.getC_Project().getValue() + "/");
            this.m_invoice.saveEx();
        }
        MInvoiceLine line = new MInvoiceLine(this.m_invoice);
        line.setOrderLine(orderLine);
        line.setQtyInvoiced(qtyInvoiced);
        line.setQtyEntered(qtyEntered);
        this.m_line += 10;
        line.setLine(this.m_line);
        line.saveEx();
        this.log.fine(line.toString());
    }

    private void createLine(MOrder order, MInOut ship, MInOutLine sLine) {
        if (this.m_invoice == null) {
            if (this.p_C_Invoice_ID != 0) {
                this.m_invoice = new MInvoice(this.getCtx(), this.p_C_Invoice_ID, this.get_TrxName());
            } else {
                this.m_invoice = new MInvoice(order, this.p_C_Invoice_ID, this.p_DateInvoiced);
                this.m_invoice.setDescription(order.getC_Project().getValue() + "/");
                if (order.getPaymentRule() != "" || order.getPaymentRule() != null) {
                    this.m_invoice.setPaymentRule(order.getPaymentRule());
                }
                if (order.getC_PaymentTerm_ID() > 0) {
                    this.m_invoice.setC_PaymentTerm_ID(order.getC_PaymentTerm_ID());
                }
                if (this.p_C_Doctype_ID != 0) {
                    this.m_invoice.setC_DocTypeTarget_ID(this.p_C_Doctype_ID);
                }
                this.m_invoice.saveEx();
            }
            this.m_invoices.add(this.m_invoice);
        } else if (order.getC_Project_ID() != 0 && !this.m_invoice.getDescription().contains(order.getC_Project().getValue())) {
            this.m_invoice.setDescription(this.m_invoice.getDescription() + order.getC_Project().getValue() + "/");
            this.m_invoice.saveEx();
        }
        if (this.m_ship == null || this.m_ship.getM_InOut_ID() != ship.getM_InOut_ID()) {
            MDocType dt = MDocType.get(this.getCtx(), ship.getC_DocType_ID());
            if (this.m_bp == null || this.m_bp.getC_BPartner_ID() != ship.getC_BPartner_ID()) {
                this.m_bp = new MBPartner(this.getCtx(), ship.getC_BPartner_ID(), this.get_TrxName());
            }
            MClient client = MClient.get(this.getCtx(), order.getAD_Client_ID());
            String AD_Language = client.getAD_Language();
            if (client.isMultiLingualDocument() && this.m_bp.getAD_Language() != null) {
                AD_Language = this.m_bp.getAD_Language();
            }
            if (AD_Language == null) {
                AD_Language = Language.getBaseAD_Language();
            }
            SimpleDateFormat format = DisplayType.getDateFormat(15, Language.getLanguage(AD_Language));
            String reference = dt.getPrintName(this.m_bp.getAD_Language()) + ": " + ship.getDocumentNo() + " - " + format.format(ship.getMovementDate());
            this.m_ship = ship;
        }
        if (this.oLineExists(sLine).booleanValue()) {
            return;
        }
        MInvoiceLine line = new MInvoiceLine(this.m_invoice);
        line.setShipLine(sLine);
        if (sLine.sameOrderLineUOM()) {
            line.setQtyEntered(sLine.getQtyEntered());
        } else {
            line.setQtyEntered(sLine.getMovementQty());
        }
        line.setQtyInvoiced(sLine.getMovementQty());
        this.m_line += 10;
        line.setLine(this.m_line);
        String toBeInvoiced = sLine.get_ValueAsString("ToBeInvoiced");
        if ("N".equals(toBeInvoiced)) {
            line.setPriceEntered(Env.ZERO);
            line.setPriceActual(Env.ZERO);
            line.setPriceLimit(Env.ZERO);
            line.setPriceList(Env.ZERO);
            line.setLineNetAmt(Env.ZERO);
            line.setIsDescription(true);
        }
        if (!line.save()) {
            throw new IllegalStateException("Could not create Invoice Line (s)");
        }
        sLine.setIsInvoiced(true);
        if (!sLine.save()) {
            throw new IllegalStateException("Could not update Shipment Line");
        }
        this.log.fine(line.toString());
        ++this.successcount;
    }

    private void completeInvoice() {
        if (this.m_invoice != null) {
            if (this.p_docAction.equals("")) {
                this.m_invoice.saveEx();
                this.addLog(this.m_invoice.getC_Invoice_ID(), this.m_invoice.getDateInvoiced(), null, this.m_invoice.getDocumentNo());
                ++this.m_created;
            } else if (!this.m_invoice.processIt(this.p_docAction)) {
                this.log.warning("completeInvoice - failed: " + this.m_invoice);
                this.addLog("completeInvoice - failed: " + this.m_invoice);
            }
            this.m_invoice.saveEx();
            this.addLog(this.m_invoice.getC_Invoice_ID(), this.m_invoice.getDateInvoiced(), null, this.m_invoice.getDocumentNo());
            ++this.m_created;
        }
        this.m_invoice = null;
        this.m_ship = null;
        this.m_line = 0;
    }

    private void correctInvoice(MInvoice inv) {
        boolean oneProjectInvoice = true;
        List ivlList = new Query(this.getCtx(), "C_InvoiceLine", "C_Invoice_ID=?", this.get_TrxName()).setParameters(inv.getC_Invoice_ID()).setOrderBy("C_Project_ID").list();
        int C_Project_ID = ((MInvoiceLine)ivlList.get(0)).getC_Project_ID();
        for (MInvoiceLine ivl : ivlList) {
            if (C_Project_ID == ivl.getC_Project_ID()) continue;
            inv.set_ValueOfColumn("oneProjectInvoice", (Object)false);
            oneProjectInvoice = false;
            break;
        }
        if (oneProjectInvoice) {
            inv.setDescription("");
        } else {
            inv.setC_Order_ID(0);
            inv.setC_Project_ID(0);
        }
        inv.saveEx();
    }

    private MInOut createShipment(MOrder order, MDocType dt, Timestamp movementDate) {
        this.log.info("For " + dt);
        MInOut shipment = new MInOut(order, dt.getC_DocTypeShipment_ID(), movementDate);
        if (!shipment.save(this.get_TrxName())) {
            return null;
        }
        for (MOrderLine oLine : order.getLines(true, null)) {
            BigDecimal MovementQty = oLine.getQtyOrdered().subtract(oLine.getQtyDelivered());
            if (MovementQty.compareTo(Env.ZERO) <= 0) continue;
            MInOutLine ioLine = new MInOutLine(shipment);
            int M_Locator_ID = MStorage.getM_Locator_ID(oLine.getM_Warehouse_ID(), oLine.getM_Product_ID(), oLine.getM_AttributeSetInstance_ID(), MovementQty, this.get_TrxName());
            if (M_Locator_ID == 0) {
                MWarehouse wh = MWarehouse.get(this.getCtx(), oLine.getM_Warehouse_ID());
                M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
            }
            ioLine.setOrderLine(oLine, M_Locator_ID, MovementQty);
            ioLine.setQty(MovementQty);
            if (oLine.getQtyEntered().compareTo(oLine.getQtyOrdered()) != 0) {
                ioLine.setQtyEntered(MovementQty.multiply(oLine.getQtyEntered()).divide(oLine.getQtyOrdered(), 6, 4));
            }
            if (ioLine.save(this.get_TrxName())) continue;
            return null;
        }
        if (shipment.getLines(true).length == 0) {
            shipment.deleteEx(true);
            return null;
        }
        if (!shipment.processIt("CO")) {
            throw new AdempiereException("Error al procesar entrega " + order.getDocumentNo());
        }
        shipment.saveEx(this.get_TrxName());
        if (!"CO".equals(shipment.getDocStatus())) {
            return null;
        }
        return shipment;
    }

    private Boolean oLineExists(MInOutLine ioLine) {
        if (this.m_invoice == null) {
            return false;
        }
        for (MInvoiceLine ivl : this.m_invoice.getLines(true)) {
            if (ivl.getC_OrderLine_ID() != ioLine.getC_OrderLine_ID()) continue;
            return true;
        }
        return false;
    }
}

