/*
 * Decompiled with CFR 0.152.
 */
package org.shw.process;

import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MDocType;
import org.compiere.model.MOrder;
import org.compiere.model.MProject;
import org.compiere.model.MUser;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;

public class SHW_ProjectCreateQuotation
extends SvrProcess {
    private Boolean P_IsSOTrx = false;
    private int P_C_BPartner_ID = 0;
    private int P_C_DocType_ID = 0;
    private int P_User1_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] parameters;
        for (ProcessInfoParameter para : parameters = this.getParameter()) {
            String name = para.getParameterName();
            if (para.getParameter() == null) continue;
            if (name.equals("IsSOTrx")) {
                this.P_IsSOTrx = para.getParameterAsBoolean();
                continue;
            }
            if (name.equals("C_BPartner_ID")) {
                this.P_C_BPartner_ID = para.getParameterAsInt();
                continue;
            }
            if (name.equals("C_DocType_ID")) {
                this.P_C_DocType_ID = para.getParameterAsInt();
                continue;
            }
            if (name.equals("User1_ID")) {
                this.P_User1_ID = para.getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        Properties A_Ctx = this.getCtx();
        int A_Record_ID = this.getRecord_ID();
        String A_TrxName = this.get_TrxName();
        String Docbasetype = this.P_IsSOTrx != false ? "SOO" : "POO";
        MProject project = new MProject(A_Ctx, A_Record_ID, A_TrxName);
        String whereClause = "";
        whereClause = project.isSummary() && this.P_IsSOTrx != false ? "c_project_parent_ID=?" : "c_project_ID=?";
        List projects = new Query(this.getCtx(), "C_Project", whereClause, this.get_TrxName()).setParameters(project.getC_Project_ID()).list();
        for (MProject detailproject : projects) {
            MOrder order = new MOrder(A_Ctx, 0, A_TrxName);
            order.setAD_Org_ID(detailproject.getAD_Org_ID());
            order.setC_Campaign_ID(detailproject.getC_Campaign_ID());
            order.setC_Project_ID(detailproject.getC_Project_ID());
            order.setDescription(detailproject.getName());
            Timestamp ts = detailproject.getDateContract();
            if (ts != null) {
                order.setDateOrdered(ts);
            }
            if ((ts = project.getDateFinish()) != null) {
                order.setDatePromised(ts);
            }
            MBPartner bpartner = null;
            if (this.P_IsSOTrx.booleanValue()) {
                order.setC_BPartner_ID(detailproject.getC_BPartner_ID());
                bpartner = (MBPartner)detailproject.getC_BPartner();
                order.setAD_User_ID(detailproject.getAD_User_ID());
                order.setSalesRep_ID(detailproject.getSalesRep_ID());
                int c_DocType_ID = bpartner.get_ValueAsInt("C_DocType_ID") <= 0 ? MDocType.getDocType(Docbasetype) : bpartner.get_ValueAsInt("C_DocType_ID");
                order.setC_DocTypeTarget_ID(c_DocType_ID);
                order.setIsSOTrx(true);
            } else {
                order.setC_BPartner_ID(this.P_C_BPartner_ID);
                bpartner = new MBPartner(A_Ctx, this.P_C_BPartner_ID, A_TrxName);
                MUser[] contacts = bpartner.getContacts(true);
                if (contacts.length > 0) {
                    order.setAD_User_ID(contacts[0].getAD_User_ID());
                }
                order.setSalesRep_ID(Env.getContextAsInt(Env.getCtx(), "#AD_User_ID"));
                int c_DocType_ID = 0;
                c_DocType_ID = this.P_C_DocType_ID == 0 ? (bpartner.get_ValueAsInt("C_DoctypePO_ID") <= 0 ? MDocType.getDocType(Docbasetype) : bpartner.get_ValueAsInt("C_DoctypePO_ID")) : this.P_C_DocType_ID;
                order.setC_DocTypeTarget_ID(c_DocType_ID);
                order.setIsSOTrx(false);
            }
            order.setC_BPartner_Location_ID(bpartner.getPrimaryC_BPartner_Location_ID());
            order.setM_Warehouse_ID(project.getM_Warehouse_ID());
            if (order.isSOTrx()) {
                order.setM_PriceList_ID(bpartner.getM_PriceList_ID());
                order.setC_PaymentTerm_ID(bpartner.getC_PaymentTerm_ID());
            } else {
                order.setM_PriceList_ID(bpartner.getPO_PriceList_ID());
                order.setC_PaymentTerm_ID(bpartner.getPO_PaymentTerm_ID());
            }
            if (this.P_User1_ID == 0) {
                order.setUser1_ID(detailproject.get_ValueAsInt("User1_ID"));
            } else {
                order.setUser1_ID(this.P_User1_ID);
            }
            order.setC_Activity_ID(detailproject.get_ValueAsInt("C_Activity_ID"));
            order.setDescription(detailproject.getDescription());
            order.set_ValueOfColumn("LG_Route_ID", (Object)detailproject.get_ValueAsInt("LG_Route_ID"));
            order.set_ValueOfColumn("DocumentoDeTransporte", detailproject.get_Value("DocumentoDeTransporte"));
            order.set_ValueOfColumn("CodigoDeDeclaracion", detailproject.get_Value("CodigoDeDeclaracion"));
            order.set_ValueOfColumn("ReferenciaDeDeclaracion", detailproject.get_Value("ReferenciaDeDeclaracion"));
            order.set_ValueOfColumn("Provider", detailproject.get_Value("Provider"));
            order.set_ValueOfColumn("ProviderPO", detailproject.get_Value("ProviderPO"));
            order.saveEx();
        }
        return "";
    }
}

