/*
 * Decompiled with CFR 0.152.
 */
package org.spin.model;

import java.lang.reflect.Constructor;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.adempiere.core.domains.models.X_AD_Package_Exp_Custom;
import org.adempiere.pipo.handler.GenericPOHandler;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class MADPackageExpCustom
extends X_AD_Package_Exp_Custom {
    private static final long serialVersionUID = -1171525387615789574L;
    private static CCache<Integer, MADPackageExpCustom> exporterCacheIds = new CCache("AD_Package_Exp_Custom", 30);
    private static CCache<String, MADPackageExpCustom> exporterCacheValues = new CCache("AD_Package_Exp_Custom", 30);
    private GenericPOHandler exporterHandler = null;

    public MADPackageExpCustom(Properties ctx, int AD_AppSupport_ID, String trxName) {
        super(ctx, AD_AppSupport_ID, trxName);
    }

    public MADPackageExpCustom(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MADPackageExpCustom getById(Properties ctx, int definitionId, String trxName) {
        if (definitionId <= 0) {
            return null;
        }
        MADPackageExpCustom definition = exporterCacheIds.get(definitionId);
        if (definition != null && definition.get_ID() > 0) {
            return definition;
        }
        definition = (MADPackageExpCustom)new Query(ctx, "AD_Package_Exp_Custom", "AD_Package_Exp_Custom_ID=?", trxName).setParameters(definitionId).first();
        if (definition != null && definition.get_ID() > 0) {
            String key = definition.getValue();
            exporterCacheValues.put(key, definition);
            exporterCacheIds.put(definition.get_ID(), definition);
        }
        return definition;
    }

    public static List<MADPackageExpCustom> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || exporterCacheIds.size() > 0) {
            List<MADPackageExpCustom> definitionList = new Query(Env.getCtx(), "AD_Package_Exp_Custom", null, trxName).setOrderBy("Value").list();
            definitionList.stream().forEach(definition -> {
                String key = definition.getValue();
                exporterCacheIds.put(definition.getAD_Package_Exp_Custom_ID(), (MADPackageExpCustom)definition);
                exporterCacheValues.put(key, (MADPackageExpCustom)definition);
            });
            return definitionList;
        }
        List<MADPackageExpCustom> definitionList = exporterCacheIds.entrySet().stream().map(activity -> (MADPackageExpCustom)activity.getValue()).collect(Collectors.toList());
        return definitionList;
    }

    private Class<?> getHandlerClass() {
        String className = this.getClassname();
        if (Util.isEmpty(className)) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(className);
            for (Class<?> superClazz = clazz.getSuperclass(); superClazz != null; superClazz = superClazz.getSuperclass()) {
                if (superClazz != GenericPOHandler.class) continue;
                this.log.fine("Use: " + className);
                return clazz;
            }
        }
        catch (Exception e) {
            this.log.severe(e.getMessage());
        }
        this.log.finest("Not found: " + className);
        return null;
    }

    private void loadClass() throws Exception {
        if (this.exporterHandler != null) {
            return;
        }
        Class<?> clazz = this.getHandlerClass();
        if (clazz == null) {
            this.log.log(Level.INFO, "Using Standard Functional Setting");
            this.exporterHandler = null;
            return;
        }
        Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
        this.exporterHandler = (GenericPOHandler)constructor.newInstance(new Object[0]);
    }

    public GenericPOHandler getExporterInstance() throws Exception {
        this.loadClass();
        return this.exporterHandler;
    }

    @Override
    public String toString() {
        return "MADPackageExpCustom [getAD_Package_Exp_Custom_ID()=" + this.getAD_Package_Exp_Custom_ID() + ", getClassname()=" + this.getClassname() + ", getName()=" + this.getName() + ", getValue()=" + this.getValue() + "]";
    }
}

