/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.core.domains.models.X_AD_Document_Action_Access;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MRefList;
import org.compiere.model.Query;
import org.spin.process.CreateRoleFromDocumentActionAbstract;

public class CreateRoleFromDocumentAction
extends CreateRoleFromDocumentActionAbstract {
    @Override
    protected void prepare() {
        super.prepare();
        if (this.getRecord_ID() == 0) {
            throw new AdempiereException("@AD_Role_ID@ @NotFound@");
        }
    }

    @Override
    protected String doIt() throws Exception {
        AtomicInteger documentActionsProcessed = new AtomicInteger(0);
        List<MRefList> actionsList = this.getActions();
        this.getSelectionKeys().stream().forEach(documentTypeId -> {
            this.deletePreviousDocumentActions((int)documentTypeId);
            actionsList.forEach(action -> {
                if (this.getSelectionAsBoolean((int)documentTypeId, "IsSelected_" + action.getAD_Ref_List_ID())) {
                    this.processDocumentActionAccess((int)documentTypeId, action.getAD_Ref_List_ID(), documentActionsProcessed);
                }
            });
        });
        return "@DocAction@ @Processed@ " + documentActionsProcessed.get();
    }

    private void processDocumentActionAccess(int documentTypeId, int actionToAdd, AtomicInteger actionsProcessed) {
        X_AD_Document_Action_Access access = new X_AD_Document_Action_Access(this.getCtx(), 0, this.get_TrxName());
        access.setAD_Role_ID(this.getRecord_ID());
        access.setC_DocType_ID(documentTypeId);
        access.setAD_Ref_List_ID(actionToAdd);
        access.saveEx();
        actionsProcessed.getAndAdd(1);
    }

    private List<MRefList> getActions() {
        return new Query(this.getCtx(), "AD_Ref_List", "AD_Reference_ID = ?", this.get_TrxName()).setParameters(135).list();
    }

    private void deletePreviousDocumentActions(int documentTypeId) {
        new Query(this.getCtx(), "AD_Document_Action_Access", "C_DocType_ID = ? AND AD_Role_ID= ?", this.get_TrxName()).setParameters(documentTypeId, this.getRecord_ID()).list().forEach(documentActionAccess -> documentActionAccess.delete(true));
    }
}

