/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.compiere.model.MInOutLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MUOMConversion;
import org.compiere.util.Env;
import org.spin.process.OrderRMACreateFromAbstract;

public class OrderRMACreateFrom
extends OrderRMACreateFromAbstract {
    @Override
    protected String doIt() throws Exception {
        if (this.getRecord_ID() == 0) {
            return "@C_Order_ID@ @NotFound@";
        }
        MOrder order = new MOrder(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        if (order.isProcessed()) {
            return "@C_Order_ID@ @Processed@";
        }
        AtomicInteger created = new AtomicInteger(0);
        AtomicBoolean isHeaderUpdated = new AtomicBoolean(false);
        List<Integer> recordIds = this.getSelectionKeys();
        recordIds.stream().forEach(key -> {
            int productId = this.getSelectionAsInt((int)key, "CF_M_Product_ID");
            int chargeId = this.getSelectionAsInt((int)key, "CF_C_Charge_ID");
            int uomId = this.getSelectionAsInt((int)key, "CF_C_UOM_ID");
            BigDecimal qtyEntered = this.getSelectionAsBigDecimal((int)key, "CF_QtyEntered");
            this.log.fine("Line QtyEntered=" + qtyEntered + ", Product=" + productId + ", Key=" + key);
            MOrderLine orderLine = new MOrderLine(order);
            BigDecimal qtyOrdered = null;
            int precision = 2;
            if (productId > 0) {
                MProduct product = MProduct.get(Env.getCtx(), productId);
                if (product != null) {
                    orderLine.setM_Product_ID(product.getM_Product_ID(), uomId);
                    precision = product.getUOMPrecision();
                    if (product.getC_UOM_ID() != uomId) {
                        qtyEntered = qtyEntered.setScale(precision, RoundingMode.HALF_DOWN);
                        qtyOrdered = MUOMConversion.convertProductFrom(Env.getCtx(), productId, uomId, qtyEntered);
                    }
                }
            } else if (chargeId != 0) {
                orderLine.setC_Charge_ID(chargeId);
            }
            qtyEntered = qtyEntered.setScale(precision, RoundingMode.HALF_DOWN);
            if (qtyOrdered == null) {
                qtyOrdered = qtyEntered;
            }
            MInOutLine inOutLine = new MInOutLine(this.getCtx(), (int)key, this.get_TrxName());
            MOrderLine sourceOrderLine = (MOrderLine)inOutLine.getC_OrderLine();
            if (isHeaderUpdated.compareAndSet(false, true)) {
                MOrder sourceOrder = sourceOrderLine.getParent();
                if (sourceOrder.getAD_OrgTrx_ID() != 0) {
                    order.setAD_OrgTrx_ID(sourceOrder.getAD_OrgTrx_ID());
                }
                if (sourceOrder.getC_Project_ID() != 0) {
                    order.setC_Project_ID(sourceOrder.getC_Project_ID());
                }
                if (sourceOrder.getC_Campaign_ID() != 0) {
                    order.setC_Campaign_ID(sourceOrder.getC_Campaign_ID());
                }
                if (sourceOrder.getC_Activity_ID() != 0) {
                    order.setC_Activity_ID(sourceOrder.getC_Activity_ID());
                }
                if (sourceOrder.getUser1_ID() != 0) {
                    order.setUser1_ID(sourceOrder.getUser1_ID());
                }
                if (sourceOrder.getUser2_ID() != 0) {
                    order.setUser2_ID(sourceOrder.getUser2_ID());
                }
                if (sourceOrder.getUser3_ID() != 0) {
                    order.setUser3_ID(sourceOrder.getUser3_ID());
                }
                if (sourceOrder.getUser4_ID() != 0) {
                    order.setUser4_ID(sourceOrder.getUser4_ID());
                }
                order.setM_PriceList_ID(sourceOrder.getM_PriceList_ID());
                order.saveEx();
            }
            orderLine.setRef_InOutLine(inOutLine);
            orderLine.setQty(qtyEntered);
            orderLine.setQtyOrdered(qtyOrdered);
            orderLine.setC_UOM_ID(uomId);
            orderLine.saveEx();
            created.updateAndGet(createNo -> createNo + 1);
        });
        return "@Created@ " + created.get();
    }
}

