/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.math.RoundingMode;
import java.sql.Timestamp;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MBPartner;
import org.compiere.model.MCurrency;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPayment;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.spin.process.PaymentIdentifyAbstract;

public class PaymentIdentify
extends PaymentIdentifyAbstract {
    @Override
    protected void prepare() {
        super.prepare();
        if (this.getRecord_ID() == 0) {
            throw new AdempiereException("@Record_ID@ @NotFound@");
        }
        if (this.getDateTrx() == null) {
            this.setDateTrx(new Timestamp(System.currentTimeMillis()));
        }
    }

    @Override
    protected String doIt() throws Exception {
        MPayment unidentifiedPayment = new MPayment(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        if (!unidentifiedPayment.isUnidentifiedPayment() || unidentifiedPayment.getC_Charge_ID() != 0 || unidentifiedPayment.isUnidentifiedPayment() && unidentifiedPayment.getRef_Payment_ID() != 0) {
            throw new AdempiereException("@IsUnidentifiedPayment@ @Invalid@");
        }
        if (!unidentifiedPayment.getDocStatus().equals("CO") && !unidentifiedPayment.getDocStatus().equals("CL")) {
            throw new AdempiereException("@C_Payment_ID@ @NoCompleted@");
        }
        MPayment relatedPayment = (MPayment)new Query(this.getCtx(), "C_Payment", "Ref_Payment_ID = ? AND DocStatus IN('CO', 'CL') AND IsUnidentifiedPayment = 'Y'", this.get_TrxName()).setParameters(unidentifiedPayment.getC_Payment_ID()).first();
        if (relatedPayment != null && relatedPayment.getC_Payment_ID() != 0) {
            throw new AdempiereException("@UnidentifiedReverseCreated@");
        }
        MPayment identifiedPayment = null;
        if (this.getTrxType().equals("S")) {
            identifiedPayment = new MPayment(this.getCtx(), this.getRelatedPaymentId(), this.get_TrxName());
            if (identifiedPayment.isReceipt() != unidentifiedPayment.isReceipt()) {
                throw new AdempiereException("@IsReceipt@ @Mismatched@");
            }
            if (identifiedPayment.getC_BankAccount_ID() != unidentifiedPayment.getC_BankAccount_ID()) {
                throw new AdempiereException("@C_BankAccount_ID@ @Mismatched@");
            }
            if (identifiedPayment.getC_Currency_ID() != unidentifiedPayment.getC_Currency_ID()) {
                throw new AdempiereException("@C_Currency_ID@ @Mismatched@");
            }
            int currencyId = identifiedPayment.getC_Currency_ID();
            if (currencyId == 0) {
                currencyId = identifiedPayment.getC_BankAccount().getC_Currency_ID();
            }
            int precision = MCurrency.get(this.getCtx(), identifiedPayment.getC_Currency_ID()).getStdPrecision();
            if (!identifiedPayment.getPayAmt().setScale(precision, RoundingMode.HALF_DOWN).equals(unidentifiedPayment.getPayAmt().setScale(precision, RoundingMode.HALF_DOWN))) {
                throw new AdempiereException("@PayAmt@ @Mismatched@");
            }
            if (!identifiedPayment.getDocStatus().equals("CO")) {
                throw new AdempiereException("@DocStatus@ @Mismatched@");
            }
        } else {
            identifiedPayment = new MPayment(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues(unidentifiedPayment, identifiedPayment);
            identifiedPayment.setDateTrx(this.getDateTrx());
            identifiedPayment.setDateAcct(this.getDateTrx());
            identifiedPayment.setC_BPartner_ID(this.getBPartnerId());
            identifiedPayment.setIsUnidentifiedPayment(false);
            identifiedPayment.setC_Charge_ID(-1);
            identifiedPayment.setC_Invoice_ID(-1);
            identifiedPayment.setC_Order_ID(-1);
            if (this.getOrderId() != 0) {
                identifiedPayment.setC_Order_ID(this.getOrderId());
            }
            if (this.getInvoiceId() != 0) {
                identifiedPayment.setC_Invoice_ID(this.getInvoiceId());
            }
            identifiedPayment.setDocStatus("DR");
            identifiedPayment.saveEx();
            identifiedPayment.processIt("CO");
            identifiedPayment.saveEx();
        }
        identifiedPayment.setIsReconciled(true);
        identifiedPayment.setRef_Payment_ID(unidentifiedPayment.getC_Payment_ID());
        identifiedPayment.saveEx();
        MPayment reversePayment = new MPayment(this.getCtx(), 0, this.get_TrxName());
        PO.copyValues(unidentifiedPayment, reversePayment);
        reversePayment.setRef_Payment_ID(unidentifiedPayment.getC_Payment_ID());
        reversePayment.setIsReconciled(unidentifiedPayment.isReconciled());
        reversePayment.setIsUnidentifiedPayment(true);
        reversePayment.setIsReceipt(!unidentifiedPayment.isReceipt());
        reversePayment.setPayAmt(reversePayment.getPayAmt());
        reversePayment.setDateTrx(this.getDateTrx());
        reversePayment.setDateAcct(this.getDateTrx());
        MOrgInfo organizationInfo = MOrgInfo.get(this.getCtx(), reversePayment.getAD_Org_ID(), this.get_TrxName());
        if (organizationInfo.getUnidentifiedDocumentType(reversePayment.isReceipt()) != 0) {
            reversePayment.setC_DocType_ID(organizationInfo.getUnidentifiedDocumentType(reversePayment.isReceipt()));
        } else {
            reversePayment.setC_DocType_ID(reversePayment.isReceipt());
        }
        reversePayment.setDocStatus("DR");
        reversePayment.saveEx();
        reversePayment.processIt("CO");
        reversePayment.saveEx();
        this.createAllocation(unidentifiedPayment, reversePayment);
        return "@Created@";
    }

    private void createAllocation(MPayment identifiedPayment, MPayment unidentifiedPayment) {
        MAllocationHdr allocationHdr = new MAllocationHdr(this.getCtx(), false, this.getDateTrx(), identifiedPayment.getC_Currency_ID(), Msg.translate(this.getCtx(), "C_Payment_ID") + ": " + unidentifiedPayment.getDocumentNo(), this.get_TrxName());
        allocationHdr.setAD_Org_ID(identifiedPayment.getAD_Org_ID());
        allocationHdr.setDateAcct(this.getDateTrx());
        allocationHdr.saveEx(this.get_TrxName());
        MAllocationLine allocationLine = new MAllocationLine(allocationHdr, identifiedPayment.getPayAmt(true), Env.ZERO, Env.ZERO, Env.ZERO);
        allocationLine.setDocInfo(identifiedPayment.getC_BPartner_ID(), 0, 0);
        allocationLine.setPaymentInfo(identifiedPayment.getC_Payment_ID(), 0);
        allocationLine.saveEx(this.get_TrxName());
        allocationLine = new MAllocationLine(allocationHdr, unidentifiedPayment.getPayAmt(true), Env.ZERO, Env.ZERO, Env.ZERO);
        allocationLine.setDocInfo(unidentifiedPayment.getC_BPartner_ID(), 0, 0);
        allocationLine.setPaymentInfo(unidentifiedPayment.getC_Payment_ID(), 0);
        allocationLine.saveEx(this.get_TrxName());
        if (!allocationHdr.processIt("CO")) {
            throw new AdempiereException(allocationHdr.getProcessMsg());
        }
        allocationHdr.saveEx(this.get_TrxName());
        StringBuffer info = new StringBuffer(unidentifiedPayment.getDocumentNo());
        info.append(" - @C_AllocationHdr_ID@: ").append(allocationHdr.getDocumentNo());
        if (identifiedPayment.getC_BPartner_ID() != 0) {
            MBPartner partner = new MBPartner(this.getCtx(), identifiedPayment.getC_BPartner_ID(), this.get_TrxName());
            partner.setTotalOpenBalance();
            partner.save(this.get_TrxName());
        }
        identifiedPayment.setIsAllocated(true);
        identifiedPayment.saveEx();
        unidentifiedPayment.setIsAllocated(true);
        unidentifiedPayment.saveEx();
    }
}

