/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MDocType;
import org.compiere.model.MPayment;
import org.spin.process.PaymentReturnAbstract;

public class PaymentReturn
extends PaymentReturnAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        String result = "";
        if (this.getRecord_ID() != 0) {
            MPayment payment = new MPayment(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
            result = this.generateReturn(payment, this.getDocTypeId(), this.getDocumentNo(), this.getPayDate());
        }
        return result;
    }

    private String generateReturn(MPayment parentPayment, int documentType_ID, String documentNo, Timestamp payDate) {
        Optional<Object> paymentReturn = Optional.empty();
        Optional<MAllocationHdr> paymentAllocation = Optional.empty();
        ArrayList<Optional<MPayment>> payments = new ArrayList<Optional<MPayment>>();
        AtomicReference<String> result = new AtomicReference<String>();
        AtomicReference<String> msg = new AtomicReference<String>();
        result.set("");
        msg.set("");
        if (!parentPayment.getDocStatus().equals("CO") && !parentPayment.getDocStatus().equals("CL")) {
            return "@Invalid@ @DocStatus@ -> @C_Payment_ID@ " + parentPayment.getDocumentNo();
        }
        MDocType parentDocType = (MDocType)parentPayment.getC_DocType();
        MDocType returnDocType = MDocType.get(this.getCtx(), documentType_ID);
        if (parentDocType.getDocBaseType().equals(returnDocType.getDocBaseType())) {
            return "@PaymentDocTypeInvoiceInconsistent@";
        }
        Optional<MPayment> paymentReference = Optional.ofNullable(parentPayment.getPaymentReference());
        if (paymentReference.isPresent()) {
            return "@Invalid@ @C_Payment_ID@ -> @Ref_Payment_ID@  = " + paymentReference.get().getDocumentNo();
        }
        if (parentPayment.getC_Charge_ID() != 0) {
            paymentReturn = Optional.ofNullable(this.getPayment(parentPayment, documentType_ID, documentNo, payDate));
        } else {
            paymentReturn = Optional.ofNullable(this.getPayment(parentPayment, documentType_ID, documentNo, payDate));
            List<MAllocationHdr> allocations = Arrays.asList(MAllocationHdr.getOfPayment(this.getCtx(), parentPayment.getC_Payment_ID(), this.get_TrxName()));
            allocations.forEach(mAllocationHdr -> {
                if (mAllocationHdr.getDocStatus().equals("CO")) {
                    mAllocationHdr.reverseAccrualIt();
                    mAllocationHdr.saveEx();
                }
            });
            payments.add(paymentReturn);
            payments.add(Optional.ofNullable(parentPayment));
            paymentAllocation = Optional.ofNullable(this.getAllocation(payments, payDate));
        }
        paymentReturn.ifPresent(payment -> {
            msg.set("@Created@ @C_Payment_ID@ " + payment.getDocumentNo());
            this.addLog((String)msg.get());
            result.set((String)result.get() + (String)msg.get() + "\n");
        });
        paymentAllocation.ifPresent(allocation -> {
            msg.set("@Created@ @C_AllocationHdr_ID@ " + allocation.getDocumentNo());
            this.addLog((String)msg.get());
            result.set((String)result.get() + (String)msg.get() + "\n");
        });
        return (String)result.get();
    }

    private MPayment getPayment(MPayment parentPayment, int documentType_ID, String documentNo, Timestamp payDate) {
        MPayment paymentReturn = new MPayment(this.getCtx(), 0, this.get_TrxName());
        MPayment.copyValues(parentPayment, paymentReturn);
        paymentReturn.setC_DocType_ID(documentType_ID);
        paymentReturn.setDocumentNo(documentNo);
        paymentReturn.setDateTrx(payDate);
        paymentReturn.setDateAcct(payDate);
        paymentReturn.setRef_Payment_ID(parentPayment.getC_Payment_ID());
        paymentReturn.saveEx();
        return paymentReturn;
    }

    private MAllocationHdr getAllocation(List<Optional<MPayment>> payments, Timestamp payDate) {
        AtomicReference currentAlloc = new AtomicReference();
        payments.stream().forEach(optPayment -> optPayment.ifPresent(payment -> {
            if (currentAlloc.get() == null) {
                currentAlloc.set(new MAllocationHdr(this.getCtx(), false, payDate, payment.getC_Currency_ID(), "", this.get_TrxName()));
                ((MAllocationHdr)currentAlloc.get()).save();
            }
            MAllocationLine parentLine = new MAllocationLine((MAllocationHdr)currentAlloc.get());
            parentLine.setAmount(payment.getPayAmt(true));
            parentLine.setC_Payment_ID(payment.getC_Payment_ID());
            parentLine.setC_BPartner_ID(payment.getC_BPartner_ID());
            parentLine.saveEx();
        }));
        if (currentAlloc.get() != null) {
            ((MAllocationHdr)currentAlloc.get()).processIt("CO");
            ((MAllocationHdr)currentAlloc.get()).saveEx();
        }
        return (MAllocationHdr)currentAlloc.get();
    }
}

