/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process.rpl.exp;

import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.process.rpl.exp.ExportHelper;
import org.compiere.model.MClient;
import org.compiere.model.MReplicationDocument;
import org.compiere.model.MReplicationStrategy;
import org.compiere.model.MReplicationTable;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.spin.process.rpl.exp.TestReplicationStrategyAbstract;

public class TestReplicationStrategy
extends TestReplicationStrategyAbstract {
    @Override
    protected String doIt() throws Exception {
        MReplicationStrategy replicationStrategy = new MReplicationStrategy(this.getCtx(), this.getReplicationStrategyId(), this.get_TrxName());
        if (!replicationStrategy.validateRole(Env.getAD_Role_ID(this.getCtx())).booleanValue()) {
            throw new AdempiereException("@AD_ReplicationStrategy_ID@ @AD_ReplicationRoleAccess_ID@ @Notfound@");
        }
        StringBuffer orgAccess = new StringBuffer();
        replicationStrategy.getOrgAccess().forEach(organizationAccess -> {
            if (orgAccess.length() > 0) {
                orgAccess.append(", ");
            }
            orgAccess.append(organizationAccess.getAD_Org_ID());
        });
        if (orgAccess.length() == 0) {
            throw new AdempiereException("@AD_ReplicationStrategy_ID@ @AD_ReplicationOrgAccess_ID@ @IsMandatory@");
        }
        MClient client = MClient.get(this.getCtx());
        AtomicInteger replicated = new AtomicInteger();
        replicationStrategy.getReplicationTables().forEach(replicationTable -> {
            MTable table2 = MTable.get(this.getCtx(), replicationTable.getAD_Table_ID());
            new Query(this.getCtx(), table2.getTableName(), "Updated >= ? AND Updated <= ? AND AD_Org_ID IN(" + orgAccess + ")", this.get_TrxName()).setParameters(this.getUpdatedDate(), this.getUpdatedDateTo()).setClient_ID().getIDsAsList().forEach(entityId -> {
                if (replicationTable != null) {
                    ExportHelper exportHelper = new ExportHelper(client, replicationStrategy);
                    try {
                        exportHelper.exportRecord(table2.getPO((int)entityId, this.get_TrxName()), (MReplicationTable)replicationTable, (Integer)5);
                        replicated.addAndGet(1);
                    }
                    catch (Exception exeption) {
                        this.log.severe(exeption.getLocalizedMessage());
                    }
                }
            });
        });
        replicationStrategy.getReplicationDocuments().forEach(replicationDocument -> {
            MTable table2 = MTable.get(this.getCtx(), replicationDocument.getAD_Table_ID());
            new Query(this.getCtx(), table2.getTableName(), "Updated >= ? AND Updated <= ? AND AD_Org_ID IN(" + orgAccess + ")", this.get_TrxName()).setParameters(this.getUpdatedDate(), this.getUpdatedDateTo()).setClient_ID().getIDsAsList().forEach(entityId -> {
                if (replicationDocument != null) {
                    ExportHelper exportHelper = new ExportHelper(client, replicationStrategy);
                    try {
                        exportHelper.exportRecord(table2.getPO((int)entityId, this.get_TrxName()), (MReplicationDocument)replicationDocument, (Integer)5);
                        replicated.addAndGet(1);
                    }
                    catch (Exception exeption) {
                        this.log.severe(exeption.getLocalizedMessage());
                    }
                }
            });
        });
        return "@Exported@: " + replicated.get();
    }
}

