/*
 * Decompiled with CFR 0.152.
 */
package org.spin.queue.process;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.IntStream;
import org.compiere.model.Query;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.spin.queue.model.MADQueue;
import org.spin.queue.model.MADQueueType;
import org.spin.queue.process.FlushSystemQueueAbstract;
import org.spin.queue.util.QueueLoader;
import org.spin.queue.util.QueueManager;

public class FlushSystemQueue
extends FlushSystemQueueAbstract {
    private AtomicInteger counter = new AtomicInteger();
    private AtomicInteger errors = new AtomicInteger();

    @Override
    protected String doIt() throws Exception {
        if (this.getBatchsToProcess() > 0 && this.getRecordsByBatch() > 0) {
            StringBuffer whereClause = new StringBuffer("Processed").append(" = 'N'");
            ArrayList<Comparable<Integer>> parameters = new ArrayList<Comparable<Integer>>();
            if (this.getQueueTypeId() > 0) {
                whereClause.append(" AND ").append("AD_QueueType_ID").append(" = ?");
                parameters.add(Integer.valueOf(this.getQueueTypeId()));
            }
            Timestamp now = new Timestamp(System.currentTimeMillis());
            now = TimeUtil.getDayTime(now, now);
            whereClause.append(" AND ").append("Updated").append(" < ?");
            parameters.add(now);
            AtomicReference<Timestamp> referenceTime = new AtomicReference<Timestamp>(now);
            Trx.run(transactionName -> IntStream.range(0, this.getBatchsToProcess()).forEach(page -> new Query(this.getCtx(), "AD_Queue", whereClause.toString(), transactionName).setParameters(parameters).setClient_ID().setLimit(this.getRecordsByBatch()).setOrderBy("Created").getIDsAsList().forEach(queueId -> {
                MADQueue queueToProcess = new MADQueue(this.getCtx(), (int)queueId, transactionName);
                if (this.isValidToProcess(queueToProcess, (Timestamp)referenceTime.get())) {
                    QueueManager queueManager = QueueLoader.getInstance().getQueueManager(queueToProcess.getAD_QueueType_ID()).withContext(this.getCtx()).withTransactionName(transactionName);
                    try {
                        queueManager.process(queueToProcess, this.isDeleteAfterProcess());
                        this.counter.incrementAndGet();
                    }
                    catch (Exception e) {
                        this.errors.incrementAndGet();
                        this.addLog("@AD_Queue_ID@: [" + queueToProcess + "]: " + e.getLocalizedMessage());
                        this.log.severe(queueToProcess + ": " + e.getLocalizedMessage());
                    }
                }
            })));
        }
        return "@Processed@: " + this.counter + " @Errors@: " + this.errors;
    }

    private boolean isValidToProcess(MADQueue queueToProcess, Timestamp now) {
        return this.addWaitingTime(queueToProcess).before(now);
    }

    private Timestamp addWaitingTime(MADQueue queueToProcess) {
        MADQueueType queueType = MADQueueType.getById(this.getCtx(), queueToProcess.getAD_QueueType_ID(), queueToProcess.get_TrxName());
        if (queueType.getWaitingTime() > 0 && !Util.isEmpty(queueType.getTimeUnit())) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(queueToProcess.getUpdated());
            if (queueType.getTimeUnit().equals("Y")) {
                calendar.add(1, queueType.getWaitingTime());
            } else if (queueType.getTimeUnit().equals("M")) {
                calendar.add(2, queueType.getWaitingTime());
            } else if (queueType.getTimeUnit().equals("W")) {
                calendar.add(4, queueType.getWaitingTime());
            } else if (queueType.getTimeUnit().equals("D")) {
                calendar.add(6, queueType.getWaitingTime());
            } else if (queueType.getTimeUnit().equals("H")) {
                calendar.add(11, queueType.getWaitingTime());
            } else if (queueType.getTimeUnit().equals("I")) {
                calendar.add(12, queueType.getWaitingTime());
            }
            return new Timestamp(calendar.getTimeInMillis());
        }
        return queueToProcess.getUpdated();
    }
}

