/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MQuery;
import org.compiere.model.PrintInfo;
import org.compiere.print.MPrintFormat;
import org.compiere.print.MPrintFormatItem;
import org.compiere.print.PrintData;
import org.compiere.print.PrintDataElement;
import org.compiere.print.ReportEngine;
import org.compiere.print.layout.LayoutEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Language;
import org.compiere.util.Util;

public abstract class AbstractExportFormat {
    private ReportEngine reportEngine;
    private Properties ctx;
    private String message;
    private static CLogger log = CLogger.getCLogger(AbstractExportFormat.class);
    public static final String EXPORT_FILE = "EF";
    public static final String SEND_FILE = "SE";

    public void setReportEngine(ReportEngine reportEngine) {
        this.reportEngine = reportEngine;
    }

    public void setCtx(Properties ctx) {
        this.ctx = ctx;
    }

    public ReportEngine getReportEngine() {
        return this.reportEngine;
    }

    public Properties getCtx() {
        return this.ctx;
    }

    public PrintInfo getPrintInfo() {
        if (this.reportEngine == null) {
            return null;
        }
        return this.reportEngine.getPrintInfo();
    }

    public MPrintFormat getPrintFormat() {
        if (this.reportEngine == null) {
            return null;
        }
        return this.reportEngine.getPrintFormat();
    }

    public PrintData getPrintData() {
        if (this.reportEngine == null) {
            return null;
        }
        return this.reportEngine.getPrintData();
    }

    public LayoutEngine getLayoutEngine() {
        if (this.reportEngine == null) {
            return null;
        }
        return this.reportEngine.getLayout();
    }

    public ProcessInfo getProcessInfo() {
        if (this.reportEngine == null) {
            return null;
        }
        return this.reportEngine.getProcessInfo();
    }

    public Language getLanguage() {
        if (this.reportEngine == null) {
            return Env.getLanguage(this.getCtx());
        }
        return this.reportEngine.getPrintFormat().getLanguage();
    }

    public abstract String getExtension();

    public abstract String getName();

    public boolean exportToFile(File file) {
        return false;
    }

    public boolean sendTo(File file) {
        return false;
    }

    public String getAction() {
        return EXPORT_FILE;
    }

    public boolean exportTo(File file) {
        if (Util.isEmpty(this.getAction())) {
            return false;
        }
        if (this.getAction().equals(EXPORT_FILE)) {
            return this.exportToFile(file);
        }
        if (this.getAction().equals(SEND_FILE)) {
            return this.sendTo(file);
        }
        return false;
    }

    public boolean createDelimitedFile(Writer writer, char delimiter, Language language, boolean printHeader) {
        return this.createDelimitedFile(writer, delimiter, language, printHeader, null);
    }

    public boolean createDelimitedFile(Writer writer, char delimiter, Language language, boolean printHeader, ReportEngine engine) {
        if (delimiter == '\u0000') {
            delimiter = (char)9;
        }
        try {
            MPrintFormat printFormat;
            int startAt = printHeader ? -1 : 0;
            PrintData printData = engine != null ? engine.getPrintData() : this.getPrintData();
            MPrintFormat mPrintFormat = printFormat = engine != null ? engine.getPrintFormat() : this.getPrintFormat();
            if (language == null) {
                language = this.getLanguage();
            }
            for (int row = startAt; row < printData.getRowCount(); ++row) {
                StringBuffer sb = new StringBuffer();
                if (row != -1) {
                    printData.setRowIndex(row);
                }
                boolean first = true;
                for (int col = 0; col < printFormat.getItemCount(); ++col) {
                    MPrintFormatItem item = printFormat.getItem(col);
                    if (!item.isPrinted()) continue;
                    if (first) {
                        first = false;
                    } else {
                        sb.append(delimiter);
                    }
                    if (row == -1) {
                        this.createCSVvalue(sb, delimiter, printFormat.getItem(col).getPrintName(language));
                        continue;
                    }
                    Object obj = printData.getNode((Integer)item.getAD_Column_ID());
                    if (!item.isDisplayed(printData)) {
                        obj = null;
                    }
                    String data = "";
                    if (obj != null) {
                        if (obj instanceof PrintDataElement) {
                            PrintDataElement pde = (PrintDataElement)obj;
                            if (item.isTypePrintFormat()) {
                                writer.write(sb.toString());
                                sb = new StringBuffer();
                                writer.write(Env.NL);
                                MPrintFormat format = MPrintFormat.get(this.getCtx(), item.getAD_PrintFormatChild_ID(), false);
                                format.setLanguage(language);
                                int AD_Column_ID = item.getAD_Column_ID();
                                log.info(format + " - Item=" + item.getName() + " (" + AD_Column_ID + ")");
                                String recordString = pde.getValueKey();
                                int Record_ID = 0;
                                try {
                                    Record_ID = Integer.parseInt(recordString);
                                }
                                catch (Exception e) {
                                    log.log(Level.SEVERE, "Invalid Record Key - " + recordString + " (" + e.getMessage() + ") - AD_Column_ID=" + AD_Column_ID + " - " + item);
                                }
                                MQuery query = new MQuery(format.getAD_Table_ID());
                                query.addRestriction(item.getColumnName(), "=", (Object)Record_ID);
                                format.setTranslationViewQuery(query);
                                log.fine(query.toString());
                                MPrintFormat pf = new MPrintFormat(this.getCtx(), item.getAD_PrintFormatChild_ID(), null);
                                ReportEngine childReport = new ReportEngine(this.getCtx(), pf, query, this.getPrintInfo());
                                this.createDelimitedFile(writer, delimiter, language, printHeader, childReport);
                            } else {
                                data = pde.isPKey() ? pde.getValueAsString() : pde.getValueDisplay(language);
                            }
                        } else {
                            log.log(Level.SEVERE, "Element not PrintData(Element) " + obj.getClass());
                        }
                    }
                    this.createCSVvalue(sb, delimiter, data);
                }
                writer.write(sb.toString());
                writer.write(Env.NL);
            }
            writer.flush();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(w)", e);
        }
        return true;
    }

    private void createCSVvalue(StringBuffer sb, char delimiter, String content) {
        if (content == null || content.length() == 0) {
            return;
        }
        if (delimiter == '\t') {
            sb.append(content);
            return;
        }
        boolean needMask = false;
        StringBuffer buff = new StringBuffer();
        char[] chars = content.toCharArray();
        for (int i2 = 0; i2 < chars.length; ++i2) {
            char c = chars[i2];
            if (c == '\"') {
                needMask = true;
                buff.append(c);
            } else if (!(needMask || c != delimiter && Character.isLetterOrDigit(c))) {
                needMask = true;
            }
            buff.append(c);
        }
        if (needMask) {
            sb.append('\"').append(buff).append('\"');
        } else {
            sb.append(buff);
        }
    }

    public BufferedWriter convertFile(File file) {
        OutputStreamWriter fileWriter = null;
        try {
            fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), Ini.getCharset());
        }
        catch (FileNotFoundException e) {
            log.log(Level.SEVERE, e.getLocalizedMessage());
        }
        if (fileWriter == null) {
            return null;
        }
        return new BufferedWriter(fileWriter);
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

