/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.Writer;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.print.ReportEngine;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.spin.util.AbstractExportFormat;

public class ExportFormatCSV
extends AbstractExportFormat {
    private static CLogger log = CLogger.getCLogger(ExportFormatCSV.class);

    public ExportFormatCSV(Properties ctx, ReportEngine reportEngine) {
        this.setCtx(ctx);
        this.setReportEngine(reportEngine);
    }

    @Override
    public String getExtension() {
        return "csv";
    }

    @Override
    public String getName() {
        return Msg.getMsg(Env.getCtx(), "FileCSV");
    }

    @Override
    public boolean exportToFile(File file) {
        if (this.getReportEngine() == null || this.getCtx() == null) {
            return false;
        }
        return this.createCSV(file, ',', null);
    }

    public boolean createCSV(File file, char delimiter, Language language) {
        BufferedWriter buffer = this.convertFile(file);
        if (buffer == null) {
            return false;
        }
        return this.createCSV(buffer, delimiter, language);
    }

    public boolean createCSV(Writer writer, char delimiter, Language language) {
        return this.createCSV(writer, delimiter, language, true);
    }

    public boolean createCSV(Writer writer, char delimiter, Language language, boolean printHeader) {
        boolean retValue = this.createDelimitedFile(writer, delimiter, language, printHeader);
        try {
            writer.close();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(w)", e);
        }
        return retValue;
    }
}

