/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util;

import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.print.export.PrintDataExcelExporter;
import org.compiere.print.ReportEngine;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.spin.util.AbstractExportFormat;

public class ExportFormatXLSX
extends AbstractExportFormat {
    private static CLogger log = CLogger.getCLogger(ExportFormatXLSX.class);

    public ExportFormatXLSX(Properties ctx, ReportEngine reportEngine) {
        this.setCtx(ctx);
        this.setReportEngine(reportEngine);
    }

    @Override
    public String getExtension() {
        return "xlsx";
    }

    @Override
    public String getName() {
        return Msg.getMsg(Env.getCtx(), "FileXLSX");
    }

    @Override
    public boolean exportToFile(File file) {
        return this.exportToFile(file, null);
    }

    @Deprecated
    public boolean exportToFile(File file, Language language) {
        if (this.getReportEngine() == null || this.getCtx() == null) {
            return false;
        }
        try {
            PrintDataExcelExporter exp = new PrintDataExcelExporter(this.getPrintData(), this.getPrintFormat(), true);
            if (language == null) {
                language = this.getLanguage();
            }
            exp.export(file, language);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getLocalizedMessage());
            return false;
        }
        return true;
    }
}

