/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MReportView;
import org.compiere.print.ReportEngine;
import org.compiere.util.CLogger;
import org.compiere.util.Util;
import org.spin.util.AbstractExportFormat;
import org.spin.util.ReportExport;

public class ReportExportHandler {
    private MReportView reportView;
    private ReportEngine reportEngine;
    private Properties ctx;
    private ReportExport reportExport;
    private static CLogger log = CLogger.getCLogger(ReportExportHandler.class);
    private String lastMessage;

    public ReportExportHandler(Properties ctx, ReportEngine reportEngine) {
        this.ctx = ctx;
        this.reportEngine = reportEngine;
        this.reportView = MReportView.get(ctx, reportEngine.getPrintFormat().getAD_ReportView_ID());
        this.load();
    }

    public ReportExportHandler(Properties ctx, MReportView reportView) {
        this.ctx = ctx;
        this.reportView = reportView;
        this.load();
    }

    private Class<?> getHandlerClass() {
        if (this.reportView == null || this.reportView.getAD_ReportView_ID() <= 0) {
            return null;
        }
        String className = this.reportView.getClassname();
        if (Util.isEmpty(className)) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(className);
            for (Class<?> superClazz = clazz.getSuperclass(); superClazz != null; superClazz = superClazz.getSuperclass()) {
                if (superClazz != ReportExport.class) continue;
                log.fine("Use: " + className);
                return clazz;
            }
        }
        catch (Exception e) {
            log.severe(e.getMessage());
        }
        log.finest("Not found: " + className);
        return null;
    }

    private void load() {
        Class<?> clazz = this.getHandlerClass();
        if (clazz == null) {
            log.log(Level.INFO, "Using Standard Report Export");
            this.reportExport = new ReportExport(this.ctx, this.reportEngine);
            return;
        }
        Constructor<?> constructor = null;
        try {
            constructor = clazz.getDeclaredConstructor(Properties.class, ReportEngine.class);
            this.reportExport = (ReportExport)constructor.newInstance(this.ctx, this.reportEngine);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.toString();
            }
            log.warning("No transaction Constructor for " + clazz + " (" + msg + ")");
        }
    }

    public List<AbstractExportFormat> getExportFormatList() {
        if (this.reportExport == null) {
            return null;
        }
        return this.reportExport.getExportFormatList();
    }

    @Deprecated
    public boolean exportToFile(String exportName, File file) {
        return this.exportTo(exportName, file);
    }

    public boolean exportTo(String exportName, File file) {
        if (this.reportExport == null) {
            return false;
        }
        boolean result = false;
        for (AbstractExportFormat exporter : this.getExportFormatList()) {
            if (!exporter.getName().equals(exportName)) continue;
            result = exporter.exportTo(file);
            this.lastMessage = exporter.getMessage();
        }
        return result;
    }

    public AbstractExportFormat getExporter(String exportName) {
        for (AbstractExportFormat exporter : this.getExportFormatList()) {
            if (!exporter.getName().equals(exportName)) continue;
            return exporter;
        }
        return null;
    }

    public AbstractExportFormat getExporterFromExtension(String exportExtension) {
        for (AbstractExportFormat exporter : this.getExportFormatList()) {
            if (!exporter.getExtension().equals(exportExtension)) continue;
            return exporter;
        }
        return null;
    }

    public String getLastMessage() {
        return this.lastMessage;
    }
}

