/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util;

import java.io.File;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MUser;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.spin.model.MADAppRegistration;
import org.spin.util.AbstractExportFormat;
import org.spin.util.ExportFormatXML;
import org.spin.util.support.AppSupportHandler;
import org.spin.util.support.IAppSupport;
import org.spin.util.support.mq.AbstractMessageQueue;
import org.spin.util.support.mq.PrinterMessage;

public class SendReportToQueue
extends AbstractExportFormat {
    public SendReportToQueue(Properties ctx, ReportEngine reportEngine) {
        this.setCtx(ctx);
        this.setReportEngine(reportEngine);
    }

    @Override
    public String getExtension() {
        return "";
    }

    @Override
    public String getName() {
        return Msg.getMsg(Env.getCtx(), "SendPDFToQueue");
    }

    @Override
    public boolean sendTo(File file) {
        if (this.getReportEngine() == null || this.getCtx() == null) {
            return false;
        }
        ExportFormatXML xmlExporter = new ExportFormatXML(this.getCtx(), this.getReportEngine());
        if (xmlExporter.exportToFile(file)) {
            try {
                MPrintFormat format;
                ReportEngine reportEngine;
                int appRegisteredId = Env.getContextAsInt(this.getCtx(), "#LocalPrinter_ID@");
                if (appRegisteredId <= 0) {
                    MUser currentUser = MUser.get(this.getCtx());
                    appRegisteredId = currentUser.get_ValueAsInt("DefaultPrinter_ID");
                }
                if (appRegisteredId <= 0 && (reportEngine = this.getReportEngine()) != null && (format = reportEngine.getPrintFormat()) != null) {
                    appRegisteredId = format.get_ValueAsInt("DefaultPrinter_ID");
                }
                if (appRegisteredId <= 0) {
                    throw new AdempiereException("@AD_AppRegistration_ID@ @NotFound@");
                }
                MADAppRegistration registeredApplication = MADAppRegistration.getById(this.getCtx(), appRegisteredId, null);
                IAppSupport supportedApplication = AppSupportHandler.getInstance().getAppSupport(registeredApplication);
                if (supportedApplication != null && AbstractMessageQueue.class.isAssignableFrom(supportedApplication.getClass())) {
                    AbstractMessageQueue messageQueue = (AbstractMessageQueue)supportedApplication;
                    PrinterMessage messageToPrint = new PrinterMessage(file);
                    String channel = registeredApplication.getParameterValue("TargetChannel");
                    if (Util.isEmpty(channel)) {
                        throw new AdempiereException("@PrintChannel@ @NotFound@");
                    }
                    messageQueue.connect();
                    messageQueue.publish(channel, messageToPrint);
                    messageQueue.disconnect();
                    this.setMessage("@Sent@");
                    return true;
                }
            }
            catch (Exception e) {
                throw new AdempiereException(e);
            }
        }
        return false;
    }

    @Override
    public String getAction() {
        return "SE";
    }
}

