/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.docs;

import java.io.File;
import org.compiere.model.MForm;
import org.compiere.model.PO;
import org.compiere.util.Util;
import org.spin.util.docs.AbstractDocumentationSource;
import org.spin.util.docs.AbstractTextConverter;
import org.spin.util.docs.IIndex;

public class FunctionalDocsForForm
extends AbstractDocumentationSource {
    private MForm form;
    public static final String SUB_FOLDER_NAME = "form";
    public static final String FOLDER_NAME = "functional-guide" + File.separator + "form";

    @Override
    public boolean createDocumentation(AbstractTextConverter textConverter, PO source) {
        this.form = (MForm)source;
        textConverter.addHeaderIndexName((this.getFolderName() + "/" + this.getDocumentName()).toLowerCase());
        textConverter.addSection(this.form.getName());
        textConverter.newLine();
        if (!Util.isEmpty(this.form.getDescription())) {
            textConverter.addText(this.form.getDescription());
            textConverter.newLine();
        }
        if (!Util.isEmpty(this.form.getHelp())) {
            textConverter.addSubSection("Help");
            textConverter.addText(this.form.getHelp());
            textConverter.newLine();
        }
        if (this.form.isBetaFunctionality()) {
            textConverter.addNote(this.getFeature("IsBetaFunctionality"));
        }
        return true;
    }

    @Override
    public boolean addIndex(AbstractTextConverter indexConverter, PO source) {
        this.form = (MForm)source;
        ((IIndex)((Object)indexConverter)).addIndex(this.form.getName(), this.getDocumentName().toLowerCase(), this.getFolderName(), 0);
        return true;
    }

    @Override
    public boolean createDocumentation(AbstractTextConverter textConverter) {
        return false;
    }

    @Override
    public String getFolderName() {
        return FOLDER_NAME;
    }

    @Override
    public String getDocumentName() {
        if (this.form != null) {
            return this.getValidValue("form-" + this.form.getName());
        }
        return "";
    }
}

